{capture name=path}
	<a href="{$link->getModuleLink('ph_simpleblog', 'list')}" title="{l s='Back to blog homepage' mod='ph_simpleblog'}">
		{l s='Blog' mod='ph_simpleblog'}
	</a>
	<span class="navigation-pipe">
		{$navigationPipe}
	</span> 
	<a href="{$post->category_url}">{$post->category|escape:'html':'UTF-8'}</a>
	<span class="navigation-pipe">
		{$navigationPipe}
	</span> 

	{$post->title|escape:'html':'UTF-8'}
{/capture}

{if !$is_16}
	{include file="$tpl_dir./breadcrumb.tpl"}
{/if}

{include file="$tpl_dir./errors.tpl"}

{if isset($smarty.get.confirmation)}
	<div class="success alert alert-success">
	{if $smarty.get.confirmation == 1}
		{l s='Your comment was sucessfully added.' mod='ph_simpleblog'}	
	{else}
		{l s='Your comment was sucessfully added but it will be visible after moderator approval.' mod='ph_simpleblog'}	
	{/if}
	</div><!-- .success alert alert-success -->
{/if}

<div class="ph_simpleblog simpleblog-single {if !empty($post->featured_image)}with-cover{else}without-cover{/if} simpleblog-single-{$post->id_simpleblog_post}">
	<div class="baked-head"><h3>{$post->title}</h3>
	<hr class="hr_left">
	</div>
	<div class="post-meta-info">
		{if Configuration::get('PH_BLOG_DISPLAY_DATE')}
			<span class="post-date">
				<i class="fa fa-calendar"></i> {$post->date_add|date_format:Configuration::get('PH_BLOG_DATEFORMAT')}
			</span>
		{/if}
		
		{if Configuration::get('PH_BLOG_DISPLAY_CATEGORY')}
			<span class="post-category">
				<i class="fa fa-tags"></i> <a href="{$link->getModuleLink('ph_simpleblog', 'list', ['sb_category' => $post->category_rewrite])}" title="{$post->category}">{$post->category}</a>
			</span>
		{/if}

		{if isset($post->author) && !empty($post->author) && Configuration::get('PH_BLOG_DISPLAY_AUTHOR')}
			<span class="post-author">
				<i class="fa fa-user"></i> {$post->author|escape:'html':'UTF-8'} 
			</span>
		{/if}

		{if $post->tags && Configuration::get('PH_BLOG_DISPLAY_TAGS') && isset($post->tags_list)}
			<span class="post-tags clear">
				{l s='Tags:' mod='ph_simpleblog'} 
				{foreach from=$post->tags_list item=tag name='tagsLoop'}
					{$tag}{if !$smarty.foreach.tagsLoop.last}, {/if}
				{/foreach}
			</span>
		{/if}

		{if Configuration::get('PH_BLOG_DISPLAY_LIKES')}
			<span class="post-likes">
				<a href="#" data-guest="{$cookie->id_guest}" data-post="{$post->id_simpleblog_post}" class="simpleblog-like-button">
					<i class="fa fa-heart"></i> 
					<span>{$post->likes}</span> {l s='likes'  mod='ph_simpleblog'}
				</a>
			</span>
		{/if}

		{if Configuration::get('PH_BLOG_DISPLAY_VIEWS')}
		<span class="post-views">
			<i class="fa fa-eye"></i> {$post->views|escape:'html':'UTF-8'} {l s='views'  mod='ph_simpleblog'}
		</span>
		{/if}

		{if $allow_comments eq true && Configuration::get('PH_BLOG_NATIVE_COMMENTS')}
		<span class="post-comments">
			<i class="fa fa-comments"></i> {$post->comments|escape:'html':'UTF-8'} {l s='comments'  mod='ph_simpleblog'}
		</span>
		{/if}
	</div><!-- .post-meta-info -->

	<div class="post-featured-image">
		{if $post->featured_image}
			<a href="{$post->featured_image}" title="{$post->title}" class="fancybox">
				<img src="{$post->featured_image}" alt="{$post->title}" class="img-responsive" />
			</a>
		{/if}
	</div><!-- .cover -->
		
	<div class="post-content">
		{$post->content}
	</div><!-- .post-content -->

	{* Native comments *}
	{if $allow_comments eq true && Configuration::get('PH_BLOG_NATIVE_COMMENTS')}
		{include file="./comments/layout.tpl"}
	{/if}

	{* Facebook comments *}
	{if $allow_comments eq true && !Configuration::get('PH_BLOG_NATIVE_COMMENTS')}
		{include file="./comments/facebook.tpl"}
	{/if}
			
</div><!-- .ph_simpleblog -->

{if Configuration::get('PH_BLOG_FB_INIT')}
<script>
var lang_iso = '{$lang_iso}_{$lang_iso|@strtoupper}';
{literal}(function(d, s, id) {
  var js, fjs = d.getElementsByTagName(s)[0];
  if (d.getElementById(id)) return;
  js = d.createElement(s); js.id = id;
  js.src = "//connect.facebook.net/"+lang_iso+"/all.js#xfbml=1";
  fjs.parentNode.insertBefore(js, fjs);
}(document, 'script', 'facebook-jssdk'));
{/literal}
</script>
{/if}
<script>
$(function() {
	$('body').addClass('simpleblog simpleblog-single');
});
{literal}
!function(d,s,id){var js,fjs=d.getElementsByTagName(s)[0],p=/^http:/.test(d.location)?'http':'https';if(!d.getElementById(id)){js=d.createElement(s);js.id=id;js.src=p+'://platform.twitter.com/widgets.js';fjs.parentNode.insertBefore(js,fjs);}}(document, 'script', 'twitter-wjs');

(function() {
    var po = document.createElement('script'); po.type = 'text/javascript'; po.async = true;
    po.src = 'https://apis.google.com/js/plusone.js';
    var s = document.getElementsByTagName('script')[0]; s.parentNode.insertBefore(po, s);
})();
{/literal}
</script>