<?php
/**
 * Mercadopago Payments Module for Prestashop
 *
 * @author    Rinku Kazeno <development@kazeno.co>
 *
 * @copyright Copyright (c) 2012-2015, Rinku Kazeno
 * @license   This module is licensed to the user, upon purchase
 *  from either Prestashop Addons or directly from the author,
 *  for use on a single commercial Prestashop install, plus an
 *  optional separate non-commercial install (for development/testing
 *  purposes only). This license is non-assignable and non-transferable.
 *  To use in additional Prestashop installations an additional
 *  license of the module must be purchased for each one.
 *
 *  The user may modify the source of this module to suit their
 *  own business needs, as long as no distribution of either the
 *  original module or the user-modified version is made.
 *
 *  @file-version 1.3
 */

/**
 * This file is only for Prestashop versions 1.3.x and 1.4.x
 */

require(dirname(__FILE__) . '/../../config/config.inc.php');
require(dirname(__FILE__) . '/../../init.php');
require(dirname(__FILE__) . '/mercadopago.php');

if (!$cookie->isLogged(true))
    Tools::redirect('authentication.php?back=order.php');

$mercadopago = new Mercadopago();
$data = $mercadopago->process();
if (in_array(Configuration::get(Mercadopago::CONFIG_PREFIX.'_CHECKOUT_TYPE'), array('modal', 'iframe'))) {
    include_once(dirname(__FILE__) . '/../../header.php');
    echo $mercadopago->displayCheckoutOld($data);
    include_once(dirname(__FILE__) . '/../../footer.php');
} else
    Tools::redirect($data['mpInit'], '');        //send to Mercadopago checkout
exit;
?>