<?php
/**
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author    PrestaShop SA <contact@prestashop.com>
*  @copyright 2007-2014 PrestaShop SA
*  @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

class CustomizationFieldPrice extends ObjectModel
{
    public $name;
    public $fiel_name;
    public $price;

    /**
     * @see ObjectModel::$definition
     */
    public static $definition = array(
        'table' => 'customizaton_field_price',
        'primary' => 'id_customizaton_field_price',
        'fields' => array(
            'name' => array('type' => self::TYPE_STRING, 'required' => false),
            'field_name' => array('type' => self::TYPE_STRING, 'required' => false),
            'price' => array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt', 'required' => false),
        ),
    );
    
    public static function getCustomFieldPrices() {
        $query_customization_field_lang = 'SELECT `field_name`, `name`, `price`
            
                                        FROM `'._DB_PREFIX_.'customization_field_price` ORDER BY id_customization_field_price ASC';
        return Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS($query_customization_field_lang);
    }
    
    public static function getCustomFieldbyProduct($id_product, $id_lang) {
        $query_custom_fields = 'SELECT DISTINCT(cfl.name) as name, price
                                FROM '._DB_PREFIX_.'customization_field cf
                                LEFT JOIN '._DB_PREFIX_.'customization_field_lang cfl ON (cfl.id_customization_field = cf.id_customization_field AND id_lang='.(int)$id_lang.')
                                LEFT JOIN '._DB_PREFIX_.'customization_field_price cfp ON (cfl.id_customization_field = cf.id_customization_field AND cfp.name = cfl.name)    
                                WHERE id_product = '.(int)$id_product.' GROUP BY cfl.name';
        return Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS($query_custom_fields);
    }
    
    public static function addCustomFieldPrices($id_lang) {
        $query_custom_fields = 'SELECT DISTINCT(name) as name FROM '._DB_PREFIX_.'customization_field_lang WHERE id_lang = '.(int)$id_lang;
        $custom_fields = Db::getInstance(_PS_USE_SQL_SLAVE_)->ExecuteS($query_custom_fields);
        if ($custom_fields) {	
            foreach ($custom_fields as $row) {
                $field_name = Tools::strtolower($row['name']);
                $sql_exist = 'SELECT COUNT(*) FROM '._DB_PREFIX_.'customization_field_price WHERE name = "'.pSQL($field_name).'"';
                $exist = Db::getInstance()->getValue($sql_exist);
                if ($exist == 0) {
                    $insert_custom_field_price = 'INSERT INTO `'._DB_PREFIX_.'customization_field_price`(`name`, `field_name`, `price`)
                                                    VALUES ("'.pSQL($row['name']).'", "'.pSQL($field_name).'", 0)';
                    Db::getInstance()->Execute($insert_custom_field_price);
                }
            }
        }
    }
    
    public static function setCustomFieldPrice($field_name, $price) {
        $update = 'UPDATE `'._DB_PREFIX_.'customization_field_price` SET `price` = '.(float)$price.' WHERE field_name = "'.pSQL($field_name).'"';
        Db::getInstance()->Execute($update);
    }
}