<?php

class BakedBase{

    /**
     * @var string $_thumbnailPath
     *
     * @access protected;
     */
    var $_thumbnailPath = "";

    /**
     * @var string $_thumbnailURL;
     *
     * @access protected;
     */
    var $_thumbnaiURL = "";
    var $_imagesRendered = array('thumbnail' => array(), 'mainImage' => array());

    /**
     * Set folder's path and url of thumbnail folder
     *
     */
    function setThumbPathInfo($path, $url) {
        $this->_thumbnailPath = $path;
        $this->_thumbnaiURL = $url;
        return $this;
    }

    public function setImagesRendered($name = array()) {
        $this->_imagesRendered = $name;
        return $this;
    }

    /**
     * resize image thumbail  from image source
     */
    public function generateImages($item, $params) {
        //if create main image size don't get from prestashop'
        if ($params->get("cre_main_size", 1)) {
            $main_img_size["height"] = $params->get("main_height", 100);
            if ($params->get("main_width_theme", 0))
                $main_img_size["width"] = $params->get("main_width_theme", 150);
            else
                $main_img_size["width"] = $params->get("main_width", 150);
            $item["mainImge"] = $this->resizeImage($item["mainImge"], $main_img_size);
        }
        if ($params->get("auto_renderthumb", 1)) {
            $thumb_size["height"] = $params->get("thumb_height", 35);
            $thumb_size["width"] = $params->get("thumb_width", 85);
            $item["thumbImge"] = $this->resizeImage($item["thumbImge"], $thumb_size);
        }
        return $item;
    }

    /**
     * get main image and thumb
     *
     * @param poiter $row .
     * @return void
     */
    public function parseImages($product, $params) {
        global $link;

        $isRenderedMainImage = $params->get("cre_main_size", 0);
        if (_PS_VERSION_ <= "1.5.0.17")
            $mainImageSize = $params->get("main_img_size", 'thickbox');
        else
            $mainImageSize = $params->get("main_img_size", 'thickbox_default');

        if ($isRenderedMainImage) {
            if ((int) Configuration::get('PS_REWRITING_SETTINGS') == 1)
                $product["mainImge"] = $this->getImageLink($product["link_rewrite"], $product["id_image"]);
            else
                $product["mainImge"] = $link->getImageLink($product["link_rewrite"], $product["id_image"]);
        } else
            $product["mainImge"] = $link->getImageLink($product["link_rewrite"], $product["id_image"], $mainImageSize);
        $product["thumbImge"] = $product["mainImge"];

        return $product;
    }

    public function getImageLink($name, $ids, $type = NULL) {
        global $protocol_content;

        // legacy mode or default image
        if ((Configuration::get('PS_LEGACY_IMAGES') && (file_exists(_PS_PROD_IMG_DIR_.$ids.($type ? '-'.$type : '').'.jpg'))) || strpos($ids, 'default') !== false) {
            $uri_path = _THEME_PROD_DIR_.$ids.($type ? '-'.$type : '').'.jpg';
        } else {
            // if ids if of the form id_product-id_image, we want to extract the id_image part
            $split_ids = explode('-', $ids);
            $id_image = (isset($split_ids[1]) ? $split_ids[1] : $split_ids[0]);
            $uri_path = _THEME_PROD_DIR_.Image::getImgFolderStatic($id_image).$id_image.($type ? '-'.$type : '').'.jpg';
        }

        return $protocol_content.Tools::getMediaServer($uri_path).$uri_path;
    }

}
