<?php
	if (!defined('_PS_VERSION_'))
	exit;

	class bakery extends Module
	{

	public function __construct()
	{

		$this->name = 'bakery';
		$this->tab = 'Other';
		$this->version = '1.1';
		$this->author = 'Baked Themes';
		$this->need_instance = 0;
		$this->bootstrap = true;

		parent::__construct();
		$this->displayName = $this->l('The Bakery');
		$this->description = $this->l('Whip up a fresh style in the bakery');

		$this->defaults = array(
			"headerstyle" => 1,
			"homeleftcolumn" => 1,
			"colourscheme" => "orange",
			"fonttype" => "Montserrat",
			"fonttype1" => "Arial",
			"socialicons" => "#00bed8",
			"socialiconshover" => "#32727b",
			"headertext" => "#a9a9a9",
			"navbar" => "#f9f9f9",
			"accent" => "#00bed8",
			"homeprice" => "#007d8e",
			"iconbg" => "#007d8e",
			"iconbg-hover" => "#00b2ca",
			"iconcol" => "#ffffff",
			"advertbg" => "#00b2ca",
			"searchicon" => "#ffffff",
			"searchicon_bg" => "#333333",
			"carttxt" => "#a9a9a9",
			"banner1" => "#00bed8",
			"banner1t" => "#32727b",
			"banner2" => "#ffffff",
			"banner2t" => "#ecebe2",
			"banner3" => "#32727b",
			"banner3t" => "#00bed8",
			"banner4" => "#00e0ff",
			"header" => "#ffffff",
			"effect" => "#ffffff",
			"effectstyle" => "standard",
			"titleborder" => "#e5e5e5",
			"hrcolour" => "#00b2ca",
			"blogtitle" => "#ffffff",
			"blogback" => "#007d8e",
			"blogdate" => "#ffffff",
			"blogdate_bg" => "#007d8e",
			"blogpost" => "#007d8e",
			"blogpost_bg" => "#00b2ca",
			"blogread" => "#777777",
			"sale" => "#00b2ca",
			"saletxt" => "#ffffff",
			"new" => "#00b2ca",
			"newtxt" => "#ffffff",
			"pricebar" => "#00b2ca",
			"pricebartxt" => "#ffffff",
			"price" => "#00b2ca",
			"cart" => "#00b2ca",
			"carttxt1" => "#ffffff",
			"infotab" => "#00b2ca",
			"infotabtxt" => "#ffffff",
			"dealtxt" => "#00b2ca",
			"bannertxt" => "#ffffff",
			"banner" => "#00b2ca",
			"footertop" => "#ffffff",
			"footer_bg" => "#eeeeee",
			"footersocial" => "#888888",
			"footersocial_h" => "#00bed8",
			"newsletter" => "#00bed8",
			"plane" => "#00b2ca",
			"titles" => "#444444",
			"headeru" => "#dddddd",
			"bullet" => "#00bed8",
			"bullet_h" => "#ffffff",
			"bottomlinks" => "#666666",
			"store" => "#2b6c78",
			"storet" => "#ffffff",
			"storeb" => "#f05c2a",
			"storebh" => "#12cce2",
			"storebt" => "#ffffff",
			"newsblockb" => "#ff6d3a",
			"newsblockt" => "#ffffff",
			"twit" => "#00b2ca",
			"twitt" => "#2b6c78",
			"twitl" => "#ffffff",
			"twitb" => "#0295a9",
		);
	}

	public function install()
	{
		if (parent::install() AND $this->registerHook('displayHeader'))
		{
			Configuration::updateValue('BAKERY_HEADERSTYLE', $this->defaults["headerstyle"]);
			Configuration::updateValue('BAKERY_HOMELEFTCOLUMN', $this->defaults["homeleftcolumn"]);
			Configuration::updateValue('BAKERY_COLOURSCHEME', $this->defaults["colourscheme"]);
			Configuration::updateValue('BAKERY_FONTTYPE', $this->defaults["fonttype"]);
			Configuration::updateValue('BAKERY_FONTTYPE1', $this->defaults["fonttype1"]);
			Configuration::updateValue('BAKERY_SOCIALICONS', $this->defaults["socialicons"]);
			Configuration::updateValue('BAKERY_SOCIALICONSHOVER', $this->defaults["socialiconshover"]);
			Configuration::updateValue('BAKERY_HEADERTEXT', $this->defaults["headertext"]);
			Configuration::updateValue('BAKERY_NAVBAR', $this->defaults["navbar"]);
			Configuration::updateValue('BAKERY_ACCENT', $this->defaults["accent"]);
			Configuration::updateValue('BAKERY_HOMEPRICE', $this->defaults["homeprice"]);
			Configuration::updateValue('BAKERY_ICONBG', $this->defaults["iconbg"]);
			Configuration::updateValue('BAKERY_ICONBG-HOVER', $this->defaults["iconbg-hover"]);
			Configuration::updateValue('BAKERY_ADVERTBG', $this->defaults["advertbg"]);
			Configuration::updateValue('BAKERY_ICONCOL', $this->defaults["iconcol"]);
			Configuration::updateValue('BAKERY_SEARCHICON', $this->defaults["searchicon"]);
			Configuration::updateValue('BAKERY_SEARCHICON_BG', $this->defaults["searchicon_bg"]);
			Configuration::updateValue('BAKERY_CARTTXT', $this->defaults["carttxt"]);
			Configuration::updateValue('BAKERY_HEADER', $this->defaults["header"]);
			Configuration::updateValue('BAKERY_EFFECT', $this->defaults["effect"]);
			Configuration::updateValue('BAKERY_EFFECTSTYLE', $this->defaults["effectstyle"]);
			Configuration::updateValue('BAKERY_TITLEBORDER', $this->defaults["titleborder"]);
			Configuration::updateValue('BAKERY_HRCOLOUR', $this->defaults["hrcolour"]);
			Configuration::updateValue('BAKERY_BLOGTITLE', $this->defaults["blogtitle"]);
			Configuration::updateValue('BAKERY_BLOGBACK', $this->defaults["blogback"]);
			Configuration::updateValue('BAKERY_BLOGDATE', $this->defaults["blogdate"]);
			Configuration::updateValue('BAKERY_BLOGDATE_BG', $this->defaults["blogdate_bg"]);
			Configuration::updateValue('BAKERY_BLOGPOST', $this->defaults["blogpost"]);
			Configuration::updateValue('BAKERY_BLOGREAD', $this->defaults["blogread"]);
			Configuration::updateValue('BAKERY_BLOGPOST_BG', $this->defaults["blogpost_bg"]);
			Configuration::updateValue('BAKERY_SALE', $this->defaults["sale"]);
			Configuration::updateValue('BAKERY_SALETXT', $this->defaults["saletxt"]);
			Configuration::updateValue('BAKERY_NEW', $this->defaults["new"]);
			Configuration::updateValue('BAKERY_NEWTXT', $this->defaults["newtxt"]);
			Configuration::updateValue('BAKERY_PRICEBAR', $this->defaults["pricebar"]);
			Configuration::updateValue('BAKERY_PRICEBARTXT', $this->defaults["pricebartxt"]);
			Configuration::updateValue('BAKERY_PRICE', $this->defaults["price"]);
			Configuration::updateValue('BAKERY_CART', $this->defaults["cart"]);
			Configuration::updateValue('BAKERY_CARTTXT1', $this->defaults["carttxt1"]);
			Configuration::updateValue('BAKERY_BANNER1', $this->defaults["banner1"]);
			Configuration::updateValue('BAKERY_BANNER1T', $this->defaults["banner1t"]);
			Configuration::updateValue('BAKERY_BANNER2', $this->defaults["banner2"]);
			Configuration::updateValue('BAKERY_BANNER2T', $this->defaults["banner2t"]);
			Configuration::updateValue('BAKERY_BANNER3', $this->defaults["banner3"]);
			Configuration::updateValue('BAKERY_BANNER4', $this->defaults["banner4"]);
			Configuration::updateValue('BAKERY_BANNER3T', $this->defaults["banner3t"]);
			Configuration::updateValue('BAKERY_INFOTAB', $this->defaults["infotab"]);
			Configuration::updateValue('BAKERY_INFOTABTXT', $this->defaults["infotabtxt"]);
			Configuration::updateValue('BAKERY_DEALTXT', $this->defaults["dealtxt"]);
			Configuration::updateValue('BAKERY_BANNER', $this->defaults["banner"]);
			Configuration::updateValue('BAKERY_BANNERTXT', $this->defaults["bannertxt"]);
			Configuration::updateValue('BAKERY_FOOTERTOP', $this->defaults["footertop"]);
			Configuration::updateValue('BAKERY_FOOTER_BG', $this->defaults["footer_bg"]);
			Configuration::updateValue('BAKERY_FOOTERSOCIAL', $this->defaults["footersocial"]);
			Configuration::updateValue('BAKERY_FOOTERSOCIAL_H', $this->defaults["footersocial_h"]);
			Configuration::updateValue('BAKERY_NEWSLETTER', $this->defaults["newsletter"]);
			Configuration::updateValue('BAKERY_PLANE', $this->defaults["plane"]);
			Configuration::updateValue('BAKERY_TITLES', $this->defaults["titles"]);
			Configuration::updateValue('BAKERY_HEADERU', $this->defaults["headeru"]);
			Configuration::updateValue('BAKERY_BULLET', $this->defaults["bullet"]);
			Configuration::updateValue('BAKERY_BULLET_H', $this->defaults["bullet_h"]);
			Configuration::updateValue('BAKERY_BOTTOMLINKS', $this->defaults["bottomlinks"]);
			Configuration::updateValue('BAKERY_STORE', $this->defaults["store"]);
			Configuration::updateValue('BAKERY_STORET', $this->defaults["storet"]);
			Configuration::updateValue('BAKERY_STOREB', $this->defaults["storeb"]);
			Configuration::updateValue('BAKERY_STOREBH', $this->defaults["storebh"]);
			Configuration::updateValue('BAKERY_STOREBT', $this->defaults["storebt"]);
			Configuration::updateValue('BAKERY_NEWSBLOCKB', $this->defaults["newsblockb"]);
			Configuration::updateValue('BAKERY_NEWSBLOCKT', $this->defaults["newsblockt"]);
			Configuration::updateValue('BAKERY_TWITT', $this->defaults["twitt"]);
			Configuration::updateValue('BAKERY_TWIT', $this->defaults["twit"]);
			Configuration::updateValue('BAKERY_TWITL', $this->defaults["twitl"]);
			Configuration::updateValue('BAKERY_TWITB', $this->defaults["twitb"]);
			Configuration::updateValue('BAKERY_MAP', array('1' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d10500.43550021912!2d2.3549134083511407!3d48.85613422714249!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47e66e1f06e2b70f%3A0x40b82c3688c9460!2sParis%2C+France!5e0!3m2!1sen!2suk!4v1414228237366', '2' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d10500.43550021912!2d2.3549134083511407!3d48.85613422714249!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47e66e1f06e2b70f%3A0x40b82c3688c9460!2sParis%2C+France!5e0!3m2!1sen!2suk!4v1414228237366'));
			Configuration::updateValue('BAKERY_CALL', array('1' => '+420 603 442 700', '2' => '+420 603 442 700'));
			Configuration::updateValue('BAKERY_CALL1', array('1' => '+420 281 865 541', '2' => '+420 281 865 541'));
			Configuration::updateValue('BAKERY_EMAIL', array('1' => 'support@bakedthemes.com', '2' => 'support@bakedthemes.com'));
			Configuration::updateValue('BAKERY_TWITTERBLOCK', array('1' => 'https://twitter.com/bakedthemes', '2' => 'https://twitter.com/bakedthemes'));
			Configuration::updateValue('BAKERY_FACEBOOKBLOCK', array('1' => 'https://www.facebook.com/bakedthemes?', '2' => 'https://www.facebook.com/bakedthemes?'));
			Configuration::updateValue('BAKERY_GOOGLEBLOCK', array('1' => 'http://www.bakedthemes.com', '2' => 'http://www.bakedthemes.com'));
			
		
		return true;
			
		}
		else
		{
		return false;
		}
	}

	public function uninstall()
	{

		if (!parent::uninstall() ||

				!Configuration::deleteByName('BAKERY_HEADERSTYLE') ||
				!Configuration::deleteByName('BAKERY_HOMELEFTCOLUMN') ||
				!Configuration::deleteByName('BAKERY_COLOURSCHEME') ||
				!Configuration::deleteByName('BAKERY_FONTTYPE') ||
				!Configuration::deleteByName('BAKERY_FONTTYPE1') ||
				!Configuration::deleteByName('BAKERY_SOCIALICONS') ||
				!Configuration::deleteByName('BAKERY_SOCIALICONSHOVER') ||
				!Configuration::deleteByName('BAKERY_NAVBAR') ||
				!Configuration::deleteByName('BAKERY_HEADERTEXT') ||
				!Configuration::deleteByName('BAKERY_ACCENT') ||
				!Configuration::deleteByName('BAKERY_HOMEPRICE') ||
				!Configuration::deleteByName('BAKERY_ICONBG') ||
				!Configuration::deleteByName('BAKERY_ICONBG-HOVER') ||
				!Configuration::deleteByName('BAKERY_ADVERTBG') ||
				!Configuration::deleteByName('BAKERY_ICONCOL') ||
				!Configuration::deleteByName('BAKERY_SEARCHICON') ||
				!Configuration::deleteByName('BAKERY_SEARCHICON_BG') ||
				!Configuration::deleteByName('BAKERY_CARTTXT') ||
				!Configuration::deleteByName('BAKERY_HEADER') ||
				!Configuration::deleteByName('BAKERY_EFFECT') ||
				!Configuration::deleteByName('BAKERY_EFFECTSTYLE') ||
				!Configuration::deleteByName('BAKERY_TITLEBORDER') ||
				!Configuration::deleteByName('BAKERY_HRCOLOUR') ||
				!Configuration::deleteByName('BAKERY_BLOGTITLE') ||
				!Configuration::deleteByName('BAKERY_BLOGBACK') ||
				!Configuration::deleteByName('BAKERY_BLOGDATE') ||
				!Configuration::deleteByName('BAKERY_BLOGDATE_BG') ||
				!Configuration::deleteByName('BAKERY_BLOGPOST') ||
				!Configuration::deleteByName('BAKERY_BLOGREAD') ||
				!Configuration::deleteByName('BAKERY_BLOGPOST_BG') ||
				!Configuration::deleteByName('BAKERY_SALE') ||
				!Configuration::deleteByName('BAKERY_SALETXT') ||
				!Configuration::deleteByName('BAKERY_NEW') ||
				!Configuration::deleteByName('BAKERY_NEWTXT') ||
				!Configuration::deleteByName('BAKERY_PRICEBAR') ||
				!Configuration::deleteByName('BAKERY_PRICEBARTXT') ||
				!Configuration::deleteByName('BAKERY_PRICE') ||
				!Configuration::deleteByName('BAKERY_CART') ||
				!Configuration::deleteByName('BAKERY_CARTTXT1') ||
				!Configuration::deleteByName('BAKERY_BANNER1') ||
				!Configuration::deleteByName('BAKERY_BANNER1T') ||
				!Configuration::deleteByName('BAKERY_BANNER2') ||
				!Configuration::deleteByName('BAKERY_BANNER2T') ||
				!Configuration::deleteByName('BAKERY_BANNER3') ||
				!Configuration::deleteByName('BAKERY_BANNER3T') ||
				!Configuration::deleteByName('BAKERY_BANNER4') ||
				!Configuration::deleteByName('BAKERY_INFOTAB') ||
				!Configuration::deleteByName('BAKERY_INFOTABTXT') ||
				!Configuration::deleteByName('BAKERY_DEALTXT') ||
				!Configuration::deleteByName('BAKERY_BANNER') ||
				!Configuration::deleteByName('BAKERY_BANNERTXT') ||
				!Configuration::deleteByName('BAKERY_MAP') ||
				!Configuration::deleteByName('BAKERY_CALL') ||
				!Configuration::deleteByName('BAKERY_CALL1') ||
				!Configuration::deleteByName('BAKERY_EMAIL') ||
				!Configuration::deleteByName('BAKERY_TWITTERBLOCK') ||
				!Configuration::deleteByName('BAKERY_GOOGLEBLOCK') ||
				!Configuration::deleteByName('BAKERY_FACEBOOKBLOCK') ||
				!Configuration::deleteByName('BAKERY_FOOTERTOP') ||
				!Configuration::deleteByName('BAKERY_FOOTER_BG') ||
				!Configuration::deleteByName('BAKERY_FOOTERSOCIAL') ||
				!Configuration::deleteByName('BAKERY_NEWSLETTER') ||
				!Configuration::deleteByName('BAKERY_PLANE') ||
				!Configuration::deleteByName('BAKERY_TITLES') ||
				!Configuration::deleteByName('BAKERY_HEADERU') ||
				!Configuration::deleteByName('BAKERY_BULLET') ||
				!Configuration::deleteByName('BAKERY_BULLET_H') ||
				!Configuration::deleteByName('BAKERY_BOTTOMLINKS') ||
				!Configuration::deleteByName('BAKERY_STORE') ||
				!Configuration::deleteByName('BAKERY_STORET') ||
				!Configuration::deleteByName('BAKERY_STOREB') ||
				!Configuration::deleteByName('BAKERY_STOREBH') ||
				!Configuration::deleteByName('BAKERY_STOREBT') ||
				!Configuration::deleteByName('BAKERY_NEWSBLOCKB') ||
				!Configuration::deleteByName('BAKERY_NEWSBLOCKT') ||
				!Configuration::deleteByName('BAKERY_TWITT') ||
				!Configuration::deleteByName('BAKERY_TWIT') ||
				!Configuration::deleteByName('BAKERY_TWITB') ||
				!Configuration::deleteByName('BAKERY_TWITL') 
			) 
			
			return false;
		
		return true;
	}

	public function postProcess()
	{

	}
	public function updateMap()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text_'.$language['id_lang']];

		Configuration::updateValue('BAKERY_MAP', $result);
	}
	
	public function updateCall()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text1_'.$language['id_lang']];

		Configuration::updateValue('BAKERY_CALL', $result);
	}
	
	public function updateCall1()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text2_'.$language['id_lang']];

		Configuration::updateValue('BAKERY_CALL1', $result);
	}
	

	public function updateEmail()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text3_'.$language['id_lang']];

		Configuration::updateValue('BAKERY_EMAIL', $result);
	}
	
	public function updateTwitterblock()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text4_'.$language['id_lang']];

		Configuration::updateValue('BAKERY_TWITTERBLOCK', $result);
	}
	
	public function updateFacebookblock()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text5_'.$language['id_lang']];

		Configuration::updateValue('BAKERY_FACEBOOKBLOCK', $result);
	}
	
	public function updateGoogleblock()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text6_'.$language['id_lang']];

		Configuration::updateValue('BAKERY_GOOGLEBLOCK', $result);
	}

	public function getContent()
	{
		$this->context->controller->addJS(_PS_JS_DIR_.'jquery/plugins/jquery.colorpicker.js');
		$this->context->controller->addCSS(($this->_path).'css/admin.css');

		if (Tools::isSubmit('save_editor'))
		{
			Configuration::updateValue('BAKERY_HEADERSTYLE', (int)(Tools::getValue("headerstyle")));
			Configuration::updateValue('BAKERY_HOMELEFTCOLUMN', (int)(Tools::getValue("homeleftcolumn")));
			Configuration::updateValue('BAKERY_EFFECTSTYLE', (string)(Tools::getValue("effectstyle")));
			Configuration::updateValue('BAKERY_EFFECT', (string)(Tools::getValue("effect")));
			Configuration::updateValue('BAKERY_COLOURSCHEME', (string)(Tools::getValue("colourscheme")));
			Configuration::updateValue('BAKERY_FONTTYPE', (string)(Tools::getValue("fonttype")));
			Configuration::updateValue('BAKERY_FONTTYPE1', (string)(Tools::getValue("fonttype1")));
			Configuration::updateValue('BAKERY_SOCIALICONS', (string)(Tools::getValue("socialicons")));
			Configuration::updateValue('BAKERY_SOCIALICONSHOVER', (string)(Tools::getValue("socialiconshover")));
			Configuration::updateValue('BAKERY_HEADERTEXT', (string)(Tools::getValue("headertext")));
			Configuration::updateValue('BAKERY_NAVBAR', (string)(Tools::getValue("navbar")));
			Configuration::updateValue('BAKERY_ACCENT', (string)(Tools::getValue("accent")));
			Configuration::updateValue('BAKERY_HOMEPRICE', (string)(Tools::getValue("homeprice")));
			Configuration::updateValue('BAKERY_ICONBG', (string)(Tools::getValue("iconbg")));
			Configuration::updateValue('BAKERY_ICONBG-HOVER', (string)(Tools::getValue("iconbg-hover")));
			Configuration::updateValue('BAKERY_ADVERTBG', (string)(Tools::getValue("advertbg")));
			Configuration::updateValue('BAKERY_ICONCOL', (string)(Tools::getValue("iconcol")));
			Configuration::updateValue('BAKERY_SEARCHICON', (string)(Tools::getValue("searchicon")));
			Configuration::updateValue('BAKERY_SEARCHICON_BG', (string)(Tools::getValue("searchicon_bg")));
			Configuration::updateValue('BAKERY_CARTTXT', (string)(Tools::getValue("carttxt")));
			Configuration::updateValue('BAKERY_HEADER', (string)(Tools::getValue("header")));
			Configuration::updateValue('BAKERY_TITLEBORDER', (string)(Tools::getValue("titleborder")));
			Configuration::updateValue('BAKERY_HRCOLOUR', (string)(Tools::getValue("hrcolour")));
			Configuration::updateValue('BAKERY_BLOGTITLE', (string)(Tools::getValue("blogtitle")));
			Configuration::updateValue('BAKERY_BLOGBACK', (string)(Tools::getValue("blogback")));
			Configuration::updateValue('BAKERY_BLOGDATE', (string)(Tools::getValue("blogdate")));
			Configuration::updateValue('BAKERY_BLOGDATE_BG', (string)(Tools::getValue("blogdate_bg")));
			Configuration::updateValue('BAKERY_BLOGPOST', (string)(Tools::getValue("blogpost")));
			Configuration::updateValue('BAKERY_BLOGPOST_BG', (string)(Tools::getValue("blogpost_bg")));
			Configuration::updateValue('BAKERY_BLOGREAD', (string)(Tools::getValue("blogread")));
			Configuration::updateValue('BAKERY_NEW', (string)(Tools::getValue("new")));
			Configuration::updateValue('BAKERY_NEWTXT', (string)(Tools::getValue("newtxt")));
			Configuration::updateValue('BAKERY_SALE', (string)(Tools::getValue("sale")));
			Configuration::updateValue('BAKERY_SALETXT', (string)(Tools::getValue("saletxt")));
			Configuration::updateValue('BAKERY_PRICEBAR', (string)(Tools::getValue("pricebar")));
			Configuration::updateValue('BAKERY_PRICEBARTXT', (string)(Tools::getValue("pricebartxt")));
			Configuration::updateValue('BAKERY_PRICE', (string)(Tools::getValue("price")));
			Configuration::updateValue('BAKERY_CART', (string)(Tools::getValue("cart")));
			Configuration::updateValue('BAKERY_CARTTXT1', (string)(Tools::getValue("carttxt1")));
			Configuration::updateValue('BAKERY_BANNER1', (string)(Tools::getValue("banner1")));
			Configuration::updateValue('BAKERY_BANNER1T', (string)(Tools::getValue("banner1t")));
			Configuration::updateValue('BAKERY_BANNER2', (string)(Tools::getValue("banner2")));
			Configuration::updateValue('BAKERY_BANNER2T', (string)(Tools::getValue("banner2t")));
			Configuration::updateValue('BAKERY_BANNER3', (string)(Tools::getValue("banner3")));
			Configuration::updateValue('BAKERY_BANNER3T', (string)(Tools::getValue("banner3t")));
			Configuration::updateValue('BAKERY_BANNER4', (string)(Tools::getValue("banner4")));
			Configuration::updateValue('BAKERY_INFOTAB', (string)(Tools::getValue("infotab")));
			Configuration::updateValue('BAKERY_INFOTABTXT', (string)(Tools::getValue("infotabtxt")));
			Configuration::updateValue('BAKERY_DEALTXT', (string)(Tools::getValue("dealtxt")));
			Configuration::updateValue('BAKERY_BANNER', (string)(Tools::getValue("banner")));
			Configuration::updateValue('BAKERY_BANNERTXT', (string)(Tools::getValue("bannertxt")));
			Configuration::updateValue('BAKERY_FOOTERTOP', (string)(Tools::getValue("footertop")));
			Configuration::updateValue('BAKERY_FOOTER_BG', (string)(Tools::getValue("footer_bg")));
			Configuration::updateValue('BAKERY_FOOTERSOCIAL', (string)(Tools::getValue("footersocial")));
			Configuration::updateValue('BAKERY_FOOTERSOCIAL_H', (string)(Tools::getValue("footersocial_h")));
			Configuration::updateValue('BAKERY_NEWSLETTER', (string)(Tools::getValue("newsletter")));
			Configuration::updateValue('BAKERY_PLANE', (string)(Tools::getValue("plane")));
			Configuration::updateValue('BAKERY_TITLES', (string)(Tools::getValue("titles")));
			Configuration::updateValue('BAKERY_HEADERU', (string)(Tools::getValue("headeru")));
			Configuration::updateValue('BAKERY_BULLET', (string)(Tools::getValue("bullet")));
			Configuration::updateValue('BAKERY_BULLET_H', (string)(Tools::getValue("bullet_h")));
			Configuration::updateValue('BAKERY_BOTTOMLINKS', (string)(Tools::getValue("bottomlinks")));
			Configuration::updateValue('BAKERY_STORE', (string)(Tools::getValue("store")));
			Configuration::updateValue('BAKERY_STORET', (string)(Tools::getValue("storet")));
			Configuration::updateValue('BAKERY_STOREB', (string)(Tools::getValue("storeb")));
			Configuration::updateValue('BAKERY_STOREBH', (string)(Tools::getValue("storebh")));
			Configuration::updateValue('BAKERY_STOREBT', (string)(Tools::getValue("storebt")));
			Configuration::updateValue('BAKERY_NEWSBLOCKB', (string)(Tools::getValue("newsblockb")));
			Configuration::updateValue('BAKERY_NEWSBLOCKT', (string)(Tools::getValue("newsblockt")));
			Configuration::updateValue('BAKERY_TWIT', (string)(Tools::getValue("twit")));
			Configuration::updateValue('BAKERY_TWITT', (string)(Tools::getValue("twitt")));
			Configuration::updateValue('BAKERY_TWITL', (string)(Tools::getValue("twitl")));
			Configuration::updateValue('BAKERY_TWITB', (string)(Tools::getValue("twitb")));
			Configuration::updateValue('BAKERY_CUSTOM_CSS', (string)(Tools::getValue('custom_css')));		
			Configuration::updateValue('BAKERY_FONT_CSS', (string)(Tools::getValue('font_css')));
			Configuration::updateValue('BAKERY_FONT1_CSS', (string)(Tools::getValue('font1_css')));
			$this->updateMap();
			$this->updateCall();
			$this->updateCall1();
			$this->updateEmail();
			$this->updateTwitterblock();
			$this->updateGoogleblock();
			$this->updateFacebookblock();
			$this->generateCustomCSS();
			$this->generateFontCSS();
			$this->generateFont1CSS();
			$this->generateCss();
			
			if (isset($errors) AND $errors!='')
				$this->_html .= $this -> displayError($errors);
			else
				$this->_html .= $this -> displayConfirmation($this->l('Settings updated'));
		}



		if (Tools::isSubmit('reset_editor'))
		{

			Configuration::updateValue('BAKERY_HEADERSTYLE', $this->defaults["headerstyle"]);
			Configuration::updateValue('BAKERY_HOMELEFTCOLUMN', $this->defaults["homeleftcolumn"]);
			Configuration::updateValue('BAKERY_COLOURSCHEME', $this->defaults["colourscheme"]);
			Configuration::updateValue('BAKERY_FONTTYPE', $this->defaults["fonttype"]);
			Configuration::updateValue('BAKERY_FONTTYPE1', $this->defaults["fonttype1"]);
			Configuration::updateValue('BAKERY_SOCIALICONS', $this->defaults["socialicons"]);
			Configuration::updateValue('BAKERY_SOCIALICONSHOVER', $this->defaults["socialiconshover"]);
			Configuration::updateValue('BAKERY_HEADERTEXT', $this->defaults["headertext"]);
			Configuration::updateValue('BAKERY_NAVBAR', $this->defaults["navbar"]);
			Configuration::updateValue('BAKERY_ACCENT', $this->defaults["accent"]);
			Configuration::updateValue('BAKERY_HOMEPRICE', $this->defaults["homeprice"]);
			Configuration::updateValue('BAKERY_ICONBG', $this->defaults["iconbg"]);
			Configuration::updateValue('BAKERY_ICONBG-HOVER', $this->defaults["iconbg-hover"]);
			Configuration::updateValue('BAKERY_ADVERTBG', $this->defaults["advertbg"]);
			Configuration::updateValue('BAKERY_ICONCOL', $this->defaults["iconcol"]);
			Configuration::updateValue('BAKERY_SEARCHICON', $this->defaults["searchicon"]);
			Configuration::updateValue('BAKERY_SEARCHICON_BG', $this->defaults["searchicon_bg"]);
			Configuration::updateValue('BAKERY_CARTTXT', $this->defaults["carttxt"]);
			Configuration::updateValue('BAKERY_HEADER', $this->defaults["header"]);
			Configuration::updateValue('BAKERY_EFFECT', $this->defaults["effect"]);
			Configuration::updateValue('BAKERY_EFFECTSTYLE', $this->defaults["effectstyle"]);
			Configuration::updateValue('BAKERY_TITLEBORDER', $this->defaults["titleborder"]);
			Configuration::updateValue('BAKERY_HRCOLOUR', $this->defaults["hrcolour"]);
			Configuration::updateValue('BAKERY_BLOGTITLE', $this->defaults["blogtitle"]);
			Configuration::updateValue('BAKERY_BLOGBACK', $this->defaults["blogback"]);
			Configuration::updateValue('BAKERY_BLOGDATE', $this->defaults["blogdate"]);
			Configuration::updateValue('BAKERY_BLOGDATE_BG', $this->defaults["blogdate_bg"]);
			Configuration::updateValue('BAKERY_BLOGPOST', $this->defaults["blogpost"]);
			Configuration::updateValue('BAKERY_BLOGREAD', $this->defaults["blogread"]);
			Configuration::updateValue('BAKERY_BLOGPOST_BG', $this->defaults["blogpost_bg"]);
			Configuration::updateValue('BAKERY_NEW', $this->defaults["new"]);
			Configuration::updateValue('BAKERY_NEWTXT', $this->defaults["newtxt"]);
			Configuration::updateValue('BAKERY_SALE', $this->defaults["sale"]);
			Configuration::updateValue('BAKERY_SALETXT', $this->defaults["saletxt"]);
			Configuration::updateValue('BAKERY_PRICEBAR', $this->defaults["pricebar"]);
			Configuration::updateValue('BAKERY_PRICEBARTXT', $this->defaults["pricebartxt"]);
			Configuration::updateValue('BAKERY_PRICE', $this->defaults["price"]);
			Configuration::updateValue('BAKERY_CART', $this->defaults["cart"]);
			Configuration::updateValue('BAKERY_CARTTXT1', $this->defaults["carttxt1"]);
			Configuration::updateValue('BAKERY_BANNER1', $this->defaults["banner1"]);
			Configuration::updateValue('BAKERY_BANNER1T', $this->defaults["banner1t"]);
			Configuration::updateValue('BAKERY_BANNER2', $this->defaults["banner2"]);
			Configuration::updateValue('BAKERY_BANNER2T', $this->defaults["banner2t"]);
			Configuration::updateValue('BAKERY_BANNER3', $this->defaults["banner3"]);
			Configuration::updateValue('BAKERY_BANNER3T', $this->defaults["banner3t"]);
			Configuration::updateValue('BAKERY_BANNER4', $this->defaults["banner4"]);
			Configuration::updateValue('BAKERY_INFOTAB', $this->defaults["infotab"]);
			Configuration::updateValue('BAKERY_INFOTABTXT', $this->defaults["infotabtxt"]);
			Configuration::updateValue('BAKERY_DEALTXT', $this->defaults["dealtxt"]);
			Configuration::updateValue('BAKERY_BANNER', $this->defaults["banner"]);
			Configuration::updateValue('BAKERY_BANNERTXT', $this->defaults["bannertxt"]);
			Configuration::updateValue('BAKERY_FOOTERTOP', $this->defaults["footertop"]);
			Configuration::updateValue('BAKERY_FOOTER_BG', $this->defaults["footer_bg"]);
			Configuration::updateValue('BAKERY_FOOTERSOCIAL', $this->defaults["footersocial"]);
			Configuration::updateValue('BAKERY_FOOTERSOCIAL_H', $this->defaults["footersocial_h"]);
			Configuration::updateValue('BAKERY_NEWSLETTER', $this->defaults["newsletter"]);
			Configuration::updateValue('BAKERY_PLANE', $this->defaults["plane"]);
			Configuration::updateValue('BAKERY_TITLES', $this->defaults["titles"]);
			Configuration::updateValue('BAKERY_HEADERU', $this->defaults["headeru"]);
			Configuration::updateValue('BAKERY_BULLET', $this->defaults["bullet"]);
			Configuration::updateValue('BAKERY_BULLET_H', $this->defaults["bullet_h"]);
			Configuration::updateValue('BAKERY_BOTTOMLINKS', $this->defaults["bottomlinks"]);
			Configuration::updateValue('BAKERY_STORE', $this->defaults["store"]);
			Configuration::updateValue('BAKERY_STORET', $this->defaults["storet"]);
			Configuration::updateValue('BAKERY_STOREB', $this->defaults["storeb"]);
			Configuration::updateValue('BAKERY_STOREBH', $this->defaults["storebh"]);
			Configuration::updateValue('BAKERY_STOREBT', $this->defaults["storebt"]);
			Configuration::updateValue('BAKERY_NEWSBLOCKB', $this->defaults["newsblockb"]);
			Configuration::updateValue('BAKERY_NEWSBLOCKT', $this->defaults["newsblockt"]);
			Configuration::updateValue('BAKERY_TWIT', $this->defaults["twit"]);
			Configuration::updateValue('BAKERY_TWITT', $this->defaults["twitt"]);
			Configuration::updateValue('BAKERY_TWITL', $this->defaults["twitl"]);
			Configuration::updateValue('BAKERY_TWITB', $this->defaults["twitb"]);
			Configuration::updateValue('BAKERY_CUSTOM_CSS','');
			Configuration::updateValue('BAKERY_FONT_CSS','');
			Configuration::updateValue('BAKERY_FONT1_CSS','');
			$this->generateCss();
		}



		if ($errors)
			$output .= $this->displayError($errors);


		return $output.$this->displayForm();
	}

	
	public function displayForm()
	{
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));

		$languages = Language::getLanguages(false);

		$divLangName = 'text¤title';

		$html = '';

		$html .= '

		<script type="text/javascript">

			id_language = Number('.$defaultLanguage.');

		</script>
		
		<div class="container" id="bakerystyles">
		</br>
		</br>
				<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post" enctype="multipart/form-data">
					<div>
						<ul id="tabs" class="nav nav-tabs nav-stacked col-xs-12 col-md-3" data-tabs="tabs">
							<li class="active"><a href="#general" data-toggle="tab">General Settings</a></li>
							<li><a href="#preloader" data-toggle="tab">Pre Loader Page</a></li>
							<li><a href="#colours" data-toggle="tab">Header Settings</a></li>
							<li><a href="#font" data-toggle="tab">Font Settings</a></li>
							<li><a href="#home" data-toggle="tab">Homepage Settings</a></li>
							<li><a href="#product" data-toggle="tab">Product Settings</a></li>
							<li><a href="#contact" data-toggle="tab">Contact Settings</a></li>
							<li><a href="#foot" data-toggle="tab">Footer Settings</a></li>
							<li><a href="#custom" data-toggle="tab">Custom CSS</a></li>
						</ul>
						
						<div id="my-tab-content" class="tab-content col-xs-12 col-md-9">
							<div class="tab-pane active" id="general">
								<h1>General Settings</h1>
								
								
								<label class="control-label col-lg-3">'.$this->l('Pre-defined colour schemes').'</label>
								<div class="col-lg-9">
									<select name="colourscheme">
									<option value="orange" '.((Configuration::get('BAKERY_COLOURSCHEME') == 'orange') ? 'selected="selected"' : '').' />'.$this->l('Blue').'</option>
									<option value="blue" '.((Configuration::get('BAKERY_COLOURSCHEME') == 'blue') ? 'selected="selected"' : '').' />'.$this->l('orange').'</option>
									<option value="green" '.((Configuration::get('BAKERY_COLOURSCHEME') == 'green') ? 'selected="selected"' : '').' />'.$this->l('Green').'</option>
									<option value="pink" '.((Configuration::get('BAKERY_COLOURSCHEME') == 'pink') ? 'selected="selected"' : '').' />'.$this->l('Pink').'</option>
									<option value="yellow" '.((Configuration::get('BAKERY_COLOURSCHEME') == 'yellow') ? 'selected="selected"' : '').' />'.$this->l('Yellow').'</option>
									<option value="purple" '.((Configuration::get('BAKERY_COLOURSCHEME') == 'purple') ? 'selected="selected"' : '').' />'.$this->l('Purple').'</option>
									<option value="red" '.((Configuration::get('BAKERY_COLOURSCHEME') == 'red') ? 'selected="selected"' : '').' />'.$this->l('Red').'</option>
									<option value="own" '.((Configuration::get('BAKERY_COLOURSCHEME') == 'own') ? 'selected="selected"' : '').' />'.$this->l('Create my own').'</option>
									</select>
									</br>
								<div class="alert alert-info" role="alert">These are quick settings and can only be used as they are.</br>For a fully customised site use create my own option, click save, then use further settings.</div>
								</div>
							</div>
							
							<div class="tab-pane" id="preloader">
								<h1>Pre Loader Page</h1>	
								<label class="control-label col-lg-3">'.$this->l('Page Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner2t"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER2T') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Top line').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner3"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER3') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Middle line').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner3t"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER3T') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Bottom line').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner4"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER4') . '" />
								</div>
								
							</div>	
						
							<div class="tab-pane" id="colours">
								<h1>Header Settings</h1>
								<label class="control-label col-lg-3">'.$this->l('Header Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="header"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HEADER') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Navigation Bar').'</label>
								<div class="col-lg-9">
									<input type="color" name="navbar"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NAVBAR') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Social Icons').'</label>
								<div class="col-lg-9">
									<input type="color" name="socialicons"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SOCIALICONS') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Social Icons: Hover').'</label>
								<div class="col-lg-9">
									<input type="color" name="socialiconshover"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SOCIALICONSHOVER') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Nav Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="headertext"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HEADERTEXT') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Accent colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="accent"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ACCENT') . '" />
								</div>
								
								<label class="control-label col-lg-3">'.$this->l('Search Icon').'</label>
								<div class="col-lg-9">
									<input type="color" name="searchicon"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SEARCHICON') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Search Icon Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="searchicon_bg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SEARCHICON_BG') . '" />
								</div>
								
								<label class="control-label col-lg-3">'.$this->l('Cart Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="carttxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_CARTTXT') . '" />
								</div>
																
								<h1>Banner Settings</h1>
								<label class="control-label col-lg-3">'.$this->l('Banner Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner1"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER1') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Text colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner1t"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER1T') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Text Hover colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner2"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER2') . '" />
								</div>
								
							</div>
							<div class="tab-pane" id="font">
								<h1>Font Settings</h1>	
								<label class="control-label col-lg-3">'.$this->l('Headers & Titles').'</label>
								<div class="col-lg-9">
									<textarea cols="1" rows="1" name="font_css" >'.Configuration::get('BAKERY_FONT_CSS').'</textarea>
								</div>
								<label class="control-label col-lg-3">'.$this->l('Font Name').'</label>
								<div class="col-lg-9">
								<textarea cols="1" rows="1" name="fonttype" style="width: 207px">'.Configuration::get('BAKERY_FONTTYPE').'</textarea>
								</div>
								<label class="control-label col-lg-3">'.$this->l('Body').'</label>
								<div class="col-lg-9">
									<textarea cols="1" rows="1" name="font1_css" >'.Configuration::get('BAKERY_FONT1_CSS').'</textarea>
								</div>
								<label class="control-label col-lg-3">'.$this->l('Font Name').'</label>
								<div class="col-lg-9">
								<textarea cols="1" rows="1" name="fonttype1" style="width: 207px">'.Configuration::get('BAKERY_FONTTYPE1').'</textarea>
								</div>
							</div>	
							<div class="tab-pane" id="home">
								<h1>Homepage Settings</h1>
							
								<label class="control-label col-lg-3">'.$this->l('Title borders').'</label>
								<div class="col-lg-9">
									<input type="color" name="titleborder"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_TITLEBORDER') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Accent').'</label>
								<div class="col-lg-9">
									<input type="color" name="hrcolour"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HRCOLOUR') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Price').'</label>
								<div class="col-lg-9">
									<input type="color" name="homeprice"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HOMEPRICE') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Icon Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="iconbg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ICONBG') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Icon Hover Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="iconbg-hover"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ICONBG-HOVER') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Icon Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="iconcol"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ICONCOL') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Advert Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="advertbg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ADVERTBG') . '" />
								</div>
								<h1>Store Locator</h1>
								<label class="control-label col-lg-3">'.$this->l('Block Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="store"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_STORE') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Block Text / Border').'</label>
								<div class="col-lg-9">
									<input type="color" name="storet"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_STORET') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Button').'</label>
								<div class="col-lg-9">
									<input type="color" name="storeb"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_STOREB') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Button Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="storebh"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_STOREBH') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Button Hover').'</label>
								<div class="col-lg-9">
									<input type="color" name="storebt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_STOREBT') . '" />
								</div>
								<h1>Newsletter Block</h1>
								<label class="control-label col-lg-3">'.$this->l('Color behind title').'</label>
								<div class="col-lg-9">
									<input type="color" name="newsblockb"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NEWSBLOCKB') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Text / Border Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="newsblockt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NEWSBLOCKT') . '" />
								</div>
								<h1>Twitter Feed</h1>
								<label class="control-label col-lg-3">'.$this->l('Block Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="twit"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_TWIT') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Text Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="twitt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_TWITT') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Links Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="twitl"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_TWITL') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Bird Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="twitb"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_TWITB') . '" />
								</div>
								<h1>Recent Posts</h1>
								<label class="control-label col-lg-3">'.$this->l('Block Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogback"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGBACK') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Title colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogtitle"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGTITLE') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Image Border').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogdate_bg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGDATE_BG') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Read more colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogread"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGREAD') . '" />
								</div>
								<h1>Testimonials</h1>
								<label class="control-label col-lg-3">'.$this->l('Background Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogpost_bg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGPOST_BG') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogdate"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGDATE') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Quote icon').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogpost"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGPOST') . '" />
								</div>
							</div>
							
							<div class="tab-pane" id="product">
								<h1>Product Settings</h1>
								<label class="control-label col-lg-3">'.$this->l('Sale label').'</label>
								<div class="col-lg-9">
									<input type="color" name="sale"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SALE') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Sale text').'</label>
								<div class="col-lg-9">
									<input type="color" name="saletxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SALETXT') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('New label').'</label>
								<div class="col-lg-9">
									<input type="color" name="new"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NEW') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('New text').'</label>
								<div class="col-lg-9">
									<input type="color" name="newtxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NEWTXT') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Price bar').'</label>
								<div class="col-lg-9">
									<input type="color" name="pricebar"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_PRICEBAR') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Price bar content').'</label>
								<div class="col-lg-9">
									<input type="color" name="pricebartxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_PRICEBARTXT') . '" />
								</div>
								<h1>Product Page</h1>
								<label class="control-label col-lg-3">'.$this->l('Price').'</label>
								<div class="col-lg-9">
									<input type="color" name="price"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_PRICE') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Add to cart button').'</label>
								<div class="col-lg-9">
									<input type="color" name="cart"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_CART') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Add to cart text').'</label>
								<div class="col-lg-9">
									<input type="color" name="carttxt1"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_CARTTXT1') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Info tabs').'</label>
								<div class="col-lg-9">
									<input type="color" name="infotab"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_INFOTAB') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Info tabs text').'</label>
								<div class="col-lg-9">
									<input type="color" name="infotabtxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_INFOTABTXT') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Deal countdown').'</label>
								<div class="col-lg-9">
									<input type="color" name="dealtxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_DEALTXT') . '" />
								</div>
							
							</div>
							
							<div class="tab-pane" id="contact">
								<h1>Contact Settings</h1>
								<label class="control-label col-lg-3">'.$this->l('Banner').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Banner Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="bannertxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNERTXT') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Map Location').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px; border-radius: 3px; border-right: 1px solid #ccc" name="text_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_MAP', $language['id_lang']).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Contact number').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text1_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text1_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_CALL', $language['id_lang']).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Second/Fax number').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text2_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text2_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_CALL1', $language['id_lang']).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Email').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text3_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text3_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_EMAIL', $language['id_lang']).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Twitter link').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text4_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text4_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_TWITTERBLOCK', $language['id_lang']).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Facebook link').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text5_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text5_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_FACEBOOKBLOCK', $language['id_lang']).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Google link').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text6_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text6_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_GOOGLEBLOCK', $language['id_lang']).'" />
									</div>';

									$html .= '</div>
								
							</div>
							
							<div class="tab-pane" id="foot">
								<h1>Footer Settings</h1>
								<label class="control-label col-lg-3">'.$this->l('Top/Bottom Bar').'</label>
								<div class="col-lg-9">
									<input type="color" name="footertop"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_FOOTERTOP') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="footer_bg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_FOOTER_BG') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Social Icons').'</label>
								<div class="col-lg-9">
									<input type="color" name="footersocial"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_FOOTERSOCIAL') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Social Icons Hover').'</label>
								<div class="col-lg-9">
									<input type="color" name="footersocial_h"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_FOOTERSOCIAL_H') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Newsletter Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="newsletter"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NEWSLETTER') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Submit button').'</label>
								<div class="col-lg-9">
									<input type="color" name="plane"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_PLANE') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Titles').'</label>
								<div class="col-lg-9">
									<input type="color" name="titles"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_TITLES') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Header underline').'</label>
								<div class="col-lg-9">
									<input type="color" name="headeru"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HEADERU') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Bullet').'</label>
								<div class="col-lg-9">
									<input type="color" name="bullet"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BULLET') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Bullet Hover').'</label>
								<div class="col-lg-9">
									<input type="color" name="bullet_h"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BULLET_H') . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="bottomlinks"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BOTTOMLINKS') . '" />
								</div>
							</div>
							<div class="tab-pane" id="custom">
								<h1>Custom CSS</h1>
								<textarea cols="12" rows="12" name="custom_css">'.Configuration::get('BAKERY_CUSTOM_CSS').'</textarea>
							</div>
					
						</div>
					</div>
					<div class="col-lg-3">
					</div>
					<div class="buttonarea col-lg-9">
						<input id="save_editor" type="submit" class="button-save btn btn-primary btn-lg pull-right" value="'.$this->l('Save').'" name="save_editor">
					</div>
				</form>
				
		</div>';

		return $html;
	}
	
	public function generateCustomCSS()
	{
		if (Configuration::get('BAKERY_CUSTOM_CSS'))
		{
			$css = Configuration::get('BAKERY_CUSTOM_CSS');
			$myFile = $this->local_path."css/custom.css";
			$fh = fopen($myFile, 'w') or die("can't open file");
			fwrite($fh, $css);
			fclose($fh);
		}
	}
	
	public function generateFontCSS()
	{
		if (Configuration::get('BAKERY_FONT_CSS'))
		{
			$css = Configuration::get('BAKERY_FONT_CSS');
			$myFile = $this->local_path."css/font.css";
			$fh = fopen($myFile, 'w') or die("can't open file");
			fwrite($fh, $css);
			fclose($fh);
		}
		
	}
	
	public function generateFont1CSS()
	{
		if (Configuration::get('BAKERY_FONT1_CSS'))
		{
			$css = Configuration::get('BAKERY_FONT1_CSS');
			$myFile = $this->local_path."css/font1.css";
			$fh = fopen($myFile, 'w') or die("can't open file");
			fwrite($fh, $css);
			fclose($fh);
		}
		
	}

	public function generateCss()
	{
		$css .= '';

		if (Configuration::get('BAKERY_SOCIALICONS')){
		 $css .= '#bakedsocial li [class^="bakedicon-"], #bakedsocial li [class*=" bakedicon-"] {color: ' . Configuration::get('BAKERY_SOCIALICONS') . ' !important}';}
		
		if (Configuration::get('BAKERY_SOCIALICONSHOVER')){
		 $css .= '#bakedsocial li:hover [class^="bakedicon-"], #bakedsocial li:hover [class*=" bakedicon-"] {color: ' . Configuration::get('BAKERY_SOCIALICONSHOVER') . ' !important} ';	}
		
		if (Configuration::get('BAKERY_HEADERTEXT')){
		$css .= '#currencies-block-top div.current, .header_user_info a {color: ' . Configuration::get('BAKERY_HEADERTEXT') . ' !important}';}
		
		if (Configuration::get('BAKERY_NAVBAR')){
		$css .= 'header .nav {background: ' . Configuration::get('BAKERY_NAVBAR') . ' !important}';}
		
		if (Configuration::get('BAKERY_ACCENT')){
		$css .= '#currencies-block-top div.current strong, #currencies-block-top div.current:after, #footer .price, .bakedproductinfo_block [class^="icon-"]  {color: ' . Configuration::get('BAKERY_ACCENT') . ' !important}';
		$css .= '.baked-featuredslider .next, .baked-featuredslider .prev, #contact #center_column .hr_left, .baked-newproductsslider .next, .baked-newproductsslider .prev {background: ' . Configuration::get('BAKERY_ACCENT') . ' !important}';
		}
		
		if (Configuration::get('BAKERY_HOMEPRICE')){
		$css .= '.baked-newproductsslider .entry-content .entry-price, .baked-featuredslider .entry-content .entry-price, #category .entry-price, .infoinner .entry-price {color: ' . Configuration::get('BAKERY_HOMEPRICE') . ' !important}';}
		
		if (Configuration::get('BAKERY_ICONBG')){
		$css .= '#index li .quick-view, li .quick-view, li .button.ajax_add_to_cart_button, li .add_to_compare, li .addToWishlist {background: ' . Configuration::get('BAKERY_ICONBG') . ' !important}';}
		
		if (Configuration::get('BAKERY_ICONBG-HOVER')){
		$css .= '#index li .quick-view:hover, li .quick-view:hover, li .button.ajax_add_to_cart_button:hover, li .add_to_compare:hover, li .addToWishlist:hover {background: ' . Configuration::get('BAKERY_ICONBG-HOVER') . ' !important}';}
		
		if (Configuration::get('BAKERY_ICONCOL')){
		$css .= '#index li .quick-view, li .quick-view, li .button.ajax_add_to_cart_button, li .add_to_compare, li .addToWishlist {color: ' . Configuration::get('BAKERY_ICONCOL') . ' !important}';}
		
		if (Configuration::get('BAKERY_ADVERTBG')){
		$css .= '.advertblock, .lookbookadvert {background: ' . Configuration::get('BAKERY_ADVERTBG') . ' !important; border: 5px solid ' . Configuration::get('BAKERY_ADVERTBG') . ' !important}';}
				
		if (Configuration::get('BAKERY_SEARCHICON')){
		$css .= '.menusearch {color: ' . Configuration::get('BAKERY_SEARCHICON') . ' !important}';}
		
		if (Configuration::get('BAKERY_SEARCHICON_BG')){
		$css .= '.menusearch {background: ' . Configuration::get('BAKERY_SEARCHICON_BG') . ' !important}';}
		
		if (Configuration::get('BAKERY_CARTTXT')){
		$css .= '.shopping_cart > a:first-child b, .shopping_cart > a:first-child {color: ' . Configuration::get('BAKERY_CARTTXT') . ' !important}';}
		
		if (Configuration::get('BAKERY_HEADER')){
		$css .= '#header {background: ' . Configuration::get('BAKERY_HEADER') . ' !important}';}
		
		if (Configuration::get('BAKERY_EFFECT')){
		$css .= '#FINALmenu .top-link-wrapper span:before, #FINALmenu .top-link-wrapper a::before, #FINALmenu .top-link-wrapper span:after, #FINALmenu .top-link-wrapper a::after {background: ' . Configuration::get('BAKERY_EFFECT') . ' !important}';}
		
		if (Configuration::get('BAKERY_TITLEBORDER')){
		$css .= '.baked-featured h3.featured-title,  .baked-head h4, #bakedbrands h4, .ph_simpleblog h4 {border: 2px solid ' . Configuration::get('BAKERY_TITLEBORDER') . ' !important}';}
		
		if (Configuration::get('BAKERY_HRCOLOUR')){
		$css .= '#backToTop:hover, .label-success , ul.step li.step_current, ul.step li.step_done, ul.step li.step_current, .reveal-modal form button {background-color: ' . Configuration::get('BAKERY_HRCOLOUR') . ' !important} #wishlist_button:before, #categories_block_left li a:hover:before {color: ' . Configuration::get('BAKERY_HRCOLOUR') . ' !important} figcaption span {background: ' . Configuration::get('BAKERY_HRCOLOUR') . ' } .baked-deal .baked-sale, .content_sortPagiBar .display li.selected, .subinfo:before, #show_result #closedform {background: ' . Configuration::get('BAKERY_HRCOLOUR') . ' !important } .special-price{color: ' . Configuration::get('BAKERY_HRCOLOUR') . ' !important } ';
		}
		
		if (Configuration::get('BAKERY_BLOGTITLE')){
		$css .= '#index .ph_simpleblog .simpleblog-posts h5 a, #index .ph_simpleblog .simpleblog-posts h5 {color: ' . Configuration::get('BAKERY_BLOGTITLE') . ' !important} .ph_simpleblog .simpleblog-posts h2::before, .ph_simpleblog .simpleblog-posts h2::after {background: ' . Configuration::get('BAKERY_BLOGTITLE') . ' !important}';}

		if (Configuration::get('BAKERY_BLOGBACK')){
		$css .= '.simpleblog-recent:before {background: ' . Configuration::get('BAKERY_BLOGBACK') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BLOGDATE')){
		$css .= '#index .testimonial-title, #index #testimonials .testimonial-body, #testimonials .testimonial-date{color: ' . Configuration::get('BAKERY_BLOGDATE') . ' !important} ';}
	
		if (Configuration::get('BAKERY_BLOGDATE_BG')){
		$css .= '#index .ph_simpleblog img{border: 3px solid ' . Configuration::get('BAKERY_BLOGDATE_BG') . ' !important} ';
		$css .= '.blog-date{background: ' . Configuration::get('BAKERY_BLOGDATE_BG') . ' !important} '
	
		;}
		
		if (Configuration::get('BAKERY_BLOGPOST')){
		$css .= '#index #testimonials .testimonial-body:before, #index #testimonials .testimonial-body:after{color: ' . Configuration::get('BAKERY_BLOGPOST') . ' !important} ';}
	
		if (Configuration::get('BAKERY_BLOGPOST_BG')){
		$css .= '#index #block_testimonials:before {background: ' . Configuration::get('BAKERY_BLOGPOST_BG') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BLOGREAD')){
		$css .= '.post-read-more a {color: ' . Configuration::get('BAKERY_BLOGREAD') . ' !important} ';}
		
		if (Configuration::get('BAKERY_NEW')){
		$css .= '#index .list-featured li span.new, .new-box {background: ' . Configuration::get('BAKERY_NEW') . ' !important} ';}
		
		if (Configuration::get('BAKERY_NEW')){
		$css .= '.new-box:before {color: ' . Configuration::get('BAKERY_NEW') . ' !important} ';}
		
		if (Configuration::get('BAKERY_NEWTXT')){
		$css .= '#index .list-featured li span.new, .new-box {color: ' . Configuration::get('BAKERY_NEWTXT') . ' !important} ';}
		
		if (Configuration::get('BAKERY_SALE')){
		$css .= '.on_sale {background: ' . Configuration::get('BAKERY_SALE') . ' !important} ';}
		
		if (Configuration::get('BAKERY_SALE')){
		$css .= '.on_sale:before {color: ' . Configuration::get('BAKERY_SALE') . ' !important} ';}
		
		if (Configuration::get('BAKERY_SALETXT')){
		$css .= '.on_sale {color: ' . Configuration::get('BAKERY_SALETXT') . ' !important} ';}
		
		if (Configuration::get('BAKERY_PRICEBAR')){
		$css .= 'figure.effect-zoe figcaption, #category figcaption span{background: ' . Configuration::get('BAKERY_PRICEBAR') . ' !important} ';}
		
		if (Configuration::get('BAKERY_PRICEBARTXT')){
		$css .= 'figure.effect-zoe figcaption span a, #category figure.effect-zoe h2 {color: ' . Configuration::get('BAKERY_PRICEBARTXT') . ' !important} ';}
		
		if (Configuration::get('BAKERY_PRICE')){
		$css .= '.our_price_display {color: ' . Configuration::get('BAKERY_PRICE') . ' !important} ';}
		
		if (Configuration::get('BAKERY_CART')){
		$css .= '#add_to_cart button {background: ' . Configuration::get('BAKERY_CART') . ' !important} ';}
		
		if (Configuration::get('BAKERY_CARTTXT1')){
		$css .= '#add_to_cart button, #add_to_cart:before {color: ' . Configuration::get('BAKERY_CARTTXT1') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER1')){
		$css .= '.bakedbanner_block:before, .bakedbanner_block li{background: ' . Configuration::get('BAKERY_BANNER1') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER1T')){
		$css .= '.bakedbanner_block li {color: ' . Configuration::get('BAKERY_BANNER1T') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER2')){
		$css .= '#index .bakedbanner_block li:hover  {color: ' . Configuration::get('BAKERY_BANNER2') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER2T')){
		$css .= '#loader-wrapper .loader-section  {background: ' . Configuration::get('BAKERY_BANNER2T') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER3')){
		$css .= '#loader { border-top-color: ' . Configuration::get('BAKERY_BANNER3') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER3T')){
		$css .= '#loader:before{ border-top-color: ' . Configuration::get('BAKERY_BANNER3T') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER4')){
		$css .= '#loader:after  { border-top-color: ' . Configuration::get('BAKERY_BANNER4') . ' !important} ';}
		
		if (Configuration::get('BAKERY_INFOTAB')){
		$css .= '.idTabs a.selected {background: ' . Configuration::get('BAKERY_INFOTAB') . ' !important} ul.idTabs li a:hover {color: ' . Configuration::get('BAKERY_INFOTAB') . ' !important} ';}
		
		if (Configuration::get('BAKERY_INFOTABTXT')){
		$css .= '.idTabs a.selected, .idTabs a.selected:hover  {color: ' . Configuration::get('BAKERY_INFOTABTXT') . ' !important} ';}
		
		if (Configuration::get('BAKERY_DEALTXT')){
		$css .= '#product .deal-clock div {color: ' . Configuration::get('BAKERY_DEALTXT') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER')){
		$css .= '.contact-block {background: ' . Configuration::get('BAKERY_BANNER') . ' !important} 
		.contact-block .right-block:before {border-color: transparent transparent transparent ' . Configuration::get('BAKERY_BANNER') . ' !important} 
		.contact-block .description .phone {color: ' . Configuration::get('BAKERY_BANNER') . ' !important}
		';}
		
		if (Configuration::get('BAKERY_BANNERTXT')){
		$css .= '.contact-block .left-block span, .contact-block .left-block .paper-plane:after {color: ' . Configuration::get('BAKERY_BANNERTXT') . ' !important} .contact-block .left-block span {border-right: 1px solid ' . Configuration::get('BAKERY_BANNERTXT') . ' !important} ';}
		
		if (Configuration::get('BAKERY_FOOTERTOP')){
		$css .= '.topfooter-container, .bottomfooter-container {background: ' . Configuration::get('BAKERY_FOOTERTOP') . ' !important} ';}
		
		if (Configuration::get('BAKERY_FOOTER_BG')){
		$css .= '.footer-container {background: ' . Configuration::get('BAKERY_FOOTER_BG') . ' !important} ';}
		
		if (Configuration::get('BAKERY_FOOTERSOCIAL')){
		$css .= '#social_block [class^="bakedicon-"], #social_block [class*=" baked-"] {color: ' . Configuration::get('BAKERY_FOOTERSOCIAL') . ' !important} ';}
		
		if (Configuration::get('BAKERY_FOOTERSOCIAL_H')){
		$css .= '#social_block [class^="bakedicon-"]:hover, #social_block [class*=" baked-"]:hover {color: ' . Configuration::get('BAKERY_FOOTERSOCIAL_H') . ' !important} ';}
		
		if (Configuration::get('BAKERY_NEWSLETTER')){
		$css .= '#index #newsletter_block_left h4, #index #newsletter_block_left p {color: ' . Configuration::get('BAKERY_NEWSLETTER') . ' !important} ';}
		
		if (Configuration::get('BAKERY_PLANE')){
		$css .= '#index #newsletter_block_left .button.button-small{background: ' . Configuration::get('BAKERY_PLANE') . ' !important} ';}
		
		if (Configuration::get('BAKERY_TITLES')){
		$css .= '#bakedadvafooterfooter h2{color: ' . Configuration::get('BAKERY_TITLES') . ' !important} ';}
		
		if (Configuration::get('BAKERY_HEADERU')){
		$css .= '#bakedadvafooterfooter h2{border-bottom: 1px solid ' . Configuration::get('BAKERY_HEADERU') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BULLET')){
		$css .= '#bakedadvafooterfooter li.link a:before{color: ' . Configuration::get('BAKERY_BULLET') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BULLET_H')){
		$css .= '#bakedadvafooterfooter li.link:hover a:before{color: ' . Configuration::get('BAKERY_BULLET_H') . ' !important} ';}
		
		if (Configuration::get('BAKERY_BOTTOMLINKS')){
		$css .= '.footer-container #footer a, .footer-container #footer, .footer-container #footer p {color: ' . Configuration::get('BAKERY_BOTTOMLINKS') . ' !important} ';}
		
		if (Configuration::get('BAKERY_STORE')){
		$css .= '#index .store-content {background: ' . Configuration::get('BAKERY_STORE') . ' !important} 
		.store-content h2, #index .store-content:before {background: ' . Configuration::get('BAKERY_STORE') . ' !important} 
		';}
		
		if (Configuration::get('BAKERY_STORET')){
		$css .= '.store-content h2, .store-content label, .store-content div.selector span, #index .store-content:before{color: ' . Configuration::get('BAKERY_STORET') . ' !important} 
		.store-content .container{border-color: ' . Configuration::get('BAKERY_STORET') . ' !important} 
		';}
		
		if (Configuration::get('BAKERY_STOREB')){
		$css .= '.store-content .findastore input{background: ' . Configuration::get('BAKERY_STOREB') . ' !important} 
		';}
		
		if (Configuration::get('BAKERY_STOREBT')){
		$css .= '.store-content .findastore input{background: ' . Configuration::get('BAKERY_STOREBT') . ' !important} 
		';}
		
		if (Configuration::get('BAKERY_STOREBH')){
		$css .= '.store-content .findastore input:hover{color: ' . Configuration::get('BAKERY_STOREBH') . ' !important} 
		';}
		
		if (Configuration::get('BAKERY_NEWSBLOCKB')){
		$css .= '#index #newsletter_block_left h2{background: ' . Configuration::get('BAKERY_NEWSBLOCKB') . ' !important} 
		';}
		
		if (Configuration::get('BAKERY_NEWSBLOCKT')){
		$css .= '#index #newsletter_block_left h2 {color: ' . Configuration::get('BAKERY_NEWSBLOCKT') . ' !important} 
		#index #newsletter_block_left .block_content {border-color: ' . Configuration::get('BAKERY_NEWSBLOCKT') . ' !important}
		';}
		
		if (Configuration::get('BAKERY_TWIT')){
		$css .= '#bakedtweets, #bakedtweets .tw_title{background: ' . Configuration::get('BAKERY_TWIT') . ' !important} 
		';}
		
		if (Configuration::get('BAKERY_TWITT')){
		$css .= '#bakedtweets .tw_title, #bakedtweets .tweet, #bakedtweets .query{color: ' . Configuration::get('BAKERY_TWITT') . ' !important} 
		#bakedtweets .tweet, #bakedtweets .query {border-color: ' . Configuration::get('BAKERY_TWITT') . ' !important}
		';}
		
		if (Configuration::get('BAKERY_TWITL')){
		$css .= '#bakedtweets .tweet_list li a{color: ' . Configuration::get('BAKERY_TWITL') . ' !important} 
		';}
		
		if (Configuration::get('BAKERY_TWITB')){
		$css .= '#bakedtweets:before{color: ' . Configuration::get('BAKERY_TWITB') . ' !important} 
		';}
		
		if (Configuration::get('BAKERY_FONTTYPE')){
		$css .= 'h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6, .page-heading, .blog-date, .testimonial-title, .block .title_block a, .block h4 a, .block .title_block a, .block h4, .block .title_block  {font-family: ' . Configuration::get('BAKERY_FONTTYPE') . ' !important} ';}
		
		if (Configuration::get('BAKERY_FONTTYPE1')){
		$css .= 'body, .button.button-small, .button.ajax_add_to_cart_button , .button.lnk_view, .price.product-price ,  .price-percent-reduction.small, .new-box, .on_sale, .block .products-block .price-percent-reduction, .page-heading span.heading-counter, #instant_search_results a.close  {font-family: ' . Configuration::get('BAKERY_FONTTYPE1') . ' !important} ';}
		
		if (Configuration::get('BAKERY_HOMELEFTCOLUMN')== 0){
		 $css .= '
				';}	
				
	
				
		if (Configuration::get('BAKERY_COLOURSCHEME')=='blue'){
		$css .= '.searchicon, #backToTop:hover, .label-success , ul.step li.step_current, ul.step li.step_done, ul.step li.step_current, .reveal-modal form button {background: #f15e00 !important;}
				#currencies-block-top div.current strong, #currencies-block-top div.current:after {color: #f15e00 !important;}
				.bag, .baked-newproductsslider .entry-content .entry-price, .baked-featuredslider .entry-content .entry-price, #category .entry-price,  .infoinner .entry-price {color: #f15e00 !important;}
				.hr_left, #index #newsletter_block_left .button.button-small {background-color: #f15e00 !important;}
				.on_sale {background: #f15e00 !important;}
				#index .list-featured li span.new, .new-box, #contact #center_column .hr_left {background: #f15e00 !important;}
				figcaption span {background: #f15e00;}
				#wishlist_button:before, #categories_block_left li a:hover:before, #category li .star_on:after {color: #f15e00!important;}
				.baked-deal .baked-sale, .content_sortPagiBar .display li.selected, .subinfo:before {background: #f15e00 !important;}
				#social_block [class^="bakedicon-"]:hover, #social_block [class*=" baked-"]:hover {color: #f15e00 !important}
				figure.effect-zoe figcaption, #category figcaption span, .blog-date {background: #f15e00 !important;}
				.our_price_display, .bakedproductinfo_block [class^="icon-"], .post-read-more a  {color: #f15e00 !important;}
				#add_to_cart button, #index #block_testimonials:before {background: #f15e00 !important;}
				#product .deal-clock div, .special-price, li .star_on:after {color: #f15e00 !important}
				.idTabs a.selected,#index li .quick-view:hover, li .quick-view:hover, li .button.ajax_add_to_cart_button:hover, li .add_to_compare:hover, li .addToWishlist:hover {background: #f15e00 !important;}
				ul.idTabs li a:hover, .new-box:before, .on_sale:before, #bakedadvafooterfooter li.link a:before, #footer .price, .menusearch {color: #f15e00 !important;}
				.contact-block, .baked-featuredslider .next, .baked-featuredslider .prev, .baked-newproductsslider .next, .baked-newproductsslider .prev {background: #f15e00 !important;}
				.contact-block .right-block:before {border-color: transparent transparent transparent #f15e00 !important;}
				.contact-block .description .phone, .bakedbanner_block li, .baked-featuredslider .entry-content .entry-price, .baked-newproductsslider .entry-content .entry-price {color: #f15e00 !important;}
				li .quick-view, #index li .quick-view, #category li .quick-view, li .button.ajax_add_to_cart_button, li .add_to_compare, li .addToWishlist {background: #f15e00 !important;}
				.advertblock, .lookbookadvert  {background: #f15e00 !important; border:5px solid #f15e00 !important;}
				#index .ph_simpleblog img {border:3px solid #f15e00 !important;}

		';
		}
		if (Configuration::get('BAKERY_COLOURSCHEME')=='green'){
		$css .= '.searchicon, #backToTop:hover, .label-success , ul.step li.step_current,  ul.step li.step_done, ul.step li.step_current, .reveal-modal form button {background: #acd661 !important;}
				#currencies-block-top div.current strong, #currencies-block-top div.current:after {color: #acd661 !important;}
				.bag, .baked-newproductsslider .entry-content .entry-price, .baked-featuredslider .entry-content .entry-price, #category .entry-price,  .infoinner .entry-price {color: #acd661 !important;}
				.hr_left, #index #newsletter_block_left .button.button-small {background-color: #acd661 !important;}
				.on_sale {background: #acd661 !important;}
				#index .list-featured li span.new, .new-box, #contact #center_column .hr_left, .blog-date {background: #acd661 !important;}
				figcaption span {background: #acd661;}
				#wishlist_button:before, #categories_block_left li a:hover:before, #category li .star_on:after, .menusearch {color: #acd661!important;}
				.baked-deal .baked-sale, .content_sortPagiBar .display li.selected, .subinfo:before {background: #acd661 !important;}
			
				#social_block [class^="bakedicon-"]:hover, #social_block [class*=" baked-"]:hover, .post-read-more a {color: #acd661 !important}
				figure.effect-zoe figcaption, #category figcaption span, li .quick-view, #index li .quick-view, #category li .quick-view, li .button.ajax_add_to_cart_button, li .add_to_compare, li .addToWishlist  {background: #acd661 !important;}
				.our_price_display, .bakedproductinfo_block [class^="icon-"]  {color: #acd661 !important;}
				#add_to_cart button,#index li .quick-view:hover, li .quick-view:hover, li .button.ajax_add_to_cart_button:hover, li .add_to_compare:hover, li .addToWishlist:hover {background: #acd661 !important;}
				#product .deal-clock div, .new-box:before, .on_sale:before, #bakedadvafooterfooter li.link a:before {color: #acd661 !important}
				.idTabs a.selected, #index #block_testimonials:before {background: #acd661 !important;}
				ul.idTabs li a:hover, .special-price,  li .star_on:after, #footer .price {color: #acd661 !important;}
				.contact-block, .baked-featuredslider .next, .baked-featuredslider .prev, .baked-newproductsslider .next, .baked-newproductsslider .prev {background: #acd661 !important;}
				.contact-block .right-block:before {border-color: transparent transparent transparent #acd661 !important;}
				.contact-block .description .phone, .bakedbanner_block li, .baked-featuredslider .entry-content .entry-price, .baked-newproductsslider .entry-content .entry-price {color: #acd661 !important;}
				.advertblock, .lookbookadvert  {background: #acd661 !important; border:5px solid #acd661 !important;}
				#index .ph_simpleblog img {border:3px solid #acd661 !important;}
		';
		}
		
		if (Configuration::get('BAKERY_COLOURSCHEME')=='pink'){
		$css .= '.searchicon, #backToTop:hover, .label-success , ul.step li.step_current, ul.step li.step_done, ul.step li.step_current, .reveal-modal form button {background: #e9547e !important;}
				#currencies-block-top div.current strong, #currencies-block-top div.current:after {color: #e9547e !important;}
				.bag, .baked-newproductsslider .entry-content .entry-price, .baked-featuredslider .entry-content .entry-price, #category .entry-price,  .infoinner .entry-price {color: #e9547e !important;}
				.hr_left {background-color: #e9547e !important;}
				.on_sale, #index #newsletter_block_left .button.button-small, #contact #center_column .hr_left {background: #e9547e !important;}
				#index .list-featured li span.new, .new-box, li .quick-view, #index li .quick-view, #category li .quick-view, li .button.ajax_add_to_cart_button, li .add_to_compare, li .addToWishlist  {background: #e9547e !important;}
				figcaption span {background: #e9547e;}
				#wishlist_button:before, #categories_block_left li a:hover:before, .post-read-more a {color: #e9547e!important;}
				.baked-deal .baked-sale, .content_sortPagiBar .display li.selected, .subinfo:before {background: #e9547e !important;}
				
				#social_block [class^="bakedicon-"]:hover, #social_block [class*=" baked-"]:hover, #category li .star_on:after {color: #e9547e !important}
				figure.effect-zoe figcaption, #category figcaption span, .blog-date {background: #e9547e !important;}
				.our_price_display, .bakedproductinfo_block [class^="icon-"]  {color: #e9547e !important;}
				#add_to_cart button,#index li .quick-view:hover, li .quick-view:hover, li .button.ajax_add_to_cart_button:hover, li .add_to_compare:hover, li .addToWishlist:hover {background: #e9547e !important;}
				#product .deal-clock div, .special-price, li .star_on:after, .menusearch {color: #e9547e !important}
				.idTabs a.selected, #index #block_testimonials:before {background: #e9547e !important;}
				ul.idTabs li a:hover, .new-box:before, .on_sale:before, #bakedadvafooterfooter li.link a:before, #footer .price {color: #e9547e !important;}
				.contact-block, .baked-featuredslider .next, .baked-featuredslider .prev, .baked-newproductsslider .next, .baked-newproductsslider .prev {background: #e9547e !important;}
				.contact-block .right-block:before {border-color: transparent transparent transparent #e9547e !important;}
				.contact-block .description .phone, .bakedbanner_block li, .baked-featuredslider .entry-content .entry-price, .baked-newproductsslider .entry-content .entry-price {color: #e9547e !important;}
				.advertblock, .lookbookadvert  {background: #e9547e !important; border:5px solid #e9547e !important;}
				#index .ph_simpleblog img {border:3px solid #e9547e !important;}
			
		';
		}
		
		if (Configuration::get('BAKERY_COLOURSCHEME')=='yellow'){
		$css .= '.searchicon, #backToTop:hover, .label-success , ul.step li.step_current,  ul.step li.step_done, ul.step li.step_current, .reveal-modal form button {background: #f1c50e !important;}
				#currencies-block-top div.current strong, #currencies-block-top div.current:after {color: #f1c50e !important;}
				.bag, .bakedproductinfo_block [class^="icon-"], .baked-newproductsslider .entry-content .entry-price, .baked-featuredslider .entry-content .entry-price, #category .entry-price,  .infoinner .entry-price  {color: #f1c50e !important;}
				.hr_left {background-color: #f1c50e !important;}
				.on_sale,#index li .quick-view:hover, li .quick-view:hover, li .button.ajax_add_to_cart_button:hover, li .add_to_compare:hover, li .addToWishlist:hover {background: #f1c50e !important;}
				#index .list-featured li span.new, .new-box {background: #f1c50e !important;}
				figcaption span, #index #newsletter_block_left .button.button-small, #contact #center_column .hr_left {background: #f1c50e !important;}
				#wishlist_button:before, #categories_block_left li a:hover:before, #bakedadvafooterfooter li.link a:before, .post-read-more a {color: #f1c50e!important;}
				.baked-deal .baked-sale, .content_sortPagiBar .display li.selected, .subinfo:before {background: #f1c50e !important;}
				
				#social_block [class^="bakedicon-"]:hover, #social_block [class*=" baked-"]:hover {color: #f1c50e !important}
				figure.effect-zoe figcaption, #category figcaption span, .blog-date {background: #f1c50e !important;}
				.our_price_display, .new-box:before, .on_sale:before, .menusearch {color: #f1c50e !important;}
				#add_to_cart button, li .quick-view, #index li .quick-view, #category li .quick-view, li .button.ajax_add_to_cart_button, li .add_to_compare, li .addToWishlist  {background: #f1c50e !important;}
				#product .deal-clock div, .special-price, #category li .star_on:after, li .star_on:after, #footer .price {color: #f1c50e !important}
				.idTabs a.selected, #index #block_testimonials:before {background: #f1c50e !important;}
				ul.idTabs li a:hover {color: #f1c50e !important;}
				.contact-block, .baked-featuredslider .next, .baked-featuredslider .prev, .baked-newproductsslider .next, .baked-newproductsslider .prev {background: #f1c50e !important;}
				.contact-block .right-block:before {border-color: transparent transparent transparent #f1c50e !important;}
				.contact-block .description .phone, .bakedbanner_block li, .baked-featuredslider .entry-content .entry-price, .baked-newproductsslider .entry-content .entry-price {color: #f1c50e !important;}
				.advertblock, .lookbookadvert  {background: #f1c50e !important; border:5px solid #f1c50e !important;}
				#index .ph_simpleblog img {border:3px solid #f1c50e !important;}
		';
		}
		
		if (Configuration::get('BAKERY_COLOURSCHEME')=='purple'){
		$css .= '.searchicon, #backToTop:hover, .label-success , ul.step li.step_current,  ul.step li.step_done, ul.step li.step_current, .reveal-modal form button {background: #b38fb1 !important;}
				#currencies-block-top div.current strong, #currencies-block-top div.current:after, .post-read-more a {color: #b38fb1 !important;}
				.bag, .bakedproductinfo_block [class^="icon-"], .menusearch, .baked-newproductsslider .entry-content .entry-price, .baked-featuredslider .entry-content .entry-price, #category .entry-price,  .infoinner .entry-price  {color: #b38fb1 !important;}
				.hr_left,#index li .quick-view:hover, li .quick-view:hover, li .button.ajax_add_to_cart_button:hover, li .add_to_compare:hover, li .addToWishlist:hover {background-color: #b38fb1 !important;}
				.on_sale, #index #newsletter_block_left .button.button-small, #contact #center_column .hr_left {background: #b38fb1 !important;}
				#index .list-featured li span.new, .new-box, .blog-date {background: #b38fb1 !important;}
				figcaption span {background: #b38fb1;}
				#wishlist_button:before, #categories_block_left li a:hover:before, #category li .star_on:after {color: #b38fb1!important;}
				.baked-deal .baked-sale, .content_sortPagiBar .display li.selected, .subinfo:before {background: #b38fb1 !important;}
				
				#social_block [class^="bakedicon-"]:hover, #social_block [class*=" baked-"]:hover {color: #b38fb1 !important}
				figure.effect-zoe figcaption, #category figcaption span {background: #b38fb1 !important;}
				.our_price_display {color: #b38fb1 !important;}
				#add_to_cart button, li .quick-view, #index li .quick-view, #category li .quick-view, li .button.ajax_add_to_cart_button, li .add_to_compare, li .addToWishlist  {background: #b38fb1 !important;}
				#product .deal-clock div, .new-box:before, .on_sale:before, #bakedadvafooterfooter li.link a:before {color: #b38fb1 !important}
				.idTabs a.selected, #index #block_testimonials:before {background: #b38fb1 !important;}
				ul.idTabs li a:hover, .special-price, .bakedbanner_block li, li .star_on:after, #footer .price {color: #b38fb1 !important;}
				.contact-block, .baked-featuredslider .next, .baked-featuredslider .prev, .baked-newproductsslider .next, .baked-newproductsslider .prev {background: #b38fb1 !important;}
				.contact-block .right-block:before {border-color: transparent transparent transparent #b38fb1 !important;}
				.contact-block .description .phone, .baked-featuredslider .entry-content .entry-price, .baked-newproductsslider .entry-content .entry-price {color: #b38fb1 !important;}
				.advertblock, .lookbookadvert  {background: #b38fb1 !important; border:5px solid #b38fb1 !important;}
				#index .ph_simpleblog img {border:3px solid #b38fb1 !important;}
		';
		}
		
		if (Configuration::get('BAKERY_COLOURSCHEME')=='red'){
		$css .= '.searchicon, #backToTop:hover, .label-success , ul.step li.step_current,  ul.step li.step_done, ul.step li.step_current, .reveal-modal form button {background: #bb1010 !important;}
				#currencies-block-top div.current strong, #currencies-block-top div.current:after, .post-read-more a {color: #bb1010 !important;}
				.baked-newproductsslider .entry-content .entry-price, .baked-featuredslider .entry-content .entry-price, #category .entry-price,  .infoinner .entry-price, .bag, .bakedproductinfo_block [class^="icon-"], .menusearch, .baked-featuredslider .entry-content .entry-price, .baked-newproductsslider .entry-content .entry-price  {color: #bb1010 !important;}
				.hr_left,#index li .quick-view:hover, li .quick-view:hover, li .button.ajax_add_to_cart_button:hover, li .add_to_compare:hover, li .addToWishlist:hover {background-color: #bb1010 !important;}
				.on_sale, #index #newsletter_block_left .button.button-small, #contact #center_column .hr_left {background: #bb1010 !important;}
				#index .list-featured li span.new, .new-box {background: #bb1010 !important;}
				figcaption span {background: #bb1010;}
				#wishlist_button:before, #categories_block_left li a:hover:before {color: #bb1010!important;}
				.baked-deal .baked-sale, .content_sortPagiBar .display li.selected, .subinfo:before {background: #bb1010 !important;}
		
				#social_block [class^="bakedicon-"]:hover, #social_block [class*=" baked-"]:hover, #category li .star_on:after, li .star_on:after {color: #bb1010 !important}
				figure.effect-zoe figcaption, #category figcaption span, #index #block_testimonials:before {background: #bb1010 !important;}
				.our_price_display {color: #bb1010 !important;}
				#add_to_cart button, .blog-date {background: #bb1010 !important;}
				#product .deal-clock div, .new-box:before, .on_sale:before, #bakedadvafooterfooter li.link a:before, #footer .price {color: #bb1010 !important}
				.idTabs a.selected, li .quick-view, #index li .quick-view, #category li .quick-view, li .button.ajax_add_to_cart_button, li .add_to_compare, li .addToWishlist  {background: #bb1010 !important;}
				ul.idTabs li a:hover, .special-price, .bakedbanner_block li{color: #bb1010 !important;}
				.contact-block, .baked-featuredslider .next, .baked-featuredslider .prev, .baked-newproductsslider .next, .baked-newproductsslider .prev {background: #bb1010 !important;}
				.contact-block .right-block:before {border-color: transparent transparent transparent #bb1010 !important;}
				.contact-block .description .phone {color: #bb1010 !important;}
				.advertblock, .lookbookadvert  {background: #bb1010  !important; border:5px solid #bb1010  !important;}
				#index .ph_simpleblog img {border:3px solid #bb1010  !important;}
			
		';
		}
		
		
		$myFile = $this->local_path."css/bakery.css";

		$fh = fopen($myFile, 'w') or die("can't open file");

		fwrite($fh, $css);

		fclose($fh);
	}



	function hookHeader()
	{
		
		$theme_settings = array(
			'headerstyle' => (Configuration::get('BAKERY_HEADERSTYLE')),
			'colourscheme' => (Configuration::get('BAKERY_COLOURSCHEME')),
			'effectstyle' => (Configuration::get('BAKERY_EFFECTSTYLE')),
			'map' => (Configuration::get('BAKERY_MAP', $this->context->language->id)),
			'call' => (Configuration::get('BAKERY_CALL', $this->context->language->id)),
			'call1' => (Configuration::get('BAKERY_CALL1', $this->context->language->id)),
			'email' => (Configuration::get('BAKERY_EMAIL', $this->context->language->id)),
			'twitterblock' => (Configuration::get('BAKERY_TWITTERBLOCK', $this->context->language->id)),
			'facebookblock' => (Configuration::get('BAKERY_FACEBOOKBLOCK', $this->context->language->id)),
			'googleblock' => (Configuration::get('BAKERY_GOOGLEBLOCK', $this->context->language->id)),
			);
	
		$this->context->smarty->assign('baked_vars', $theme_settings);

		if (Configuration::get('BAKERY_CUSTOM_CSS') !='')
			$this->context->controller->addCSS(($this->_path).'css/custom.css', 'all');
			$this->context->controller->addCSS(($this->_path).'css/font.css', 'all');
			$this->context->controller->addCSS(($this->_path).'css/font1.css', 'all');
		$this->context->controller->addCSS(($this->_path).'css/bakery.css', 'all');
	}

}