<?php

class BakedTestimonialAddTestimonialModuleFrontController extends ModuleFrontController
{
	/**
	 * @see FrontController::initContent()
	 */
	public function initContent()
	{
		parent::initContent();
		$this->context->smarty->assign('imgUpload', Configuration::get('TESTIMONIAL_MAX_IMG'));
		$this->context->smarty->assign('allowupload', Configuration::get('TESTIMONIAL_DISPLAY_IMG'));
		$this->context->smarty->assign('imgSize', Configuration::get('TESTIMONIAL_DISPLAY_IMG'));
		$this->setTemplate('addtestimonial.tpl');
	}

	public function process()
	{
		if (Tools::isSubmit('testimonial'))
		{
			//get the submitter name and clean it
			$testimonial_submitter_name = $this->module->cleanInput($_POST['testimonial_submitter_name']);
			$testimonialPassed  = true;
			//validate the submitter name
			if (!$this->module->field_validator('Name', $testimonial_submitter_name, '2', '20', '1'))
			 {
				$errors[] = $this->module->l('Please enter a name - between 1 and 20 characters long. Please use numbers and letters only');
				$testimonialPassed = false;
			}

		   //get the testimonial title and clean it
		   $testimonial_title = $this->module->cleanInput($_POST['testimonial_title']);
		   //validate the testimonial title

			if (!$this->module->field_validator('Name', $testimonial_title, '2', '40', '1'))
			{
				$errors[] = $this->module->l('Please enter a Summary between 1 and 40 characters long. Please use numbers and letters only');
				$testimonialPassed = false;
			}

		   //get the testimonial body and clean it
		   $testimonial_main_message = $this->module->cleanInput($_POST['testimonial_main_message']);
		   //validate the testimonial body
			if (!$this->module->field_validator('Your Testimonial', $testimonial_main_message, '2', '250', '1'))
			 {
				$errors[] = $this->module->l('Please enter a testimonial between 1 and 250 characters long. Please use numbers and letters only');
				$testimonialPassed = false;
			 }

			 //Check for an uploaded image and validate it
			if (isset($_FILES["testimonial_img"]["size"]) && ($_FILES["testimonial_img"]["size"] > 0))  //does a file exist?
			{

				 $extension = $this->module->checkImageExt();
				   if (!$extension) {  //does its extension match .jpg, .jpeg or .png
					   $errors[] = $this->module->l('Only files with .jpg, .jpeg or .png files allowed use numbers and letters only');
				   $testimonialPassed = false;
				}
				//code to check file size
			   if (!$this->module->checkfileSize())  {
				   $errors[] = $this->module->l('That file is too large!');
				  $testimonialPassed = false;
			   }
			  else
			  {
				  $uploadFile = true;
				  $testimonialPassed = true;
			  }
		   }

			if ($testimonialPassed)
			 {
				 $confirmation = 1;
				  if ($uploadFile){ //check to see if an image was uploaded and complete upload process
					$testimonial_img =  $this->module->uploadImage();
				  }
				 $this->module->writeTestimonial($testimonial_title,$testimonial_submitter_name,$testimonial_main_message,$testimonial_img);
			 }

			$this->context->smarty->assign('t_errors', $errors);

			// $testimonial_submitter_name add add it to the view for displaying
			$this->context->smarty->assign('testimonial_submitter_name', $testimonial_submitter_name);

			//$testimonial_title add it to the view for displaying
			$this->context->smarty->assign('testimonial_title', $testimonial_title);

			// $testimonial_main_message add it to the view for displaying
			$this->context->smarty->assign('testimonial_main_message', $testimonial_main_message);

			if($confirmation) { // if testimonial submitted okay lets let the view know
			   $this->context->smarty->assign('confirmation', $confirmation);
			}
		}
		parent::process();
	}
}