<?php
	if (!defined('_PS_VERSION_'))
	exit;

	class bakery extends Module
	{
	
	protected $allowed_exts = array('gif', 'jpeg', 'jpg', 'png');
	protected $max_upload_file_size = 2048;
	
	public function __construct()
	{

		$this->name = 'bakery';
		$this->tab = 'Other';
		$this->version = '1';
		$this->author = 'Baked Themes';
		$this->need_instance = 0;
		$this->bootstrap = true;

		parent::__construct();
		$this->displayName = $this->l('The Bakery');
		$this->description = $this->l('Whip up a fresh style in the bakery');

		$this->defaults = array(
			"headerstyle" => 1,
			"homeleftcolumn" => 1,
			"displayfooter" => 0,
			"displaycat" => 1,
			"titlealign" => 0,
			"colourscheme" => "transparent",
			"headerstyle1" => 0,
			"fonttype" => "Dosis",
			"fonttype1" => "Lato",
			"socialicons" => "#ffffff",
			"socialiconshover" => "#ffffff",
			"headertext" => "#a9a9a9",
			"navbar" => "#111111",
			"accent" => "#f52c66",
			"homeprice" => "#007d8e",
			"iconbg" => "#007d8e",
			"iconbg-hover" => "#00b2ca",
			"iconcol" => "#ffffff",
			"advertbg" => "#f52c66",
			"searchicon" => "#ffffff",
			"searchicon_bg" => "#12cde2",
			"carttxt" => "#f6f6f6",
			"banner1" => "#ffffff",
			"banner1t" => "#ffffff",
			"banner2" => "#12cce2",
			"banner2t" => "#12cce2",
			"banner3" => "#12cde2",
			"banner3t" => "#f42b65",
			"header" => "#181818",
			"effect" => "#ffffff",
			"effectstyle" => "standard",
			"titleborder" => "#ffffff",
			"hrcolour" => "#555555",
			"hrcolourh" => "#999999",
			"titleborderh" => "#555555",
			"blogtitle" => "#12cde2",
			"blogdate" => "#167c9a",
			"blogdate_bg" => "#f52c66",
			"blogpost" => "#007d8e",
			"blogpost_bg" => "#ffffff",
			"blogread" => "#777777",
			"sale" => "#00b2ca",
			"saletxt" => "#ffffff",
			"new" => "#00b2ca",
			"newtxt" => "#ffffff",
			"pricebar" => "#00b2ca",
			"pricebartxt" => "#ffffff",
			"price" => "#00b2ca",
			"cart" => "#00b2ca",
			"carttxt1" => "#ffffff",
			"infotab" => "#00b2ca",
			"infotabtxt" => "#ffffff",
			"dealtxt" => "#00b2ca",
			"bannertxt" => "#ffffff",
			"banner" => "#00b2ca",
			"footertop" => "#1C1C1C",
			"footer_bg" => "#222222",
			"footersocial" => "#ffffff",
			"footersocial_h" => "#00b2ca",
			"newsletter" => "#444444",
			"plane" => "#00b2ca",
			"titles" => "#ffffff",
			"headeru" => "#383838",
			"bullet" => "#686666",
			"bullet_h" => "#ffffff",
			"bottomlinks" => "#ffffff",
		);
	}

	public function install()
	{
		if (parent::install() AND $this->registerHook('displayHeader'))
		{
			
			$shops = Shop::getShops(false);
			foreach ($shops as $shop)
			{	
				Configuration::updateValue('BAKERY_HEADERSTYLE', $this->defaults["headerstyle"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_HOMELEFTCOLUMN', $this->defaults["homeleftcolumn"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_DISPLAYFOOTER', $this->defaults["displayfooter"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_DISPLAYCAT', $this->defaults["displaycat"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_TITLEALIGN', $this->defaults["titlealign"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_COLOURSCHEME', $this->defaults["colourscheme"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_HEADERSTYLE1', $this->defaults["headerstyle1"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_FONTTYPE', $this->defaults["fonttype"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_FONTTYPE1', $this->defaults["fonttype1"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_SOCIALICONS', $this->defaults["socialicons"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_SOCIALICONSHOVER', $this->defaults["socialiconshover"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_HEADERTEXT', $this->defaults["headertext"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_NAVBAR', $this->defaults["navbar"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_ACCENT', $this->defaults["accent"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_HOMEPRICE', $this->defaults["homeprice"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_ICONBG', $this->defaults["iconbg"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_ICONBG-HOVER', $this->defaults["iconbg-hover"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_ADVERTBG', $this->defaults["advertbg"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_ICONCOL', $this->defaults["iconcol"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_SEARCHICON', $this->defaults["searchicon"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_SEARCHICON_BG', $this->defaults["searchicon_bg"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_CARTTXT', $this->defaults["carttxt"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_HEADER', $this->defaults["header"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_EFFECT', $this->defaults["effect"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_EFFECTSTYLE', $this->defaults["effectstyle"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_TITLEBORDER', $this->defaults["titleborder"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_TITLEBORDERH', $this->defaults["titleborderh"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_HRCOLOUR', $this->defaults["hrcolour"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_HRCOLOURH', $this->defaults["hrcolourh"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BLOGTITLE', $this->defaults["blogtitle"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BLOGDATE', $this->defaults["blogdate"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BLOGDATE_BG', $this->defaults["blogdate_bg"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BLOGPOST', $this->defaults["blogpost"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BLOGREAD', $this->defaults["blogread"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BLOGPOST_BG', $this->defaults["blogpost_bg"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_SALE', $this->defaults["sale"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_SALETXT', $this->defaults["saletxt"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_NEW', $this->defaults["new"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_NEWTXT', $this->defaults["newtxt"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_PRICEBAR', $this->defaults["pricebar"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_PRICEBARTXT', $this->defaults["pricebartxt"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_PRICE', $this->defaults["price"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_CART', $this->defaults["cart"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_CARTTXT1', $this->defaults["carttxt1"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BANNER1', $this->defaults["banner1"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BANNER1T', $this->defaults["banner1t"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BANNER2', $this->defaults["banner2"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BANNER2T', $this->defaults["banner2t"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BANNER3', $this->defaults["banner3"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BANNER3T', $this->defaults["banner3t"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_INFOTAB', $this->defaults["infotab"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_INFOTABTXT', $this->defaults["infotabtxt"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_DEALTXT', $this->defaults["dealtxt"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BANNER', $this->defaults["banner"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BANNERTXT', $this->defaults["bannertxt"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_FOOTERTOP', $this->defaults["footertop"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_FOOTER_BG', $this->defaults["footer_bg"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_FOOTERSOCIAL', $this->defaults["footersocial"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_FOOTERSOCIAL_H', $this->defaults["footersocial_h"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_NEWSLETTER', $this->defaults["newsletter"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_PLANE', $this->defaults["plane"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_TITLES', $this->defaults["titles"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_HEADERU', $this->defaults["headeru"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BULLET', $this->defaults["bullet"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BULLET_H', $this->defaults["bullet_h"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_BOTTOMLINKS', $this->defaults["bottomlinks"], false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_MAP', array('1' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d10500.43550021912!2d2.3549134083511407!3d48.85613422714249!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47e66e1f06e2b70f%3A0x40b82c3688c9460!2sParis%2C+France!5e0!3m2!1sen!2suk!4v1414228237366', '2' => 'https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d10500.43550021912!2d2.3549134083511407!3d48.85613422714249!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x47e66e1f06e2b70f%3A0x40b82c3688c9460!2sParis%2C+France!5e0!3m2!1sen!2suk!4v1414228237366'), false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_CALL', array('1' => '+420 603 442 700', '2' => '+420 603 442 700'), false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_CALL1', array('1' => '+420 281 865 541', '2' => '+420 281 865 541'), false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_EMAIL', array('1' => 'support@bakedthemes.com', '2' => 'support@bakedthemes.com'), false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_TWITTERBLOCK', array('1' => 'https://twitter.com/bakedthemes', '2' => 'https://twitter.com/bakedthemes'), false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_FACEBOOKBLOCK', array('1' => 'https://www.facebook.com/bakedthemes?', '2' => 'https://www.facebook.com/bakedthemes?'), false, null, $shop['id_shop']);
				Configuration::updateValue('BAKERY_GOOGLEBLOCK', array('1' => 'http://www.bakedthemes.com', '2' => 'http://www.bakedthemes.com'), false, null, $shop['id_shop']);
			}	

		return true;
			
		}
		else
		{
		return false;
		}
	}

	public function uninstall()
	{

		if (!parent::uninstall() ||

				!Configuration::deleteByName('BAKERY_HEADERSTYLE') ||
				!Configuration::deleteByName('BAKERY_HOMELEFTCOLUMN') ||
				!Configuration::deleteByName('BAKERY_DISPLAYFOOTER') ||
				!Configuration::deleteByName('BAKERY_DISPLAYCAT') ||
				!Configuration::deleteByName('BAKERY_TITLEALIGN') ||
				!Configuration::deleteByName('BAKERY_COLOURSCHEME') ||
				!Configuration::deleteByName('BAKERY_HEADERSTYLE1') ||
				!Configuration::deleteByName('BAKERY_FONTTYPE') ||
				!Configuration::deleteByName('BAKERY_FONTTYPE1') ||
				!Configuration::deleteByName('BAKERY_SOCIALICONS') ||
				!Configuration::deleteByName('BAKERY_SOCIALICONSHOVER') ||
				!Configuration::deleteByName('BAKERY_NAVBAR') ||
				!Configuration::deleteByName('BAKERY_HEADERTEXT') ||
				!Configuration::deleteByName('BAKERY_ACCENT') ||
				!Configuration::deleteByName('BAKERY_HOMEPRICE') ||
				!Configuration::deleteByName('BAKERY_ICONBG') ||
				!Configuration::deleteByName('BAKERY_ICONBG-HOVER') ||
				!Configuration::deleteByName('BAKERY_ADVERTBG') ||
				!Configuration::deleteByName('BAKERY_ICONCOL') ||
				!Configuration::deleteByName('BAKERY_SEARCHICON') ||
				!Configuration::deleteByName('BAKERY_SEARCHICON_BG') ||
				!Configuration::deleteByName('BAKERY_CARTTXT') ||
				!Configuration::deleteByName('BAKERY_HEADER') ||
				!Configuration::deleteByName('BAKERY_EFFECT') ||
				!Configuration::deleteByName('BAKERY_EFFECTSTYLE') ||
				!Configuration::deleteByName('BAKERY_TITLEBORDER') ||
				!Configuration::deleteByName('BAKERY_TITLEBORDERH') ||
				!Configuration::deleteByName('BAKERY_HRCOLOUR') ||
				!Configuration::deleteByName('BAKERY_HRCOLOURH') ||
				!Configuration::deleteByName('BAKERY_BLOGTITLE') ||
				!Configuration::deleteByName('BAKERY_BLOGDATE') ||
				!Configuration::deleteByName('BAKERY_BLOGDATE_BG') ||
				!Configuration::deleteByName('BAKERY_BLOGPOST') ||
				!Configuration::deleteByName('BAKERY_BLOGREAD') ||
				!Configuration::deleteByName('BAKERY_BLOGPOST_BG') ||
				!Configuration::deleteByName('BAKERY_SALE') ||
				!Configuration::deleteByName('BAKERY_SALETXT') ||
				!Configuration::deleteByName('BAKERY_NEW') ||
				!Configuration::deleteByName('BAKERY_NEWTXT') ||
				!Configuration::deleteByName('BAKERY_PRICEBAR') ||
				!Configuration::deleteByName('BAKERY_PRICEBARTXT') ||
				!Configuration::deleteByName('BAKERY_PRICE') ||
				!Configuration::deleteByName('BAKERY_CART') ||
				!Configuration::deleteByName('BAKERY_CARTTXT1') ||
				!Configuration::deleteByName('BAKERY_BANNER1') ||
				!Configuration::deleteByName('BAKERY_BANNER1T') ||
				!Configuration::deleteByName('BAKERY_BANNER2') ||
				!Configuration::deleteByName('BAKERY_BANNER2T') ||
				!Configuration::deleteByName('BAKERY_BANNER3') ||
				!Configuration::deleteByName('BAKERY_BANNER3T') ||
				!Configuration::deleteByName('BAKERY_INFOTAB') ||
				!Configuration::deleteByName('BAKERY_INFOTABTXT') ||
				!Configuration::deleteByName('BAKERY_DEALTXT') ||
				!Configuration::deleteByName('BAKERY_BANNER') ||
				!Configuration::deleteByName('BAKERY_BANNERTXT') ||
				!Configuration::deleteByName('BAKERY_MAP') ||
				!Configuration::deleteByName('BAKERY_CALL') ||
				!Configuration::deleteByName('BAKERY_CALL1') ||
				!Configuration::deleteByName('BAKERY_EMAIL') ||
				!Configuration::deleteByName('BAKERY_TWITTERBLOCK') ||
				!Configuration::deleteByName('BAKERY_GOOGLEBLOCK') ||
				!Configuration::deleteByName('BAKERY_FACEBOOKBLOCK') ||
				!Configuration::deleteByName('BAKERY_FOOTERTOP') ||
				!Configuration::deleteByName('BAKERY_FOOTER_BG') ||
				!Configuration::deleteByName('BAKERY_FOOTERSOCIAL') ||
				!Configuration::deleteByName('BAKERY_NEWSLETTER') ||
				!Configuration::deleteByName('BAKERY_PLANE') ||
				!Configuration::deleteByName('BAKERY_TITLES') ||
				!Configuration::deleteByName('BAKERY_HEADERU') ||
				!Configuration::deleteByName('BAKERY_BULLET') ||
				!Configuration::deleteByName('BAKERY_BULLET_H') ||
				!Configuration::deleteByName('BAKERY_BOTTOMLINKS') 
			) 
			
			return false;
		
		return true;
	}

	public function postProcess()
	{

	}
	public function updateMap()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text_'.$language['id_lang']];
		$id_shop = $this->context->shop->id;
		Configuration::updateValue('BAKERY_MAP', $resultfalse, false, null, $id_shop);
	}
	
	public function updateCall()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text1_'.$language['id_lang']];
		$id_shop = $this->context->shop->id;
		Configuration::updateValue('BAKERY_CALL', $result, false, null, $id_shop);
	}
	
	public function updateCall1()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text2_'.$language['id_lang']];
		$id_shop = $this->context->shop->id;
		Configuration::updateValue('BAKERY_CALL1', $result, false, null, $id_shop);
	}
	

	public function updateEmail()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text3_'.$language['id_lang']];
		$id_shop = $this->context->shop->id;
		Configuration::updateValue('BAKERY_EMAIL', $result, false, null, $id_shop);
	}
	
	public function updateTwitterblock()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text4_'.$language['id_lang']];
		$id_shop = $this->context->shop->id;
		Configuration::updateValue('BAKERY_TWITTERBLOCK', $result, false, null, $id_shop);
	}
	
	public function updateFacebookblock()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text5_'.$language['id_lang']];
		$id_shop = $this->context->shop->id;
		Configuration::updateValue('BAKERY_FACEBOOKBLOCK', $result, false, null, $id_shop);
	}
	
	public function updateGoogleblock()
	{

		$languages = Language::getLanguages();
		$result = array( );

		foreach ($languages as $language)
		$result[$language['id_lang']] = $_POST['text6_'.$language['id_lang']];
		$id_shop = $this->context->shop->id;
		Configuration::updateValue('BAKERY_GOOGLEBLOCK', $result, false, null, $id_shop);
	}

	public function getContent()
	{
		$this->context->controller->addJS(_PS_JS_DIR_.'jquery/plugins/jquery.colorpicker.js');
		$this->context->controller->addCSS(($this->_path).'css/admin.css');
		$this->context->controller->addCSS(($this->_path).'css/style.css');
		$id_shop = $this->context->shop->id;
		if (Tools::isSubmit('save_editor'))
		{
			Configuration::updateValue('BAKERY_HEADERSTYLE', (int)(Tools::getValue("headerstyle")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_HOMELEFTCOLUMN', (int)(Tools::getValue("homeleftcolumn")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_DISPLAYFOOTER', (int)(Tools::getValue("displayfooter")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_DISPLAYCAT', (int)(Tools::getValue("displaycat")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_TITLEALIGN', (int)(Tools::getValue("titlealign")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_EFFECTSTYLE', (string)(Tools::getValue("effectstyle")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_EFFECT', (string)(Tools::getValue("effect")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_COLOURSCHEME', (string)(Tools::getValue("colourscheme")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_HEADERSTYLE1', (string)(Tools::getValue("headerstyle1")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_FONTTYPE', (string)(Tools::getValue("fonttype")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_FONTTYPE1', (string)(Tools::getValue("fonttype1")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_SOCIALICONS', (string)(Tools::getValue("socialicons")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_SOCIALICONSHOVER', (string)(Tools::getValue("socialiconshover")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_HEADERTEXT', (string)(Tools::getValue("headertext")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_NAVBAR', (string)(Tools::getValue("navbar")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_ACCENT', (string)(Tools::getValue("accent")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_HOMEPRICE', (string)(Tools::getValue("homeprice")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_ICONBG', (string)(Tools::getValue("iconbg")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_ICONBG-HOVER', (string)(Tools::getValue("iconbg-hover")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_ADVERTBG', (string)(Tools::getValue("advertbg")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_ICONCOL', (string)(Tools::getValue("iconcol")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_SEARCHICON', (string)(Tools::getValue("searchicon")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_SEARCHICON_BG', (string)(Tools::getValue("searchicon_bg")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_CARTTXT', (string)(Tools::getValue("carttxt")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_HEADER', (string)(Tools::getValue("header")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_TITLEBORDER', (string)(Tools::getValue("titleborder")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_TITLEBORDERH', (string)(Tools::getValue("titleborderh")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_HRCOLOUR', (string)(Tools::getValue("hrcolour")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_HRCOLOURH', (string)(Tools::getValue("hrcolourh")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGTITLE', (string)(Tools::getValue("blogtitle")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGDATE', (string)(Tools::getValue("blogdate")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGDATE_BG', (string)(Tools::getValue("blogdate_bg")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGPOST', (string)(Tools::getValue("blogpost")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGPOST_BG', (string)(Tools::getValue("blogpost_bg")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGREAD', (string)(Tools::getValue("blogread")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_NEW', (string)(Tools::getValue("new")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_NEWTXT', (string)(Tools::getValue("newtxt")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_SALE', (string)(Tools::getValue("sale")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_SALETXT', (string)(Tools::getValue("saletxt")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_PRICEBAR', (string)(Tools::getValue("pricebar")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_PRICEBARTXT', (string)(Tools::getValue("pricebartxt")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_PRICE', (string)(Tools::getValue("price")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_CART', (string)(Tools::getValue("cart")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_CARTTXT1', (string)(Tools::getValue("carttxt1")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER1', (string)(Tools::getValue("banner1")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER1T', (string)(Tools::getValue("banner1t")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER2', (string)(Tools::getValue("banner2")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER2T', (string)(Tools::getValue("banner2t")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER3', (string)(Tools::getValue("banner3")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER3T', (string)(Tools::getValue("banner3t")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_INFOTAB', (string)(Tools::getValue("infotab")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_INFOTABTXT', (string)(Tools::getValue("infotabtxt")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_DEALTXT', (string)(Tools::getValue("dealtxt")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER', (string)(Tools::getValue("banner")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNERTXT', (string)(Tools::getValue("bannertxt")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_FOOTERTOP', (string)(Tools::getValue("footertop")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_FOOTER_BG', (string)(Tools::getValue("footer_bg")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_FOOTERSOCIAL', (string)(Tools::getValue("footersocial")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_FOOTERSOCIAL_H', (string)(Tools::getValue("footersocial_h")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_NEWSLETTER', (string)(Tools::getValue("newsletter")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_PLANE', (string)(Tools::getValue("plane")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_TITLES', (string)(Tools::getValue("titles")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_HEADERU', (string)(Tools::getValue("headeru")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BULLET', (string)(Tools::getValue("bullet")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BULLET_H', (string)(Tools::getValue("bullet_h")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_BOTTOMLINKS', (string)(Tools::getValue("bottomlinks")), false, null, $id_shop);
			Configuration::updateValue('BAKERY_CUSTOM_CSS', (string)(Tools::getValue('custom_css')), false, null, $id_shop);		
			Configuration::updateValue('BAKERY_FONT_CSS', (string)(Tools::getValue('font_css')), false, null, $id_shop);
			Configuration::updateValue('BAKERY_FONT1_CSS', (string)(Tools::getValue('font1_css')), false, null, $id_shop);
			
			if ($_FILES['BAKERY_SECOND_LOGO']['name'])
			{
				$temp				 = explode('.', $_FILES['BAKERY_SECOND_LOGO']['name']);
				$extension			 = end($temp);
				if ($_FILES['BAKERY_SECOND_LOGO']['error'] > 0)
					$output .= '<div class="alert error">'.$_FILES['file']['error']."</div>";
			elseif (($_FILES['BAKERY_SECOND_LOGO']['size'] / 1024) < $this->max_upload_file_size && in_array($extension, $this->allowed_exts))
				{
						$newfilename = 'second_logo.'.$extension;
						//.end($temp);
						if (move_uploaded_file($_FILES['BAKERY_SECOND_LOGO']['tmp_name'], _PS_MODULE_DIR_.'/'.$this->name."/css/".$newfilename))
						{
							Configuration::updateValue('BAKERY_SECOND_LOGO', $newfilename, false, null, $id_shop);
						}
				}
				else
					$output .= '<div class="alert error">'.$this->l('Invalid file')."</div>";
			}
			
			$this->updateMap();
			$this->updateCall();
			$this->updateCall1();
			$this->updateEmail();
			$this->updateTwitterblock();
			$this->updateGoogleblock();
			$this->updateFacebookblock();
			$this->generateCustomCSS();
			$this->generateFontCSS();
			$this->generateFont1CSS();
			$this->generateCss();
			
			if (isset($errors) AND $errors!='')
				$this->_html .= $this -> displayError($errors);
			else
				$this->_html .= $this -> displayConfirmation($this->l('Settings updated'));
		}



		if (Tools::isSubmit('reset_editor'))
		{

			Configuration::updateValue('BAKERY_HEADERSTYLE', $this->defaults["headerstyle"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_HOMELEFTCOLUMN', $this->defaults["homeleftcolumn"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_DISPLAYFOOTER', $this->defaults["displayfooter"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_DISPLAYCAT', $this->defaults["displaycat"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_TITLEALIGN', $this->defaults["titlealign"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_COLOURSCHEME', $this->defaults["colourscheme"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_HEADERSTYLE1', $this->defaults["headerstyle1"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_FONTTYPE', $this->defaults["fonttype"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_FONTTYPE1', $this->defaults["fonttype1"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_SOCIALICONS', $this->defaults["socialicons"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_SOCIALICONSHOVER', $this->defaults["socialiconshover"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_HEADERTEXT', $this->defaults["headertext"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_NAVBAR', $this->defaults["navbar"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_ACCENT', $this->defaults["accent"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_HOMEPRICE', $this->defaults["homeprice"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_ICONBG', $this->defaults["iconbg"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_ICONBG-HOVER', $this->defaults["iconbg-hover"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_ADVERTBG', $this->defaults["advertbg"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_ICONCOL', $this->defaults["iconcol"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_SEARCHICON', $this->defaults["searchicon"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_SEARCHICON_BG', $this->defaults["searchicon_bg"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_CARTTXT', $this->defaults["carttxt"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_HEADER', $this->defaults["header"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_EFFECT', $this->defaults["effect"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_EFFECTSTYLE', $this->defaults["effectstyle"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_TITLEBORDER', $this->defaults["titleborder"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_TITLEBORDERH', $this->defaults["titleborderh"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_HRCOLOUR', $this->defaults["hrcolour"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_HRCOLOURH', $this->defaults["hrcolourh"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGTITLE', $this->defaults["blogtitle"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGDATE', $this->defaults["blogdate"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGDATE_BG', $this->defaults["blogdate_bg"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGPOST', $this->defaults["blogpost"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGREAD', $this->defaults["blogread"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BLOGPOST_BG', $this->defaults["blogpost_bg"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_NEW', $this->defaults["new"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_NEWTXT', $this->defaults["newtxt"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_SALE', $this->defaults["sale"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_SALETXT', $this->defaults["saletxt"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_PRICEBAR', $this->defaults["pricebar"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_PRICEBARTXT', $this->defaults["pricebartxt"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_PRICE', $this->defaults["price"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_CART', $this->defaults["cart"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_CARTTXT1', $this->defaults["carttxt1"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER1', $this->defaults["banner1"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER1T', $this->defaults["banner1t"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER2', $this->defaults["banner2"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER2T', $this->defaults["banner2t"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER3', $this->defaults["banner3"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER3T', $this->defaults["banner3t"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_INFOTAB', $this->defaults["infotab"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_INFOTABTXT', $this->defaults["infotabtxt"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_DEALTXT', $this->defaults["dealtxt"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNER', $this->defaults["banner"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BANNERTXT', $this->defaults["bannertxt"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_FOOTERTOP', $this->defaults["footertop"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_FOOTER_BG', $this->defaults["footer_bg"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_FOOTERSOCIAL', $this->defaults["footersocial"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_FOOTERSOCIAL_H', $this->defaults["footersocial_h"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_NEWSLETTER', $this->defaults["newsletter"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_PLANE', $this->defaults["plane"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_TITLES', $this->defaults["titles"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_HEADERU', $this->defaults["headeru"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BULLET', $this->defaults["bullet"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BULLET_H', $this->defaults["bullet_h"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_BOTTOMLINKS', $this->defaults["bottomlinks"], false, null, $id_shop);
			Configuration::updateValue('BAKERY_CUSTOM_CSS','', false, null, $id_shop);
			Configuration::updateValue('BAKERY_FONT_CSS','', false, null, $id_shop);
			Configuration::updateValue('BAKERY_FONT1_CSS','', false, null, $id_shop);
			$this->generateCss();
		}



		if ($errors)
			$output .= $this->displayError($errors);


		return $output.$this->displayForm();
	}

	
	public function displayForm()
	{
		$defaultLanguage = (int)(Configuration::get('PS_LANG_DEFAULT'));

		$languages = Language::getLanguages(false);
		$id_shop = $this->context->shop->id;
		$divLangName = 'text¤title';
		
		

		$html = '';

		$html .= '

		<script type="text/javascript">

			id_language = Number('.$defaultLanguage.');

		</script>
		
		<div class="container" id="bakerystyles">
		</br>
		</br>
				<form action="'.Tools::safeOutput($_SERVER['REQUEST_URI']).'" method="post" enctype="multipart/form-data">
					
					<div>
						<ul id="tabs" class="nav nav-tabs nav-stacked col-xs-12 col-md-3" data-tabs="tabs">
							<div class="baked-img"><img src="http://storesmart.bakedthemes.com/modules/bakery/css/baked_thumb.jpg"></div>
							<li class="active"><a href="#general" data-toggle="tab"><span class="ssicon-tools2"></span></br>General Settings</a></li>
							<li><a href="#colours" data-toggle="tab"><span class="ssicon-cog"></span></br>Header Settings</a></li>
							<li><a href="#font" data-toggle="tab"><span class="ssicon-pen2"></span></br>Font Settings</a></li>
							<li><a href="#home" data-toggle="tab"><span class="ssicon-library"></span></br>Homepage Settings</a></li>
							<li><a href="#product" data-toggle="tab"><span class="ssicon-tie"></span></br>Product Settings</a></li>
							<li><a href="#contact" data-toggle="tab"><span class="ssicon-chat4"></span></br>Contact Settings</a></li>
							<li><a href="#foot" data-toggle="tab"><span class="ssicon-screwdriver"></span></br>Footer Settings</a></li>
							<li><a href="#custom" data-toggle="tab"><span class="ssicon-scissors2"></span></br>Custom CSS</a></li>
							
						</ul>
						
						<div id="my-tab-content" class="tab-content col-xs-12 col-md-12">
							
							<div class="tab-pane active" id="general">
								
								
								
								<label class="control-label col-lg-3">'.$this->l('Header').'</label>
								<div class="col-lg-9">
									<select name="colourscheme">
									<option value="transparent" '.((Configuration::get('BAKERY_COLOURSCHEME') == 'transparent') ? 'selected="selected"' : '').' />'.$this->l('Transparent').'</option>
									<option value="fill" '.((Configuration::get('BAKERY_COLOURSCHEME', null, null, $id_shop) == 'fill') ? 'selected="selected"' : '').' />'.$this->l('Fill').'</option>
									</select>
									</br>
								<div class="alert alert-info" role="alert">Select transparent if you would like your slider to show underneath the header.</div>
								</div>
								
								<label class="control-label col-lg-3">'.$this->l('Visible menu?').'</label>
								<div class="col-lg-9">
									<span class="switch prestashop-switch fixed-width-lg">
									<input type="radio" name="headerstyle1" id="headerstyle1_on" value="0" ' . ((Configuration::get('BAKERY_HEADERSTYLE1', false, null, $this->context->shop->id) == 0) ? 'checked="checked" ' : '') . '/>
									<label for="headerstyle1_on">Yes</label>
									<input type="radio" name="headerstyle1" id="headerstyle1_off" value="1" ' . ((Configuration::get('BAKERY_HEADERSTYLE1', false, null, $this->context->shop->id) == 1) ? 'checked="checked" ' : '') . '/>
									<label for="headerstyle1_off">No</label>
									<a class="slide-button btn"></a>
									</span>
								</div>
								<label class="control-label col-lg-3">'.$this->l('Product Info alignment').'</label>
								<div class="col-lg-9 ">
									<span class="switch prestashop-switch fixed-width-lg">
									<input type="radio" name="titlealign" id="titlealign_on" value="0" ' . ((Configuration::get('BAKERY_TITLEALIGN', false, null, $this->context->shop->id) == 0) ? 'checked="checked" ' : '') . '/>
									<label for="titlealign_on">Left</label>
									<input type="radio" name="titlealign" id="titlealign_off" value="1" ' . ((Configuration::get('BAKERY_TITLEALIGN', false, null, $this->context->shop->id) == 1) ? 'checked="checked" ' : '') . '/>
									<label for="titlealign_off">Center</label>
									<a class="slide-button btn"></a>
									</span>
								</div>
								<label class="control-label col-lg-3">'.$this->l('Display footer on index').'</label>
								<div class="col-lg-9 ">
									<span class="switch prestashop-switch fixed-width-lg">
									<input type="radio" name="displayfooter" id="displayfooter_on" value="0" ' . ((Configuration::get('BAKERY_DISPLAYFOOTER', false, null, $this->context->shop->id) == 0) ? 'checked="checked" ' : '') . '/>
									<label for="displayfooter_on">Yes</label>
									<input type="radio" name="displayfooter" id="displayfooter_off" value="1" ' . ((Configuration::get('BAKERY_DISPLAYFOOTER', false, null, $this->context->shop->id) == 1) ? 'checked="checked" ' : '') . '/>
									<label for="displayfooter_off">No</label>
									<a class="slide-button btn"></a>
									</span>
								</div>
								<label class="control-label col-lg-3 second-logo">'.$this->l('Second logo').'</label>
								<div class="col-lg-9">
									<input type="file" name="BAKERY_SECOND_LOGO" value=""/> <br />';
								if (Configuration::get('BAKERY_SECOND_LOGO', null, null, $id_shop))
								{
									$html .= '<img style="width: auto; height: auto;" src="../modules/'.$this->name.'/css/'.Configuration::get('BAKERY_SECOND_LOGO').'" />';
								}	
								$html .='	
								</br></br>
								<div class="alert alert-info" role="alert">This will show on all pages except the home page</div>
								</div>
							</div>
							
							<div class="tab-pane" id="colours">
								
								<label class="control-label col-lg-3">'.$this->l('Header Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="header"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HEADER', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Top Bar').'</label>
								<div class="col-lg-9">
									<input type="color" name="navbar"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NAVBAR', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Top Bar Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="headertext"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HEADERTEXT', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Header text').'</label>
								<div class="col-lg-9">
									<input type="color" name="socialicons"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SOCIALICONS', null, null, $id_shop) . '" />
								</div>
								
								<label class="control-label col-lg-3">'.$this->l('Accent colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="accent"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ACCENT', null, null, $id_shop) . '" />
								</div>
								
								<label class="control-label col-lg-3">'.$this->l('Search Icon').'</label>
								<div class="col-lg-9">
									<input type="color" name="searchicon"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SEARCHICON', null, null, $id_shop) . '" />
								</div>
													
								<h1>Menu Settings</h1>
								<label class="control-label col-lg-3">'.$this->l('Font color').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner1"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER1', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Sticky Font color').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner1t"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER1T', null, null, $id_shop) . '" />
								</div>
							
								<div class="alert alert-info" role="alert">Use these settings for the menu display on the index page. Use the FinalMenu module to set main page colours</div>
								
							</div>
							<div class="tab-pane" id="font">
								
								<label class="control-label col-lg-3">'.$this->l('Headers & Titles').'</label>
								<div class="col-lg-9">
									<textarea cols="1" rows="1" name="font_css" >'.Configuration::get('BAKERY_FONT_CSS', null, null, $id_shop).'</textarea>
								</div>
								<label class="control-label col-lg-3">'.$this->l('Font Name').'</label>
								<div class="col-lg-9">
								<textarea cols="1" rows="1" name="fonttype" style="width: 207px">'.Configuration::get('BAKERY_FONTTYPE', null, null, $id_shop).'</textarea>
								</div>
								<label class="control-label col-lg-3">'.$this->l('Body').'</label>
								<div class="col-lg-9">
									<textarea cols="1" rows="1" name="font1_css" >'.Configuration::get('BAKERY_FONT1_CSS', null, null, $id_shop).'</textarea>
								</div>
								<label class="control-label col-lg-3">'.$this->l('Font Name').'</label>
								<div class="col-lg-9">
								<textarea cols="1" rows="1" name="fonttype1" style="width: 207px">'.Configuration::get('BAKERY_FONTTYPE1', null, null, $id_shop).'</textarea>
								</div>
							</div>	
							<div class="tab-pane" id="home">
							
								<label class="control-label col-lg-3">'.$this->l('Title on category block').'</label>
								<div class="col-lg-9 ">
									<span class="switch prestashop-switch fixed-width-lg">
									<input type="radio" name="displaycat" id="displaycat_on" value="0" ' . ((Configuration::get('BAKERY_DISPLAYCAT', false, null, $this->context->shop->id) == 0) ? 'checked="checked" ' : '') . '/>
									<label for="displaycat_on">Yes</label>
									<input type="radio" name="displaycat" id="displaycat_off" value="1" ' . ((Configuration::get('BAKERY_DISPLAYCAT', false, null, $this->context->shop->id) == 1) ? 'checked="checked" ' : '') . '/>
									<label for="displaycat_off">No</label>
									<a class="slide-button btn"></a>
									</span>
								</div>
								<label class="control-label col-lg-3">'.$this->l('Product Info Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="titleborder"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_TITLEBORDER', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Product Info Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="titleborderh"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_TITLEBORDERH', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Ratings Star').'</label>
								<div class="col-lg-9">
									<input type="color" name="hrcolour"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HRCOLOUR', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Discount Price').'</label>
								<div class="col-lg-9">
									<input type="color" name="hrcolourh"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HRCOLOURH', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Price').'</label>
								<div class="col-lg-9">
									<input type="color" name="homeprice"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HOMEPRICE', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Icon Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="iconbg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ICONBG', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Icon Hover Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="iconbg-hover"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ICONBG-HOVER', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Icon Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="iconcol"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ICONCOL', null, null, $id_shop) . '" />
								</div>
								
								<h1>Recent Posts - 1st Post</h1>
								<label class="control-label col-lg-3">'.$this->l('Read more button').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogtitle"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGTITLE', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Read more button: Hover').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogdate_bg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGDATE_BG', null, null, $id_shop) . '" />
								</div>
								
								<h1>Recent Posts - 2nd Post</h1>
								<label class="control-label col-lg-3">'.$this->l('Read more button').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogpost_bg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGPOST_BG', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Read more button: Hover').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogdate"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGDATE', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="blogpost"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BLOGPOST', null, null, $id_shop) . '" />
								</div>
								<h1>Icon Advert Area</h1>
								<label class="control-label col-lg-3">'.$this->l('Icon Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="socialiconshover"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SOCIALICONSHOVER', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Title Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="searchicon_bg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SEARCHICON_BG', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Text Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="carttxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_CARTTXT', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Link Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner2"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER2', null, null, $id_shop) . '" />
								</div>
								<h1>Store Finder & Twitter</h1>
								<label class="control-label col-lg-3">'.$this->l('Twitter Username Colour').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner2t"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER2T', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Storefinder banner').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner3"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER3', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Storefinder button').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner3t"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER3T', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Button: Hover').'</label>
								<div class="col-lg-9">
									<input type="color" name="advertbg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_ADVERTBG', null, null, $id_shop) . '" />
								</div>
							</div>
							
							<div class="tab-pane" id="product">
								
								<label class="control-label col-lg-3">'.$this->l('Sale label').'</label>
								<div class="col-lg-9">
									<input type="color" name="sale"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SALE', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Sale text').'</label>
								<div class="col-lg-9">
									<input type="color" name="saletxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_SALETXT', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('New label').'</label>
								<div class="col-lg-9">
									<input type="color" name="new"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NEW', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('New text').'</label>
								<div class="col-lg-9">
									<input type="color" name="newtxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NEWTXT', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Price bar').'</label>
								<div class="col-lg-9">
									<input type="color" name="pricebar"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_PRICEBAR', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Price bar content').'</label>
								<div class="col-lg-9">
									<input type="color" name="pricebartxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_PRICEBARTXT', null, null, $id_shop) . '" />
								</div>
								<h1>Product Page</h1>
								<label class="control-label col-lg-3">'.$this->l('Price').'</label>
								<div class="col-lg-9">
									<input type="color" name="price"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_PRICE', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Add to cart button').'</label>
								<div class="col-lg-9">
									<input type="color" name="cart"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_CART', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Add to cart text').'</label>
								<div class="col-lg-9">
									<input type="color" name="carttxt1"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_CARTTXT1', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Info tabs').'</label>
								<div class="col-lg-9">
									<input type="color" name="infotab"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_INFOTAB', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Info tabs text').'</label>
								<div class="col-lg-9">
									<input type="color" name="infotabtxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_INFOTABTXT', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Deal countdown').'</label>
								<div class="col-lg-9">
									<input type="color" name="dealtxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_DEALTXT', null, null, $id_shop) . '" />
								</div>
							
							</div>
							
							<div class="tab-pane" id="contact">
							
								<label class="control-label col-lg-3">'.$this->l('Banner').'</label>
								<div class="col-lg-9">
									<input type="color" name="banner"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNER', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Banner Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="bannertxt"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BANNERTXT', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Map Location').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px; border-radius: 3px; border-right: 1px solid #ccc" name="text_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_MAP', $language['id_lang'], null, $id_shop).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Contact number').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text1_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text1_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_CALL', $language['id_lang'], null, $id_shop).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Second/Fax number').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text2_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text2_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_CALL1', $language['id_lang'], null, $id_shop).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Email').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text3_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text3_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_EMAIL', $language['id_lang'], null, $id_shop).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Twitter link').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text4_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text4_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_TWITTERBLOCK', $language['id_lang'], null, $id_shop).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Facebook link').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text5_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text5_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_FACEBOOKBLOCK', $language['id_lang'], null, $id_shop).'" />
									</div>';

									$html .= '</div>
								<label class="control-label col-lg-3">'.$this->l('Google link').'</label>';
								$html .= '
								<div class="col-lg-9">
									'; foreach ($languages as $language)
									$html .= '<div id="text6_'.$language['id_lang'].'" style="display: '.($language['id_lang'] == $defaultLanguage ? 'block' : 'none').'; ">
									<input type="text" style="width: 207px;border-radius: 3px; border-right: 1px solid #ccc" name="text6_'.$language['id_lang'].'" id="textInput_'.$language['id_lang'].'" value="'.Configuration::get('BAKERY_GOOGLEBLOCK', $language['id_lang'], null, $id_shop).'" />
									</div>';

									$html .= '</div>
								
							</div>
							
							<div class="tab-pane" id="foot">
								
								<label class="control-label col-lg-3">'.$this->l('Top/Bottom Bar').'</label>
								<div class="col-lg-9">
									<input type="color" name="footertop"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_FOOTERTOP', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Background').'</label>
								<div class="col-lg-9">
									<input type="color" name="footer_bg"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_FOOTER_BG', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Social Icons').'</label>
								<div class="col-lg-9">
									<input type="color" name="footersocial"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_FOOTERSOCIAL', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Social Icons Hover').'</label>
								<div class="col-lg-9">
									<input type="color" name="footersocial_h"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_FOOTERSOCIAL_H', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Newsletter Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="newsletter"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_NEWSLETTER', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Submit button').'</label>
								<div class="col-lg-9">
									<input type="color" name="plane"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_PLANE', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Titles').'</label>
								<div class="col-lg-9">
									<input type="color" name="titles"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_TITLES', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Header underline').'</label>
								<div class="col-lg-9">
									<input type="color" name="headeru"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_HEADERU', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Bullet').'</label>
								<div class="col-lg-9">
									<input type="color" name="bullet"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BULLET', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Bullet Hover').'</label>
								<div class="col-lg-9">
									<input type="color" name="bullet_h"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BULLET_H', null, null, $id_shop) . '" />
								</div>
								<label class="control-label col-lg-3">'.$this->l('Text').'</label>
								<div class="col-lg-9">
									<input type="color" name="bottomlinks"  class="colorpicker" data-hex="true" value="' . Configuration::get('BAKERY_BOTTOMLINKS', null, null, $id_shop) . '" />
								</div>
							</div>
							<div class="tab-pane" id="custom">
								
								<textarea cols="12" rows="12" name="custom_css">'.Configuration::get('BAKERY_CUSTOM_CSS', null, null, $id_shop).'</textarea>
							</div>
					
						</div>
					</div>
					</br>
					<div class="buttonarea col-lg-12">
						<input id="save_editor" type="submit" class="button-save btn btn-primary btn-lg pull-right" value="'.$this->l('Save').'" name="save_editor">
					</div>
				</form>
				
		</div>';

		return $html;
	}
	
	public function generateCustomCSS()
	{
		$id_shop = $this->context->shop->id;
		if (Configuration::get('BAKERY_CUSTOM_CSS', null, null, $id_shop))
		{
			$css = Configuration::get('BAKERY_CUSTOM_CSS',  null, null, $id_shop);
			$myFile = $this->local_path."css/custom-".$id_shop.".css";
			$fh = fopen($myFile, 'w') or die("can't open file");
			fwrite($fh, $css);
			fclose($fh);
		}
	}
	
	public function generateFontCSS()
	{
		$id_shop = $this->context->shop->id;
		if (Configuration::get('BAKERY_FONT_CSS', null, null, $id_shop))
		{
			$css = Configuration::get('BAKERY_FONT_CSS', null, null, $id_shop);
			$myFile = $this->local_path."css/font-".$id_shop.".css";
			$fh = fopen($myFile, 'w') or die("can't open file");
			fwrite($fh, $css);
			fclose($fh);
		}
		
	}
	
	public function generateFont1CSS()
	{
		$id_shop = $this->context->shop->id;
		if (Configuration::get('BAKERY_FONT1_CSS', null, null, $id_shop))
		{
			$css = Configuration::get('BAKERY_FONT1_CSS', null, null, $id_shop);
			$myFile = $this->local_path."css/font1-".$id_shop.".css";
			$fh = fopen($myFile, 'w') or die("can't open file");
			fwrite($fh, $css);
			fclose($fh);
		}
		
	}

	public function generateCss()
	{
		$id_shop = $this->context->shop->id;
		$css .= '';

		if (Configuration::get('BAKERY_SOCIALICONS', null, null, $id_shop)){
		 $css .= '#index #languages-block-top div.current, #index .ajax_cart_quantity, #index .shopping_cart > a:first-child b, #index .shopping_cart > a:first-child {color: ' . Configuration::get('BAKERY_SOCIALICONS', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_SOCIALICONSHOVER', null, null, $id_shop)){
		$css .= '.adverticon {color: ' . Configuration::get('BAKERY_SOCIALICONSHOVER', null, null, $id_shop) . ' !important} 
		.adverticon {border: 2px solid ' . Configuration::get('BAKERY_SOCIALICONSHOVER', null, null, $id_shop) . ' !important} 
		';	}
		
		if (Configuration::get('BAKERY_HEADERTEXT', null, null, $id_shop)){
		$css .= '#currencies-block-top div.current, .header_user_info a {color: ' . Configuration::get('BAKERY_HEADERTEXT', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_NAVBAR', null, null, $id_shop)){
		$css .= 'header .nav {background: ' . Configuration::get('BAKERY_NAVBAR', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_ACCENT', null, null, $id_shop)){
		$css .= '#currencies-block-top div.current strong, #currencies-block-top div.current:after, #footer .price, .bakedproductinfo_block [class^="icon-"],.ajax_cart_quantity:before, .ajax_cart_quantity:after  {color: ' . Configuration::get('BAKERY_ACCENT', null, null, $id_shop) . ' !important}';
		$css .= '.baked-featuredslider .next, .baked-featuredslider .prev, #contact #center_column .hr_left, .baked-newproductsslider .next, .baked-newproductsslider .prev, .contact-ad {background: ' . Configuration::get('BAKERY_ACCENT', null, null, $id_shop) . ' !important}';
		$css .= '.contact-ad:after{border-top: 20px solid ' . Configuration::get('BAKERY_ACCENT', null, null, $id_shop) . ' !important}';
		
		}
		
		if (Configuration::get('BAKERY_HOMEPRICE', null, null, $id_shop)){
		$css .= '.baked-featured .entry-content .entry-price,  #category .entry-price{color: ' . Configuration::get('BAKERY_HOMEPRICE', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_ICONBG', null, null, $id_shop)){
		$css .= '.entry-quick, .entry-wish, .entry-cart {background: ' . Configuration::get('BAKERY_ICONBG', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_ICONBG-HOVER', null, null, $id_shop)){
		$css .= '.entry-quick:hover, .entry-wish:hover, .entry-cart:hover  {background: ' . Configuration::get('BAKERY_ICONBG-HOVER', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_ICONCOL', null, null, $id_shop)){
		$css .= '#index li .quick-view, li .quick-view, li .add_to_compare, li .addToWishlist {color: ' . Configuration::get('BAKERY_ICONCOL') . ' !important}';}
		
		if (Configuration::get('BAKERY_ADVERTBG', null, null, $id_shop)){
		$css .= '.store-content .findastore input:hover {background: ' . Configuration::get('BAKERY_ADVERTBG', null, null, $id_shop) . ' !important;}';}
				
		if (Configuration::get('BAKERY_SEARCHICON', null, null, $id_shop)){
		$css .= '#index .menusearch,#index #search_block_top input.search_query {color: ' . Configuration::get('BAKERY_SEARCHICON', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_SEARCHICON_BG', null, null, $id_shop)){
		$css .= '.bakedvideo_block h2{color: ' . Configuration::get('BAKERY_SEARCHICON_BG', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_CARTTXT', null, null, $id_shop)){
		$css .= '.adverttext {color: ' . Configuration::get('BAKERY_CARTTXT', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_HEADER', null, null, $id_shop)){
		$css .= '.header-container {background: ' . Configuration::get('BAKERY_HEADER', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_EFFECT', null, null, $id_shop)){
		$css .= '#FINALmenu .top-link-wrapper span:before, #FINALmenu .top-link-wrapper a::before, #FINALmenu .top-link-wrapper span:after, #FINALmenu .top-link-wrapper a::after {background: ' . Configuration::get('BAKERY_EFFECT', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_TITLEBORDER', null, null, $id_shop)){
		$css .= '.info {background: ' . Configuration::get('BAKERY_TITLEBORDER', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_TITLEBORDERH', null, null, $id_shop)){
		$css .= '.baked-featured .list-featured ul li h4 a {color: ' . Configuration::get('BAKERY_TITLEBORDERH', null, null, $id_shop) . ' !important}';}
		
		if (Configuration::get('BAKERY_HRCOLOUR', null, null, $id_shop)){
		$css .= 'li .star_on:after,li .star:after {color: ' . Configuration::get('BAKERY_HRCOLOUR', null, null, $id_shop) . ' !important} ';
		}
		
		if (Configuration::get('BAKERY_HRCOLOURH', null, null, $id_shop)){
		$css .= '.baked-featured .old-price {color: ' . Configuration::get('BAKERY_HRCOLOURH', null, null, $id_shop) . ' !important} ';
		}
		
		if (Configuration::get('BAKERY_BLOGTITLE', null, null, $id_shop)){
		$css .= '.r_more {color: ' . Configuration::get('BAKERY_BLOGTITLE', null, null, $id_shop) . ' !important}
		.r_more {border: 3px solid' . Configuration::get('BAKERY_BLOGTITLE', null, null, $id_shop) . ' !important}
		';}

		if (Configuration::get('BAKERY_BLOGDATE', null, null, $id_shop)){
		$css .= '#index #sds_blog_post:nth-child(2) .r_more:hover{color: ' . Configuration::get('BAKERY_BLOGDATE', null, null, $id_shop) . ' !important}
		#index #sds_blog_post:nth-child(2) .r_more:hover{border: 3px solid ' . Configuration::get('BAKERY_BLOGDATE', null, null, $id_shop) . ' !important}
		';}
	
		if (Configuration::get('BAKERY_BLOGDATE_BG', null, null, $id_shop)){
		$css .= '.r_more:hover{border: 3px solid ' . Configuration::get('BAKERY_BLOGDATE_BG', null, null, $id_shop) . ' !important} ';
		$css .= '.r_more:hover{color: ' . Configuration::get('BAKERY_BLOGDATE_BG', null, null, $id_shop) . ' !important} '
	
		;}
		
		if (Configuration::get('BAKERY_BLOGPOST', null, null, $id_shop)){
		$css .= '#index #sds_blog_post:nth-child(2) .blog-content{background: ' . Configuration::get('BAKERY_BLOGPOST', null, null, $id_shop) . ' !important} 
		#index #sds_blog_post:nth-child(2) .blog-content:after {color: ' . Configuration::get('BAKERY_BLOGPOST', null, null, $id_shop) . ' !important} 
		';}
	
		if (Configuration::get('BAKERY_BLOGPOST_BG', null, null, $id_shop)){
		$css .= '#index #sds_blog_post:nth-child(2) .r_more{color: ' . Configuration::get('BAKERY_BLOGPOST_BG', null, null, $id_shop) . ' !important}
		#index #sds_blog_post:nth-child(2) .r_more{border: 3px solid ' . Configuration::get('BAKERY_BLOGPOST_BG', null, null, $id_shop) . ' !important}
		';}
		
		if (Configuration::get('BAKERY_BLOGREAD', null, null, $id_shop)){
		$css .= '.post-read-more a {color: ' . Configuration::get('BAKERY_BLOGREAD', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_NEW', null, null, $id_shop)){
		$css .= '#index .list-featured li span.new, .new-box {background: ' . Configuration::get('BAKERY_NEW', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_NEW', null, null, $id_shop)){
		$css .= '.new-box:before {color: ' . Configuration::get('BAKERY_NEW', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_NEWTXT', null, null, $id_shop)){
		$css .= '#index .list-featured li span.new, .new-box {color: ' . Configuration::get('BAKERY_NEWTXT', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_SALE', null, null, $id_shop)){
		$css .= '.on_sale {background: ' . Configuration::get('BAKERY_SALE', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_SALE', null, null, $id_shop)){
		$css .= '.on_sale:before {color: ' . Configuration::get('BAKERY_SALE', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_SALETXT', null, null, $id_shop)){
		$css .= '.on_sale {color: ' . Configuration::get('BAKERY_SALETXT', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_PRICEBAR', null, null, $id_shop)){
		$css .= 'figure.effect-zoe figcaption, #category figcaption span{background: ' . Configuration::get('BAKERY_PRICEBAR', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_PRICEBARTXT', null, null, $id_shop)){
		$css .= 'figure.effect-zoe figcaption span a, #category figure.effect-zoe h2 {color: ' . Configuration::get('BAKERY_PRICEBARTXT', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_PRICE', null, null, $id_shop)){
		$css .= '.our_price_display {color: ' . Configuration::get('BAKERY_PRICE', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_CART', null, null, $id_shop)){
		$css .= '#add_to_cart button {background: ' . Configuration::get('BAKERY_CART', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_CARTTXT1', null, null, $id_shop)){
		$css .= '#add_to_cart button, #add_to_cart:before {color: ' . Configuration::get('BAKERY_CARTTXT1', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER1', null, null, $id_shop)){
		$css .= '#index #FINALmenu .top-link-wrapper a, #index #FINALmenu .top-link-wrapper span,#index #FINALmenu .top-link-wrapper i {color: ' . Configuration::get('BAKERY_BANNER1', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER1T', null, null, $id_shop)){
		$css .= '#index #FINALmenu.sticky_menu .top-link-wrapper a, #index #FINALmenu.sticky_menu  .top-link-wrapper span, #index #FINALmenu.sticky_menu .top-link-wrapper i,
				#FINALmenu.sticky_menu #search_block_top input.search_query, #FINALmenu.sticky_menu .menusearch,
				#FINALmenu.sticky_menu .top-link-wrapper a, #FINALmenu.sticky_menu  .top-link-wrapper span, #FINALmenu.sticky_menu .top-link-wrapper i		{color: ' . Configuration::get('BAKERY_BANNER1T', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER2', null, null, $id_shop)){
		$css .= '.advertlink {color: ' . Configuration::get('BAKERY_BANNER2', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER2T', null, null, $id_shop)){
		$css .= '#bakedtweets .tw_title a{color: ' . Configuration::get('BAKERY_BANNER2T', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER3', null, null, $id_shop)){
		$css .= '.store-wrap {background: ' . Configuration::get('BAKERY_BANNER3', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER3T', null, null, $id_shop)){
		$css .= '.store-content .findastore input{background: ' . Configuration::get('BAKERY_BANNER3T', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_INFOTAB', null, null, $id_shop)){
		$css .= '.idTabs a.selected {background: ' . Configuration::get('BAKERY_INFOTAB', null, null, $id_shop) . ' !important} ul.idTabs li a:hover {color: ' . Configuration::get('BAKERY_INFOTAB', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_INFOTABTXT', null, null, $id_shop)){
		$css .= '.idTabs a.selected, .idTabs a.selected:hover  {color: ' . Configuration::get('BAKERY_INFOTABTXT', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_DEALTXT', null, null, $id_shop)){
		$css .= '#product .deal-clock div {color: ' . Configuration::get('BAKERY_DEALTXT', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BANNER', null, null, $id_shop)){
		$css .= '.contact-block {background: ' . Configuration::get('BAKERY_BANNER', null, null, $id_shop) . ' !important} 
		.contact-block .right-block:before {border-color: transparent transparent transparent ' . Configuration::get('BAKERY_BANNER', null, null, $id_shop) . ' !important} 
		.contact-block .description .phone {color: ' . Configuration::get('BAKERY_BANNER', null, null, $id_shop) . ' !important}
		';}
		
		if (Configuration::get('BAKERY_BANNERTXT', null, null, $id_shop)){
		$css .= '.contact-block .left-block span, .contact-block .left-block .paper-plane:after {color: ' . Configuration::get('BAKERY_BANNERTXT', null, null, $id_shop) . ' !important} .contact-block .left-block span {border-right: 1px solid ' . Configuration::get('BAKERY_BANNERTXT', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_FOOTERTOP', null, null, $id_shop)){
		$css .= '.topfooter-container, .bottomfooter-container {background: ' . Configuration::get('BAKERY_FOOTERTOP', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_FOOTER_BG', null, null, $id_shop)){
		$css .= '.footer-container {background: ' . Configuration::get('BAKERY_FOOTER_BG', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_FOOTERSOCIAL', null, null, $id_shop)){
		$css .= '#social_block [class^="ssicon-"], #social_block [class*="ssicon-"] {color: ' . Configuration::get('BAKERY_FOOTERSOCIAL', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_FOOTERSOCIAL_H', null, null, $id_shop)){
		$css .= '#social_block [class^="ssicon-"]:hover, #social_block [class*="ssicon-"]:hover {color: ' . Configuration::get('BAKERY_FOOTERSOCIAL_H', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_NEWSLETTER', null, null, $id_shop)){
		$css .= '#index #newsletter_block_left h4, #index #newsletter_block_left p {color: ' . Configuration::get('BAKERY_NEWSLETTER', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_PLANE', null, null, $id_shop)){
		$css .= '#index #newsletter_block_left .button.button-small{background: ' . Configuration::get('BAKERY_PLANE', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_TITLES', null, null, $id_shop)){
		$css .= '#bakedadvafooterfooter h2{color: ' . Configuration::get('BAKERY_TITLES', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_HEADERU', null, null, $id_shop)){
		$css .= '#bakedadvafooterfooter h2{border-bottom: 1px solid ' . Configuration::get('BAKERY_HEADERU', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BULLET', null, null, $id_shop)){
		$css .= '#bakedadvafooterfooter li.link a:before{color: ' . Configuration::get('BAKERY_BULLET', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BULLET_H', null, null, $id_shop)){
		$css .= '#bakedadvafooterfooter li.link:hover a:before{color: ' . Configuration::get('BAKERY_BULLET_H', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_BOTTOMLINKS', null, null, $id_shop)){
		$css .= '.footer-container #footer a, .footer-container #footer, .footer-container #footer p {color: ' . Configuration::get('BAKERY_BOTTOMLINKS', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_FONTTYPE', null, null, $id_shop)){
		$css .= 'h1, h2, h3, h4, h5, h6, .h1, .h2, .h3, .h4, .h5, .h6, .page-heading, .blog-date, .testimonial-title, .block .title_block a, .block h4 a, .block .title_block a, .block h4, .block .title_block  {font-family: ' . Configuration::get('BAKERY_FONTTYPE', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_FONTTYPE1', null, null, $id_shop)){
		$css .= 'body, .button.button-small, .button.ajax_add_to_cart_button , .button.lnk_view, .price.product-price ,  .price-percent-reduction.small, .new-box, .on_sale, .block .products-block .price-percent-reduction, .page-heading span.heading-counter, #instant_search_results a.close  {font-family: ' . Configuration::get('BAKERY_FONTTYPE1', null, null, $id_shop) . ' !important} ';}
		
		if (Configuration::get('BAKERY_HOMELEFTCOLUMN', null, null, $id_shop)== 0){
		 $css .= '
				';}	
		if (Configuration::get('BAKERY_DISPLAYFOOTER', null, null, $id_shop)== 1){
		$css .= '.footer-container, .topfooter-container, .bottomfooter-container {display:none}
		';}	

		if (Configuration::get('BAKERY_DISPLAYCAT', null, null, $id_shop)== 1){
		$css .= 'div.baked_categories h2{display:none}
		div.baked_categories {margin-top:95px !important}
		';}		
		
		if (Configuration::get('BAKERY_TITLEALIGN', null, null, $id_shop)== 1){
		 $css .= '.baked-featured h2, .info {text-align: center !important}
		 
		';}
		
				
		if (Configuration::get('BAKERY_COLOURSCHEME', null, null, $id_shop)=='transparent'){
		$css .= '#index .header-container {	width: 100%; position: absolute;}

		';
		}
		if (Configuration::get('BAKERY_COLOURSCHEME', null, null, $id_shop)=='fill'){
		$css .= '#index .header-container {	width: 100%; position: relative;}
		';
		}
		
		if (Configuration::get('BAKERY_HEADERSTYLE1', null, null, $id_shop)==0){
		$css .= '.menu-icon, .slidemenu {display:none}
		';
		}
		if (Configuration::get('BAKERY_HEADERSTYLE1', null, null, $id_shop)==1){
		$css .= '#FINALmenu #FINALmenu-desktop-nav > li:first-child {margin-left:40px}
				ul#FINALmenu-desktop-nav  { opacity: 0;}
				ul#FINALmenu-desktop-nav.visible  { opacity:1}

		';
		}
		
		
		
		$myFile = $this->local_path."css/bakery-".$id_shop.".css";

		$fh = fopen($myFile, 'w') or die("can't open file");

		fwrite($fh, $css);

		fclose($fh);
	}



	function hookHeader()
	{
		$id_shop = $this->context->shop->id;
		$theme_settings = array(
			'headerstyle' => (Configuration::get('BAKERY_HEADERSTYLE',  null, null, $id_shop)),
			'displayfooter' => (Configuration::get('BAKERY_DISPLAYFOOTER',  null, null, $id_shop)),
			'displaycat' => (Configuration::get('BAKERY_DISPLAYCAT',  null, null, $id_shop)),
			'colourscheme' => (Configuration::get('BAKERY_COLOURSCHEME', null, null, $id_shop)),
			'headerstyle1' => (Configuration::get('BAKERY_HEADERSTYLE1', null, null, $id_shop)),
			'effectstyle' => (Configuration::get('BAKERY_EFFECTSTYLE', null, null, $id_shop)),
			'map' => (Configuration::get('BAKERY_MAP', $this->context->language->id, null, $id_shop)),
			'call' => (Configuration::get('BAKERY_CALL', $this->context->language->id, null, $id_shop)),
			'call1' => (Configuration::get('BAKERY_CALL1', $this->context->language->id, null, $id_shop)),
			'email' => (Configuration::get('BAKERY_EMAIL', $this->context->language->id, null, $id_shop)),
			'twitterblock' => (Configuration::get('BAKERY_TWITTERBLOCK', $this->context->language->id, null, $id_shop)),
			'facebookblock' => (Configuration::get('BAKERY_FACEBOOKBLOCK', $this->context->language->id, null, $id_shop)),
			'googleblock' => (Configuration::get('BAKERY_GOOGLEBLOCK', $this->context->language->id, null, $id_shop)),
			'second_logo' => Configuration::get('BAKERY_SECOND_LOGO', null, null, $id_shop)
			);
		$this->context->smarty->assign('baked_vars', $theme_settings);

		if (Configuration::get('BAKERY_CUSTOM_CSS', null, null, $id_shop) !='')
			$this->context->controller->addCSS(($this->_path).'css/custom-'.$id_shop.'.css', 'all');
			$this->context->controller->addCSS(($this->_path).'css/font-'.$id_shop.'.css', 'all');
			$this->context->controller->addCSS(($this->_path).'css/font1-'.$id_shop.'.css', 'all');
		$this->context->controller->addCSS(($this->_path).'css/bakery-'.$id_shop.'.css', 'all');
		$this->context->controller->addJS($this->_path.'js/script.js');
	}

}