<?php

/**
 * $ModDesc
 *
 * @version		$Id: file.php $Revision
 * @package		modules
 * @subpackage	$Subpackage.
 * @license		GNU General Public License version 2
 */
if (!defined('_CAN_LOAD_FILES_'))
    define('_CAN_LOAD_FILES_', 1);

if (!class_exists('BakedBase'))
	require_once(_PS_MODULE_DIR_ . '/bakery/libs/bakedbase.php');
if( !class_exists('bakedParams') )
	require_once(_PS_MODULE_DIR_ . '/bakery/libs/params.php');

class bakednewproductsslider extends Module {

    private $_params = '';
    private $_postErrors = array();

    function __construct()
	{
		$this->name			 = 'bakednewproductsslider';
		parent::__construct();
		$this->author		 = 'Baked Themes';
		$this->version		 = '1';
		$this->displayName	 = $this->l('Baked New Products Slider');
		$this->description	 = $this->l('Display new products in a slider');
		$this->module_key	 = "";
		$this->bootstrap	 = true;
		$this->_params = new bakedParams($this->name, $this);
	}

    public function initConfigs()
	{
		return array(
			'new_product_module_theme'	 => 'default',
			'new_product_order_by'		 => '',
			'new_product_limit_items'	 => 12,
			'new_product_scroll_items'	 => 1,
			'new_product_slide_height'	 => 'auto',
			'new_product_slide_width'	 => 'auto',
			'new_product_auto_play'		 => 0,
			'new_product_target'		 => 'same_window',
			'new_product_cre_main_size'	 => 0,
			'new_product_main_img_size'	 => 'cart_default',
			'new_product_main_height'	 => '',
			'new_product_main_width'	 => '',
			'new_product_limit_cols'	 => 4,
			'new_product_show_desc'		 => 1,
			'new_product_show_price'	 => 1,
			'new_product_price_special'	 => 1,
			'new_product_show_title'	 => 1,
			'new_product_show_image'	 => 1,
			'new_product_show_button'	 => 1,
			'new_product_show_pager'	 => 1
		);
	}

    /**
	 * process installing
	 */
	function install()
	{
		if (!parent::install())
			return false;
		if (!$this->registerHook('header'))
			return false;
		if (!$this->registerHook('home'))
			return false;

		$configs = $this->initConfigs();
		$this->_params->batchUpdate($configs);
		return true;
	}

    function hooktop($params)
	{
		return $this->processHook($params, "top");
	}

	function hookHome($params)
	{
		return $this->processHook($params, "home");
	}

	function hookHeader($params)
	{
		if (!defined("new_baked_FEATURE_PRODUCT_"))
		{
			$this->context->controller->addJS(($this->_path).'assets/script.js', 'all');
			define('new_baked_FEATURE_PRODUCT_', 1);
		}
		$this->context->controller->addCSS(($this->_path).'views/assets/style.css', 'all');
		$this->context->controller->addCSS(($this->_path).'views/templates/hook/'.$this->_params->get('new_product_module_theme', 'default').'/assets/style.css', 'all');
	}

    /**
     * Proccess module by hook
     * $pparams: param of module
     * $pos: position call
     */
    function processHook($mparams, $pos = "home")
	{

		$theme = $this->_params->get('new_product_module_theme');
		if (!$this->isCached($theme.'/default.tpl', $this->getCacheId(null)))
		{
			global $cookie, $link, $smarty;

			$id_lang	 = intval($cookie->id_lang);
			//load param
			$params		 = $this->_params;
			$site_url	 = Tools::htmlentitiesutf8('http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__);


			// create thumbnail folder
			$thumbPath = _PS_CACHEFS_DIRECTORY_.$this->name;
			if (!file_exists(_PS_CACHEFS_DIRECTORY_))
				mkdir(_PS_CACHEFS_DIRECTORY_, 0777);
			if (!file_exists($thumbPath))
				mkdir($thumbPath, 0777);
			$thumb_url								 = $site_url."cache/cachefs/".$this->name;
			$configs								 = $this->initConfigs();
			$config_values							 = $this->_params->getConfigFieldsValues($configs);
			$config_values['new_product_auto_play']	 = ($config_values['new_product_auto_play'] == 1) ? 'true' : 'false';
			//config
			$module_id								 = rand().time();
			$params									 = $this->_params;
			$params->set('new_product_auto_renderthumb', 0);

			require_once (dirname(__FILE__).'/libs/bnewslider.php');
			$object = new BNewSlider();
			$object->setThumbPathInfo($thumbPath, $thumb_url)
					->setImagesRendered(array( 'mainImage' => array( (int)$params->get('new_product_main_width', 150), (int)$params->get('new_product_main_height', 100) ) ));

			$listNewProducts = $object->getNewProducts($params);
			//p($listNewProducts);die;
			foreach ($listNewProducts as &$new_product)
			{
				$rate_info				 = self::getAverageGrade($new_product['id_product']);
				$new_product['rate']	 = (int)$rate_info['grade'];
				$new_product['images']	 = Product::getHoverProductsImgs($new_product['id_product']);
			}
			// template asignment variables
			$smarty->assign(array(
				'moduleId'			 => $module_id,
				'site_url'			 => $site_url,
				'config_values'		 => $config_values,
				'listNewProducts'	 => $listNewProducts,
			));
		}

		return $this->display(__FILE__, $theme.'/default.tpl', $this->getCacheId(null));
	}

	public function _clearCache($template, $cache_id = null, $compile_id = null){
		return parent::_clearCache($template, $cache_id, $compile_id);
	}

    /**
     * Render processing form && process saving data.
     */
    public function getContent() {
        $this->_html = "";
        if (Tools::isSubmit('submitUpdate')) {
            $this->_postValidation();
            if (!sizeof($this->_postErrors)) {
                $configs = $this->initConfigs();
                $res = $this->_params->batchUpdate($configs);

                if (!$res)
                    $this->_html .= $this->displayError($this->l('Configuration could not be updated'));
                else
                    $this->_html .= $this->displayConfirmation($this->l('Configuration updated'));
            }else {
                foreach ($this->_postErrors as $err) {
                    $this->_html .= '<div class="alert error">' . $err . '</div>';
                }
            }
        }
        return $this->_html . $this->renderForm();
    }

    /**
     * Render Configuration From for user making settings.
     * @return context
     */
    protected function renderForm() {
        $configs = $this->initConfigs();
        $params = $this->_params;
        $themes = $params->getFolderList(dirname(__FILE__) . "/views/templates/hook/");
        $arrOder = array(
            array('id' => 'date_add ASC', 'name' => $this->l('Date Add')),
            array('id' => 'date_add DESC', 'name' => $this->l('Date Add DESC')),
            array('id' => 'name ASC', 'name' => $this->l('Name')),
            array('id' => 'name DESC', 'name' => $this->l('Name DESC')),
            array('id' => 'quantity ASC', 'name' => $this->l('Quantity')),
            array('id' => 'quantity DESC', 'name' => $this->l('Quantity DESC')),
            array('id' => 'price ASC', 'name' => $this->l('Price')),
            array('id' => 'price DESC', 'name' => $this->l('Price DESC'))
        );
        $options = array(
            array('id' => '_blank', 'name' => $this->l('New Window')),
            array('id' => '_self', 'name' => $this->l('Same Window'))
        );
        $formats = array(
            array('id' => 'home_default', 'name' => $this->l('home_default(124x124)')),
            array('id' => 'large_default', 'name' => $this->l('large_default(264x264)')),
            array('id' => 'medium_default', 'name' => $this->l('medium_default(58x58)')),
            array('id' => 'small_default', 'name' => $this->l('small_default(45x45)')),
            array('id' => 'thickbox_default', 'name' => $this->l('thickbox_default(600x600)')),
        );

        $this->fields_form[0]['form'] = array(
            'legend' => array(
                'title' => $this->l('Global Setting'),
                'icon' => 'icon-cogs'
            ),
            'input' => array(
                $params->selectTags('new_product_module_theme', 'Theme - Layout', $themes),
                $params->selectTags('new_product_order_by', ' Order by', $arrOder),
                $params->inputTags('new_product_limit_items', 'Limit items'),
                $params->inputTags('new_product_scroll_items', 'Scroll items'),
                //$params->inputTags('new_product_slide_height', 'Slide Height'),
                $params->inputTags('new_product_slide_width', 'Slide Width'),
                $params->switchTags('new_product_auto_play', 'Auto Play Slider')
            ),
            'submit' => array(
                'title' => $this->l('Save'),
            )
        );
        $this->fields_form[1]['form'] = array(
            'legend' => array(
                'title' => 'Main Slider Setting',
                'icon' => 'icon-cogs'
            ),
            'input' => array(
                $params->selectTags('new_product_target', 'Open Link', $options),
                $params->switchTags('new_product_cre_main_size', 'Create Size of Main Image'),
                $params->selectTags('new_product_main_img_size', 'Main Image Size', $formats),
                $params->inputTags('new_product_limit_cols', 'Limit Column'),
                $params->switchTags('new_product_show_desc', 'Enable Main Description'),
                $params->switchTags('new_product_show_price', 'Enable Main Price '),
                $params->switchTags('new_product_price_special', 'Enable Price without Reduction'),
                $params->switchTags('new_product_show_title', 'Enable Main Title'),
                $params->switchTags('new_product_show_image', 'Enable Main Image'),
                $params->switchTags('new_product_show_button', 'Enable Button Navigation'),
                $params->switchTags('new_product_show_pager', 'Enable Pager Navigation '),
            ),
            'submit' => array(
                'title' => $this->l('Save'),
            )
        );
        $this->fields_form[2]['form'] = array(
            'legend' => array(
                'title' => 'Information',
                'icon' => 'icon-cogs'
            ),

            'submit' => array(
                'title' => $this->l('Save'),
            )
        );
        $helper = new HelperForm();
        $helper->show_toolbar = false;
        $helper->table = $this->table;
        $lang = new Language((int) Configuration::get('PS_LANG_DEFAULT'));
        $helper->default_form_language = $lang->id;
        $helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;

        $helper->identifier = $this->identifier;
        $helper->submit_action = 'submitUpdate';
        $helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false) . '&configure=' . $this->name . '&tab_module=' . $this->tab . '&module_name=' . $this->name;
        $helper->token = Tools::getAdminTokenLite('AdminModules');
        $helper->tpl_vars = array(
            'fields_value' => $params->getConfigFieldsValues($configs),
            'languages' => $this->context->controller->getLanguages(),
            'id_language' => $this->context->language->id
        );

        return $helper->generateForm($this->fields_form);
    }

    /**
     * Process vadiation before saving data
     */
    private function _postValidation() {
       // if (!Validate::isCleanHtml(Tools::getValue('new_product_slide_height')))
         //   $this->_postErrors[] = $this->l('The Slide height you entered was not allowed, sorry');
        if (!Validate::isCleanHtml(Tools::getValue('new_product_slide_width')))
            $this->_postErrors[] = $this->l('The Slide width you entered was not allowed, sorry');
    }

    public function getParam() {
        return $this->_params;
    }

	public static function getAverageGrade($id_product)
	{
		$validate = Configuration::get('PRODUCT_COMMENTS_MODERATE');

		return Db::getInstance(_PS_USE_SQL_SLAVE_)->getRow('
		SELECT (SUM(pc.`grade`) / COUNT(pc.`grade`)) AS grade
		FROM `'._DB_PREFIX_.'product_comment` pc
		WHERE pc.`id_product` = '.(int)$id_product.'
		AND pc.`deleted` = 0'.
		($validate == '1' ? ' AND pc.`validate` = 1' : ''));
	}
}
