<?php
/**
 * Baked Look Book module
 *
 * @author    Baked Themes
 * @copyright Baked Themes
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

if (!defined('_PS_VERSION_'))
	exit;

include_once dirname(__FILE__).'/BakedLookBookClass.php';
include_once dirname(__FILE__).'/BakedLookBookGroup.php';

class BakedLookBook extends Module
{

	protected static $access_rights	 = 0775;

	public $fields_list;

	public $fields_list_look_book;

	public $fields_list_banner;

	public $fields_value;

	public $fields_form;

	public $fields_form_look_book;

	private $_html			 = '';

	private $spacer_size	 = '5';

	public function __construct()
	{
		$this->name			 = 'bakedlookbook';
		$this->tab			 = 'front_office_features';
		$this->version		 = '1.0';
		$this->author		 = 'Baked Themes';
		$this->need_instance = 0;
		$this->bootstrap	 = true;

		parent::__construct();

		$this->displayName	 = $this->l('Baked Look Book');
		$this->description	 = $this->l('Allow admin you to create lookbooks.');
	}

	public function install()
	{
		if($this->id && !$this->isRegisteredInHook('moduleRoutes'))
            $this->registerHook('moduleRoutes');
		return (parent::install() && $this->createTables() && $this->registerHook('displayHeader') && $this->registerHook('displayBackOfficeHeader'));
	}

	/**
	 * Creates tables
	 */
	public function createTables()
	{
		/* Look book table */
		$return1 = (bool)Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'baked_look_book` (
				`id_baked_look_book` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
				`id_baked_look_book_group` int(10) unsigned NOT NULL,
    			`image` varchar(255) DEFAULT NULL,
    			`thumb` varchar(255) DEFAULT NULL,
    			`new_window` TINYINT(1) DEFAULT 0,
                `active` tinyint(1) unsigned NOT NULL DEFAULT 1,
                `position` int(10) unsigned NOT NULL DEFAULT 0,
				PRIMARY KEY (`id_baked_look_book`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8 ;');

		/* Look book points */
		$return2 = (bool)Db::getInstance()->Execute('
				CREATE TABLE `'._DB_PREFIX_.'baked_look_book_points` (
					`id_rec` int(10) unsigned NOT NULL AUTO_INCREMENT,
					`id_coord` VARCHAR(100),
					`id_shop` int(10) unsigned NOT NULL,
					`id_lang` int(10) unsigned NOT NULL,
					`id_baked_look_book` int(10) unsigned NOT NULL,
					`coordinateX` int(10) unsigned NOT NULL,
					`coordinateY` int(10) unsigned NOT NULL,
					`point_type` VARCHAR(255),
					`product_name` VARCHAR(100),
					`product_link_rewrite` VARCHAR(100),
					`product_image` VARCHAR(100),
					`product_image_link` VARCHAR(400),
					`id_product` int(10),
					`point_text` VARCHAR(255),
					PRIMARY KEY (`id_rec`)
			    ) ENGINE = '._MYSQL_ENGINE_.' DEFAULT CHARSET=UTF8;');

		/* Lookbook lang configuration */
		$return3 = Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'baked_look_book_lang` (
				`id_baked_look_book` int(10) UNSIGNED NOT NULL,
				`id_lang` int(10) unsigned NOT NULL ,
    			`url` varchar(255) DEFAULT NULL,
                `description` text,
                `button` varchar(255) DEFAULT NULL,
                `image_multi_lang` varchar(255) DEFAULT NULL,
                `thumb_multi_lang` varchar(255) DEFAULT NULL,
                `title` varchar(255) DEFAULT NULL,
				PRIMARY KEY (`id_baked_look_book`, `id_lang`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8 ;');

		/* look book group */
		$return4 = (bool)Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'baked_look_book_group` (
				`id_baked_look_book_group` int(10) UNSIGNED NOT NULL AUTO_INCREMENT,
                `name` varchar(255) DEFAULT NULL,
                `active` tinyint(1) unsigned NOT NULL DEFAULT 1,
				`image`	varchar(255) DEFAULT NULL,
                `position` int(10) unsigned NOT NULL DEFAULT 0,
				PRIMARY KEY (`id_baked_look_book_group`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8 ;');

		/* Lookbook group shop */
		$return5 = (bool)Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'baked_look_book_group_shop` (
				`id_baked_look_book_group` int(10) UNSIGNED NOT NULL,
                `id_shop` int(11) NOT NULL,
                PRIMARY KEY (`id_baked_look_book_group`,`id_shop`),
                KEY `id_shop` (`id_shop`)
			) ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8 ;');

		return $return1 && $return2 && $return3 && $return4 && $return5;
	}

	public function uninstall()
	{
		return ($this->deleteTables() && parent::uninstall());
	}

	/**
	 * deletes tables
	 */
	public function deleteTables()
	{
		return Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'baked_look_book`,`'._DB_PREFIX_.'baked_look_book_points`,`'._DB_PREFIX_.'baked_look_book_lang`,`'._DB_PREFIX_.'baked_look_book_group`,`'._DB_PREFIX_.'baked_look_book_shop`');
	}

	private function _checkImageDir()
	{
		$result = '';
		if (!file_exists(_PS_UPLOAD_DIR_.$this->name))
		{
			$success = @mkdir(_PS_UPLOAD_DIR_.$this->name, self::$access_rights, true) || @chmod(_PS_UPLOAD_DIR_.$this->name, self::$access_rights);
			if (!$success)
				$this->_html .= $this->displayError('"'._PS_UPLOAD_DIR_.$this->name.'" '.$this->l('An error occurred during new folder creation'));
		}
		if (!is_writable(_PS_UPLOAD_DIR_))
			$this->_html .= $this->displayError('"'._PS_UPLOAD_DIR_.$this->name.'" '.$this->l('directory isn\'t writable.'));
		return $result;
	}

	public function getContent()
	{
		$this->context->controller->addCSS(($this->_path).'css/admin.css');
		$this->context->controller->addJS(($this->_path).'js/admin.js');
		$this->_checkImageDir();
		$id_baked_look_book_group	 = (int)Tools::getValue('id_baked_look_book_group');
		$id_baked_look_book			 = (int)Tools::getValue('id_baked_look_book');
		if ((Tools::isSubmit('groupstatuslookbook')))
		{
			$baked_look_book_group = new BakedLookBookGroup((int)$id_baked_look_book_group);
			if ($baked_look_book_group->id && $baked_look_book_group->toggleStatus())
				Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'));
			else
				$this->_html .= $this->displayError($this->l('An error occurred while updating the status.'));
		}
		if ((Tools::isSubmit('lookbookstatusbakedlookbook')))
		{
			$look_book = new BakedLookBookClass((int)$id_baked_look_book);
			$id_baked_look_book_group = Tools::getValue('id_baked_look_book_group');
			if ($look_book->id && $look_book->toggleStatus())
				Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&id_baked_look_book_group='.$id_baked_look_book_group.'&id_baked_look_book_group='.$look_book->id_baked_look_book_group.'&viewbaked_look_book_group&token='.Tools::getAdminTokenLite('AdminModules'));
			else
				$this->_html .= $this->displayError($this->l('An error occurred while updating the status.'));
		}
		if (Tools::isSubmit('way') && Tools::isSubmit('action') == 'updatePositions')
		{
			$look_book = new BakedLookBookClass((int)$id_baked_look_book);
			if ($look_book->id && $look_book->updatePosition((int)Tools::getValue('way'), (int)Tools::getValue('position')))
				Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&id_baked_look_book_group='.$look_book->id_baked_look_book_group.'&viewbaked_look_book_group&token='.Tools::getAdminTokenLite('AdminModules'));
			else
				$this->_html .= $this->displayError($this->l('Failed to update the position.'));
		}
		if (Tools::getValue('savebakedlookbookgroup'))
		{
			if ($id_baked_look_book_group)
				$baked_look_book_group	 = new BakedLookBookGroup((int)$id_baked_look_book_group);
			else
				$baked_look_book_group	 = new BakedLookBookGroup();
			$error = array();
			$baked_look_book_group->name = Tools::getValue('name');
			$baked_look_book_group->active = Tools::getValue('active');
			if (!$baked_look_book_group->name)
				$error[] = $this->displayError($this->l('The field "Look Book name" is required'));
			if (isset($_FILES['image']) && isset($_FILES['image']['tmp_name']) && !empty($_FILES['image']['tmp_name']))
			{
				if (ImageManager::validateUpload($_FILES['image'], 4000000))
					return $this->displayError($this->l('Invalid image'));
				else
				{
					$ext		 = Tools::substr($_FILES['image']['name'], Tools::strrpos($_FILES['image']['name'], '.') + 1);
					$file_name	 = md5($_FILES['image']['name']).'.'.$ext;
					if (!move_uploaded_file($_FILES['image']['tmp_name'], dirname(__FILE__).'/img/'.$file_name))
						return $this->displayError($this->l('An error occurred while attempting to upload the file.'));
					else
					{
						$file_path = dirname(__FILE__).'/img/'.Configuration::get('image');
						if (Configuration::hasContext('image', null, Shop::getContext()) &&	Configuration::get('image') != $file_name && file_exists($file_path))
							unlink($file_path);
						$baked_look_book_group->image = $file_name;
					}
				}
			}
			if (!count($error) && $baked_look_book_group->validateFields(false) && $baked_look_book_group->validateFieldsLang(false))
			{
				if ($baked_look_book_group->save())
				{
					Db::getInstance()->execute('DELETE FROM '._DB_PREFIX_.'baked_look_book_group_shop WHERE id_baked_look_book_group='.(int)$baked_look_book_group->id);
					if (!Shop::isFeatureActive())
					{
						Db::getInstance()->insert('baked_look_book_group_shop', array(
							'id_baked_look_book_group'	 => (int)$baked_look_book_group->id,
							'id_shop'					 => (int)Context::getContext()->shop->id,
						));
					}
					else
					{
						$assos_shop = Tools::getValue('checkBoxShopAsso_baked_look_book_group');
						if (empty($assos_shop))
							return false;
						foreach ($assos_shop as $id_shop => $row)
							Db::getInstance()->insert('baked_look_book_group_shop', array(
								'id_baked_look_book_group'	 => (int)$baked_look_book_group->id,
								'id_shop'					 => (int)$id_shop,
							));
					}
					$this->_html .= $this->displayConfirmation($this->l('Look Book Group').' '.($id_baked_look_book_group ? $this->l('updated') : $this->l('added')));
				}
				else
					$this->_html .= $this->displayError($this->l('An error occurred during look book group').' '.($id_baked_look_book_group ? $this->l('updating') : $this->l('creation')));
			}
			else
				$this->_html .= count($error) ? implode('', $error) : $this->displayError($this->l('Invalid value for field(s).'));
		}
		if (Tools::getValue('savebakedlookbook'))
		{
			if ($id_baked_look_book)
				$look_book	 = new BakedLookBookClass((int)$id_baked_look_book);
			else
				$look_book	 = new BakedLookBookClass();
			/**/

			$error = array( );

			$languages		 = Language::getLanguages(false);
			$default_lang	 = (int)Configuration::get('PS_LANG_DEFAULT');
			if (!Tools::isSubmit('has_image_'.$default_lang) && (!isset($_FILES['image_multi_lang_'.$default_lang]) || empty($_FILES['image_multi_lang_'.$default_lang]['tmp_name'])))
			{
				$default_language = new Language($default_lang);
				$error[]		 = $this->displayError($this->l('Image is required at least in ').$default_language->name);
			}
			else
			{
				$look_book->id_baked_look_book_group = (int)Tools::getValue('id_baked_look_book_group');

				if (!$look_book->id_baked_look_book_group)
					$error[] = $this->displayError($this->l('The field "Look Book Group" is required'));
				else
				{
					$res	 = $this->bkUploadImage('image_multi_lang_'.$default_lang);
					if (count($res['error']))
						$error	 = array_merge($error, $res['error']);
					elseif ($res['image'] && $res['thumb'])
					{
						$look_book->image_multi_lang[$default_lang]	 = $res['image'];
						$look_book->thumb_multi_lang[$default_lang]	 = $res['thumb'];
					}
					elseif (!Tools::isSubmit('has_image_'.$default_lang) && !$res['image'] && !$res['thumb'])
					{
						$default_language = new Language($default_lang);
						$error[]		 = $this->displayError($this->l('Image is required at least in ').$default_language->name);
					}

					if ($look_book->image_multi_lang[$default_lang] && $look_book->thumb_multi_lang[$default_lang])
					{
						foreach ($languages as $lang)
						{
							if ($lang['id_lang'] == $default_lang)
								continue;
							$res	 = $this->bkUploadImage('image_multi_lang_'.$lang['id_lang']);
							if (count($res['error']))
								$error	 = array_merge($error, $res['error']);
							elseif ($res['image'] && $res['thumb'])
							{
								$look_book->image_multi_lang[$lang['id_lang']]	 = $res['image'];
								$look_book->thumb_multi_lang[$lang['id_lang']]	 = $res['thumb'];
							}
							elseif (!Tools::isSubmit('has_image_'.$lang['id_lang']) && !$res['image'] && !$res['thumb'])
							{
								$look_book->image_multi_lang[$lang['id_lang']]	 = $look_book->image_multi_lang[$default_lang];
								$look_book->thumb_multi_lang[$lang['id_lang']]	 = $look_book->thumb_multi_lang[$default_lang];
							}
						}
					}
				}
			}
			$look_book->active = Tools::getValue('active');
			$look_book->position = Tools::getValue('position');
			$look_book->new_window = Tools::getValue('new_window');
			foreach ($languages as $lang)
			{
				$look_book->url[$lang['id_lang']] = Tools::getValue ('url_'.$lang['id_lang']);
				$look_book->title[$lang['id_lang']] = Tools::getValue ('title_'.$lang['id_lang']);
			}
			if (!count($error) && $look_book->validateFields(false) && $look_book->validateFieldsLang(false))
			{
				/* position */
				$look_book->position = $look_book->checkPosition();

				if ($look_book->save())
				{
					if (Tools::getValue('savebakedlookbookAndStay'))
						Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&id_baked_look_book='.$look_book->id.'&updatebakedlookbook&token='.Tools::getAdminTokenLite('AdminModules'));
					else
						Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&id_baked_look_book_group='.$look_book->id_baked_look_book_group.'&viewbaked_look_book_group&token='.Tools::getAdminTokenLite('AdminModules'));
				}
				else
					$this->_html .= $this->displayError($this->l('An error occurred during look book').' '.($id_baked_look_book ? $this->l('updating') : $this->l('creation')));
			}
			else
				$this->_html .= count($error) ? implode('', $error) : $this->displayError($this->l('Invalid value for field(s).'));
		}

		if (Tools::isSubmit('addbakedlookbookgroup') || (Tools::isSubmit('updatebaked_look_book_group') && $id_baked_look_book_group))
		{
			$helper = $this->initForm();
			return $helper->generateForm($this->fields_form);
		}
		elseif (Tools::isSubmit('addbakedlookbook') || (Tools::isSubmit('updatebakedlookbook') && $id_baked_look_book))
		{
			$helper = $this->initFormLookBook(0);
			return $helper->generateForm($this->fields_form_look_book);
		}
		elseif (Tools::isSubmit('addbakedlookbookbanner') || (Tools::isSubmit('updatebakedlookbook') && $id_baked_look_book))
		{
			$helper = $this->initFormLookBook(1);
			return $helper->generateForm($this->fields_form_look_book);
		}
		elseif (Tools::isSubmit('viewbaked_look_book_group'))
		{
			$baked_look_book_group	 = new BakedLookBookGroup($id_baked_look_book_group);
			if (!$baked_look_book_group->isAssociatedToShop())
				Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'));
			$helper					 = $this->initListLookBook();
			return $this->_html.$helper->generateList(BakedLookBookClass::getAll($id_baked_look_book_group, (int)$this->context->language->id, 0, 0), $this->fields_list);
		}
		else if (Tools::isSubmit('deletebaked_look_book') && $id_baked_look_book)
		{
			$look_book = new BakedLookBookClass($id_baked_look_book);
			$look_book->delete();
			Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&id_baked_look_book_group='.$id_baked_look_book_group.'&viewbakedlookbook&token='.Tools::getAdminTokenLite('AdminModules'));
		}
		else if (Tools::isSubmit('deletebaked_look_book_group') && $id_baked_look_book_group)
		{
			$baked_look_book_group = new BakedLookBookGroup($id_baked_look_book_group);
			$baked_look_book_group->delete();
			Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'));
		}
		else if (Tools::isSubmit('groupstatusbaked_look_book_group'))
		{
			$baked_look_book_group = new BakedLookBookGroup($id_baked_look_book_group);
			$baked_look_book_group->active = !$baked_look_book_group->active;
			$baked_look_book_group->save();
			Tools::redirectAdmin(AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'));
		}
		else
		{
			$helper = $this->initList();
			$lookbookgroups = BakedLookBookGroup::getAll();
			foreach ($lookbookgroups as &$group)
				$group['link'] = '';

			return $this->_html.$helper->generateList($lookbookgroups, $this->fields_list);
		}
	}

	protected function bkUploadImage($item)
	{
		$result = array(
			'error'	 => array( ),
			'image'	 => '',
			'thumb'	 => '',
		);
		if (isset($_FILES[$item]) && isset($_FILES[$item]['tmp_name']) && !empty($_FILES[$item]['tmp_name']))
		{
			$type		 = Tools::strtolower(Tools::substr(strrchr($_FILES[$item]['name'], '.'), 1));
			$image_size	 = @getimagesize($_FILES[$item]['tmp_name']);
			if (!empty($image_size) &&
					in_array(Tools::strtolower(Tools::substr(strrchr($image_size['mime'], '/'), 1)), array( 'jpg', 'gif', 'jpeg', 'png' )) &&
					in_array($type, array( 'jpg', 'gif', 'jpeg', 'png' )))
			{
				$temp_name			 = tempnam(_PS_TMP_IMG_DIR_, 'PS');
				$salt				 = sha1(microtime());
				$c_name				 = Tools::encrypt($_FILES[$item]['name'].$salt);
				$c_name_thumb		 = $c_name.'_thumb';
				$upload_error		 = ImageManager::validateUpload($_FILES[$item]);
				if ($upload_error)
					$result['error'][]	 = $upload_error;
				elseif (!$temp_name || !move_uploaded_file($_FILES[$item]['tmp_name'], $temp_name))
					$result['error'][]	 = $this->l('An error occurred during move image.');
				else
				{
					$infos				 = getimagesize($temp_name);
					$ratio_y			 = 72;
					$ratio_x			 = $infos[0] / ($infos[1] / $ratio_y);
					if (!ImageManager::resize($temp_name, _PS_UPLOAD_DIR_.$this->name.'/'.$c_name.'.'.$type, null, null, $type) || !ImageManager::resize($temp_name, _PS_UPLOAD_DIR_.$this->name.'/'.$c_name_thumb.'.'.$type, $ratio_x, $ratio_y, $type))
						$result['error'][]	 = $this->l('An error occurred during the image upload.');
				}
				if (isset($temp_name))
					@unlink($temp_name);

				if (!count($result['error']))
				{
					$result['image'] = _THEME_PROD_PIC_DIR_.$this->name.'/'.$c_name.'.'.$type;
					$result['thumb'] = _THEME_PROD_PIC_DIR_.$this->name.'/'.$c_name_thumb.'.'.$type;
				}
				return $result;
			}
		}
		else
			return $result;
	}

	protected function initForm()
	{
		$id_baked_look_book_group	 = (int)Tools::getValue('id_baked_look_book_group');
		$lookbook_group				 = new BakedLookBookGroup($id_baked_look_book_group);
		$this->fields_form[0]['form'] = array(
			'legend'	 => array(
				'title' => $this->l('Look Book Group'),
			),
			'input'		 => array(
				array(
					'type'		 => 'text',
					'label'		 => $this->l('Group name:'),
					'name'		 => 'name',
					'size'		 => 64,
					'required'	 => true,
				),
				array(
					'type'	 => 'file',
					'label'	 => $this->l('Group image'),
					'name'	 => 'image',
					'desc'   => '<div class="image-holder input-holder"><img  src="'.$this->_path.'img/'.$lookbook_group->image.'"/></div>'
				),
				array(
					'type'			 => 'switch',
					'label'			 => $this->l('Status:'),
					'name'			 => 'active',
					'class'			 => 't',
					'is_bool'		 => true,
					'default_value'	 => 1,
					'values'		 => array(
						array(
							'id'	 => 'active_on',
							'value'	 => 1,
							'label'	 => $this->l('Enabled')
						),
						array(
							'id'	 => 'active_off',
							'value'	 => 0,
							'label'	 => $this->l('Disabled')
						)
					),
				),
			),
			'buttons'	 => array(
				array(
					'type'	 => 'submit',
					'title'	 => $this->l('Save'),
					'icon'	 => 'process-icon-save',
					'class'	 => 'pull-right'
				),
			)
		);

		if (Shop::isFeatureActive())
		{
			$this->fields_form[0]['form']['input'][] = array(
				'type'	 => 'shop',
				'label'	 => $this->l('Shop association:'),
				'name'	 => 'checkBoxShopAsso',
			);
		}

		$default_lang			 = (int)Configuration::get('PS_LANG_DEFAULT');
		$helper					 = new HelperForm();
		$helper->module			 = $this;
		$helper->name_controller = 'bakedlookbook';
		$helper->token			 = Tools::getAdminTokenLite('AdminModules');
		foreach (Language::getLanguages(false) as $lang)
			$helper->languages[]	 = array(
				'id_lang'	 => $lang['id_lang'],
				'iso_code'	 => $lang['iso_code'],
				'name'		 => $lang['name'],
				'is_default' => ($default_lang == $lang['id_lang'] ? 1 : 0)
			);

		$helper->currentIndex				 = AdminController::$currentIndex.'&configure='.$this->name;
		$helper->default_form_language		 = $default_lang;
		$helper->allow_employee_form_lang	 = $default_lang;
		$helper->toolbar_scroll				 = true;
		$helper->title						 = $this->displayName;
		$helper->submit_action				 = 'savebakedlookbookgroup';
		$helper->table						 = BakedLookBookGroup::$definition['table'];
		$helper->identifier					 = BakedLookBookGroup::$definition['primary'];


		if ($lookbook_group->id)
		{
			$helper->id								 = $lookbook_group->id;
			$this->fields_form[0]['form']['input'][] = array( 'type'	 => 'hidden', 'name'	 => 'id_baked_look_book_group' );
		}
		$helper->fields_value				 = $this->getFieldsValueSt($lookbook_group);


		$helper->toolbar_btn = array(
			'save'	 =>
			array(
				'desc'	 => $this->l('Save'),
				'href'	 => AdminController::$currentIndex.'&configure='.$this->name.'&savebakedlookbookgroup&token='.Tools::getAdminTokenLite('AdminModules'),
			),
			'back'	 =>
			array(
				'href'	 => AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
				'desc'	 => $this->l('Back to list')
			)
		);
		return $helper;
	}

	protected function initFormLookBook()
	{
		$this->fields_form_look_book[0]['form']	 = array(
			'legend'	 => array(
				'title' => $this->l('Look Book'),
			),
			'input'		 => array(
				array(
					'type'		 => 'select',
					'label'		 => $this->l('Look Book:'),
					'name'		 => 'id_baked_look_book_group',
					'required'	 => true,
					'options'	 => array(
						'query'		 => BakedLookBookGroup::getAll(),
						'id'		 => 'id_baked_look_book_group',
						'name'		 => 'name',
						'default'	 => array(
							'value'	 => 0,
							'label'	 => $this->l('Please select')
						)
					)
				),
				/*
				  array(
				  'type' => 'textarea',
				  'label' => $this->l('Embedded video:'),
				  'name' => 'video',
				  'cols' => 80,
				  'rows' => 10,
				  'lang' => true,
				  'desc' => $this->l('Paste here above an iFrame, set the width and the height to 100% to make the video fit the slideshow.'),
				  ),
				 */
				array(
					'type'	 => 'text',
					'label'	 => $this->l('Title:'),
					'name'	 => 'title',
					'size'	 => 64,
					'lang'	 => true,
				),
				array(
					'type'	 => 'text',
					'label'	 => $this->l('Link:'),
					'name'	 => 'url',
					'size'	 => 64,
					'lang'	 => true,
				),
				array(
					'type'			 => 'switch',
					'label'			 => $this->l('Open in a new window:'),
					'name'			 => 'new_window',
					'class'			 => 't',
					'is_bool'		 => true,
					'default_value'	 => 0,
					'values'		 => array(
						array(
							'id'	 => 'new_window_on',
							'value'	 => 1,
							'label'	 => $this->l('Yes') ),
						array(
							'id'	 => 'new_window_off',
							'value'	 => 0,
							'label'	 => $this->l('No') ),
					),
				),
				array(
					'type'			 => 'switch',
					'label'			 => $this->l('Status:'),
					'name'			 => 'active',
					'class'			 => 't',
					'is_bool'		 => true,
					'default_value'	 => 1,
					'values'		 => array(
						array(
							'id'	 => 'active_on',
							'value'	 => 1,
							'label'	 => $this->l('Enabled')
						),
						array(
							'id'	 => 'active_off',
							'value'	 => 0,
							'label'	 => $this->l('Disabled')
						)
					),
				),
				array(
					'type'			 => 'text',
					'label'			 => $this->l('Position:'),
					'name'			 => 'position',
					'default_value'	 => 0,
				),
			),
			'buttons'	 => array(
				array(
					'type'	 => 'submit',
					'title'	 => $this->l(' Save all '),
					'icon'	 => 'process-icon-save',
					'class'	 => 'pull-right'
				),
			),
			'submit'	 => array(
				'title'	 => $this->l('Save and stay'),
				'stay'	 => true
			),
		);
		$languages								 = Language::getLanguages(true);
		$default_lang							 = (int)Configuration::get('PS_LANG_DEFAULT');
		foreach ($languages as $lang)
		{
			$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']] = array(
				'type'		 => 'file',
				'label'		 => $this->l('Image').' - '.$lang['name'].($default_lang == $lang['id_lang'] ? '('.$this->l('default language').')' : '').':',
				'name'		 => 'image_multi_lang_'.$lang['id_lang'],
				'required'	 => ($default_lang == $lang['id_lang']),
			);
		}

		$helper					 = new HelperForm();
		$helper->module			 = $this;
		$helper->name_controller = 'bakedlookbook';
		$helper->identifier		 = $this->identifier;
		$helper->token			 = Tools::getAdminTokenLite('AdminModules');
		foreach ($languages as $lang)
			$helper->languages[]	 = array(
				'id_lang'	 => $lang['id_lang'],
				'iso_code'	 => $lang['iso_code'],
				'name'		 => $lang['name'],
				'is_default' => ($default_lang == $lang['id_lang'] ? 1 : 0)
			);

		$helper->currentIndex				 = AdminController::$currentIndex.'&configure='.$this->name;
		$helper->default_form_language		 = $default_lang;
		$helper->allow_employee_form_lang	 = $default_lang;
		$helper->toolbar_scroll				 = true;
		$helper->title						 = $this->displayName.' - '.$this->l('Look Book');
		$helper->submit_action				 = 'savebakedlookbook';

		$id_baked_look_book		 = (int)Tools::getValue('id_baked_look_book');
		$id_baked_look_book_group	 = (int)Tools::getValue('id_baked_look_book_group');
		$lookbook						 = new BakedLookBookClass($id_baked_look_book);
		$id_shop				= $this->context->shop->id;
		$coordinates	 = array();
		if (Validate::isLoadedObject($lookbook))
		{
			$this->fields_form_look_book[0]['form']['input'][] = array( 'type'	 => 'hidden', 'name'	 => 'id_baked_look_book' );
			foreach ($languages as $lang)
				if ($lookbook->image_multi_lang[$lang['id_lang']])
				{
					$this->fields_form_look_book[0]['form']['input'][] = array( 'type'			 => 'hidden',
																				'name'			 => 'has_image_'.$lang['id_lang'],
																				'default_value'	 => 1 );
					$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['required']	 = false;
					$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc']		 = '<div data-idimg="'.$id_baked_look_book.'" data-idshop="'.$id_shop.'" data-idlang="'.$lang['id_lang'].'" id="input-holder-'.$lang['id_lang'].'" class="image-holder input-holder"><div data-langid="'.$lang['id_lang'].'" class="imgWrapper"><img  src="'.$lookbook->image_multi_lang[$lang['id_lang']].'"/>';
					$coordinates = Db::getInstance()->ExecuteS('SELECT *
																			FROM `'._DB_PREFIX_.'baked_look_book_points`
																			WHERE `id_lang` ='.$lang['id_lang'].'
																			AND `id_shop` = '.$id_shop.'
																			AND `id_baked_look_book` ='.$id_baked_look_book);

					if (!empty($coordinates))
						$i = 1;
						foreach ($coordinates as $coordinate)
						{
							$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '<div class="point_label" data-pointid="'.$coordinate['id_coord'].'" style="top:'.$coordinate['coordinateY'].'px; left:'.$coordinate['coordinateX'].'px;">'.$i.'</div>';
							$i++;
						}

					$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '</div>';
					if (!empty($coordinates))
					{
						$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '<div class="coordinates-holder">';
						$i = 1;
						foreach ($coordinates as $coords)
						{
							$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '<div class="points" data-pointid="'.$coords['id_coord'].'">';
							$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '<div class="manage"><span class="num">'.$i.'</span><span class="dot">.</span><label for="product">Product</label>
                                                        </div>';
							$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '<span class="remove-point">&times;</span>';

							$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '
                                                        <div class="productContainer"><input type="text" data-idlang='.$lang['id_lang'].' data-pid='.$coords['id_coord'].' value="'.$coords['product_name'].'" class="product_autocomplete" placeholder="'.$this->l('Start to type the name of product').'" />';
							if ($coords['product_image_link'] != '')
								$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '<img src="'.$coords['product_image_link'].'" class="prodImg" />';
							$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '</div></div>';
							$i++;
						}
						$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '</div>';
						$this->fields_form_look_book[0]['form']['input']['image_multi_lang_'.$lang['id_lang']]['desc'] .= '</div>';

					}

				}
		}
		elseif ($id_baked_look_book_group)
			$lookbook->id_baked_look_book_group = $id_baked_look_book_group;
		$helper->fields_value				 = $this->getFieldsValueSt($lookbook, 'fields_form_look_book');
		$helper->toolbar_btn = array(
			'save'	 =>
			array(
				'desc'	 => $this->l('Save'),
				'href'	 => AdminController::$currentIndex.'&configure='.$this->name.'&savebakedlookbook&token='.Tools::getAdminTokenLite('AdminModules'),
			),
			'back'	 =>
			array(
				'href'	 => AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
				'desc'	 => $this->l('Back to list')
			)
		);
		return $helper;
	}


	protected function initList()
	{
		$this->fields_list = array(
			'id_baked_look_book_group'	 => array(
				'title'	 => $this->l('Id'),
				'width'	 => 120,
				'type'	 => 'text'
			),
			'name'						 => array(
				'title'	 => $this->l('Name'),
				'width'	 => 200,
				'type'	 => 'text'
			),
			'image'						 => array(
				'title'				 => $this->l('Image'),
				'width'				 => 200,
				'type'				 => 'text',
				'callback'			 => 'showGroupImage',
				'callback_object'	 => 'bakedlookbook'
			),
			'link' => array(
					'type' => 'text',
					'title' => $this->l('Link'),
					'callback' => 'showGroupLink',
					'callback_object' => 'bakedlookbook'
				),
			'active'					 => array(
				'title'		 => $this->l('Status'),
				'align'		 => 'center',
				'active'	 => 'groupstatus',
				'type'		 => 'bool',
				'orderby'	 => false,
				'width'		 => 25
			),
		);

		$helper						 = new HelperList();
		$helper->shopLinkType		 = '';
		$helper->simple_header		 = false;
		$helper->no_link			 = true;
		$helper->identifier			 = 'id_baked_look_book_group';
		$helper->actions			 = array( 'view', 'edit', 'delete' );
		$helper->show_toolbar		 = true;
		$helper->imageType			 = 'jpg';
		$helper->toolbar_btn['new']	 = array(
			'href'	 => AdminController::$currentIndex.'&configure='.$this->name.'&add'.$this->name.'group&token='.Tools::getAdminTokenLite('AdminModules'),
			'desc'	 => $this->l('Add a Group')
		);
		$helper->listTotal			 = count(BakedLookBookGroup::getAll());
		$helper->title				 = $this->l('Look Book Groups');
		$helper->table				 = 'baked_look_book_group';
		$helper->token				 = Tools::getAdminTokenLite('AdminModules');
		$helper->currentIndex		 = AdminController::$currentIndex.'&configure='.$this->name;
		return $helper;
	}

	public static function showGroupImage($value)
	{
			return '<img width="100" height="100" src="'._PS_BASE_URL_.__PS_BASE_URI__.'/modules/bakedlookbook/img/'.$value.'" />';
	}

	public function getPath()
	{
		return $this->_path;
	}

	public static function showLookBookImage($value)
	{
		return '<img src="'.$value.'" />';
	}

	protected function initListLookBook()
	{
		$this->fields_list = array(
			'id_baked_look_book'		 => array(
				'title'	 => $this->l('Id'),
				'width'	 => 120,
				'type'	 => 'text',
			),
			'id_baked_look_book_group'	 => array(
				'title'				 => $this->l('LookBook'),
				'width'				 => 120,
				'type'				 => 'text',
				'callback'			 => 'showLookBookGroupName',
				'callback_object'	 => 'bakedlookbook',
			),
			'url'						 => array(
				'title'	 => $this->l('Link'),
				'width'	 => 200,
				'type'	 => 'text',
			),
			'thumb_multi_lang'			 => array(
				'title'				 => $this->l('Image'),
				'type'				 => 'text',
				'callback'			 => 'showLookBookImage',
				'callback_object'	 => 'bakedlookbook',
				'width'				 => 300,
			),
			'position'					 => array(
				'title'		 => $this->l('Position'),
				'width'		 => 40,
				//'position'	 => 'position',
				'type'		 => 'text',
				'align'		 => 'center'
			),
			'active'					 => array(
				'title'		 => $this->l('Status'),
				'align'		 => 'center',
				'active'	 => 'lookbookstatus',
				'type'		 => 'bool',
				'orderby'	 => false,
				'width'		 => 25,
			),
		);

		$helper						 = new HelperList();
		$helper->module				 = $this;
		$helper->shopLinkType		 = '';
		$helper->simple_header		 = false;
		$helper->identifier			 = 'id_baked_look_book';
		$helper->actions			 = array( 'edit', 'delete' );
		$helper->show_toolbar		 = true;
		$helper->imageType			 = 'jpg';
		$helper->toolbar_btn['new']	 = array(
			'href'	 => AdminController::$currentIndex.'&configure='.$this->name.'&addbakedlookbook&id_baked_look_book_group='.(int)Tools::getValue('id_baked_look_book_group').'&token='.Tools::getAdminTokenLite('AdminModules'),
			'desc'	 => $this->l('Add a Look Book')
		);
		$helper->toolbar_btn['back'] = array(
			'href'	 => AdminController::$currentIndex.'&configure='.$this->name.'&token='.Tools::getAdminTokenLite('AdminModules'),
			'desc'	 => $this->l('Back to list')
		);

		$helper->title				 = $this->l('Look Books');
		$helper->table				 = $this->name;
		$helper->orderBy			 = 'position';
		$helper->orderWay			 = 'ASC';
		$id_lang					 = $this->context->language->id;
		$id_baked_look_book_group	 = (int)Tools::getValue('id_baked_look_book_group');
		$helper->listTotal			 = count(BakedLookBookClass::getAll($id_baked_look_book_group, $id_lang));
		$helper->position_identifier = 'id_baked_look_book';
		$this->context->smarty->assign('update_position_url', $this->context->link->getModuleLink('positions'));
		$helper->token			 = Tools::getAdminTokenLite('AdminModules');
		$helper->currentIndex	 = AdminController::$currentIndex.'&configure='.$this->name;
		return $helper;
	}

	private function _prepareHook($identify, $type = 1)
	{
		$look_book_group	 = BakedLookBookGroup::getSlideGroup($identify, $type);
		if (!is_array($look_book_group) || !count($look_book_group))
			return false;
		foreach ($look_book_group as &$v)
		{
			$v['easing'] = array_key_exists($v['easing'], self::$easing) ? self::$easing[$v['easing']]['name'] : 'swing';
			$look_book		 = BakedLookBookClass::getAll($v['id_baked_look_book_group'], $this->context->language->id, 1, 0);
			if (is_array($look_book) && count($look_book))
				$v['slide'] = $look_book;
			if ($v['location'] == 13 || $v['location'] == 14)
			{
				$loo_books		 = BakedLookBookClass::getAll($v['id_baked_look_book_group'], $this->context->language->id, 1, 1);
				if (is_array($loo_books) && count($loo_books))
					$v['look_books']	 = $loo_books;
			}
		}

		$this->smarty->assign(array(
			'look_book_group'		 => $look_book_group,
			'image_path'		 => _MODULE_DIR_.$this->name.'/views/images/',
		));
		return true;
	}

	public function hookDisplayBackOfficeHeader()
	{
		// Check if module is loaded
		if (Tools::getValue('configure') != $this->name)
			return false;

		// CSS
		$this->context->controller->addCSS($this->_path.'views/css/elusive-icons/elusive-webfont.css');
		$this->context->controller->addCSS($this->_path.'views/js/plugins/tipsy/tipsy.css');
		$this->context->controller->addCSS($this->_path.'views/css/style.css');
		$this->context->controller->addCSS($this->_path.'views/css/admin.css');
		// JS
		$this->context->controller->addJquery();
		$this->context->controller->addJS($this->_path.'views/js/plugins/jquery.transit/jquery.transit-0.9.9.min.js');
		$this->context->controller->addJS($this->_path.'views/js/plugins/tipsy/jquery.tipsy.js');
		$this->context->controller->addJS($this->_path.'views/js/jquery-ui-1.9.0.custom.min.js');
		$this->context->controller->addJS($this->_path.'views/js/admin.js');
		$this->context->smarty->assign(array(
			'coordinate_path' => $this->context->link->getModuleLink('bakedlookbook', 'coordinates'),
			'module_path' => $this->_path
		));
		return $this->display(__FILE__, 'dislay_back_office_header.tpl');
	}

	public function hookDisplayHeader()
	{
		$this->context->controller->addCSS(($this->_path).'css/bakedlookbook.css');
	}


	public function hookActionShopDataDuplication($params)
	{
		Db::getInstance()->execute('
		INSERT IGNORE INTO '._DB_PREFIX_.'st_camera_slideshow_group_shop (id_baked_look_book_group, id_shop)
		SELECT id_baked_look_book_group, '.(int)$params['new_id_shop'].'
		FROM '._DB_PREFIX_.'baked_look_book_group
		WHERE id_shop = '.(int)$params['old_id_shop']);
	}

	public function hookModuleRoutes($params)
    {
        $context = Context::getContext();
        $controller = Tools::getValue('controller', 0);

        //$lookbook_slug = Configuration::get('PH_BLOG_SLUG');
		$lookbook_slug = $this->l('lookbooks');

        $my_routes = array(
            /**
                Home
            **/
            // Home list
            'module-bakedlookbook-lookbooks' => array(
                'controller' => 'lookbooks',
                'rule' => $lookbook_slug,
                'keywords' => array(),
                'params' => array(
                    'fc' => 'module',
                    'module' => 'bakedlookbook',
                ),
            ),
            // Home pagination
            'module-bakedlookbook-detail' => array(
                'controller' => 'detail',
                'rule' => $lookbook_slug.'/detail/{id_look_book_group}',
                'keywords' => array(
                    'id_look_book_group' =>        array('regexp' => '[_a-zA-Z0-9-\pL]*', 'param' => 'id_look_book_group'),
                ),
                'params' => array(
                    'fc' => 'module',
                    'module' => 'bakedlookbook',
                ),
            )
        );

        return $my_routes;
    }

	protected function bkGetCacheId($key, $type = 'location', $name = null)
	{
		$cache_id = parent::getCacheId($name);
		return $cache_id.'_'.$key.'_'.$type;
	}

	/**
	 * Return the list of fields value
	 *
	 * @param object $obj Object
	 * @return array
	 */
	public function getFieldsValueSt($obj, $fields_form = 'fields_form')
	{
		foreach ($this->$fields_form as $fieldset)
			if (isset($fieldset['form']['input']))
				foreach ($fieldset['form']['input'] as $input)
					if (!isset($this->fields_value[$input['name']]))
						if (isset($input['type']) && $input['type'] == 'shop')
						{
							if ($obj->id)
							{
								$result	= Shop::getShopById((int)$obj->id, $this->identifier, $this->table);
								foreach ($result as $row)
									$this->fields_value['shop'][$row['id_'.$input['type']]][]	 = $row['id_shop'];
							}
						}
						elseif (isset($input['lang']) && $input['lang'])
							foreach (Language::getLanguages(false) as $language)
							{
								$fieldValue = $this->getFieldValueSt($obj, $input['name'], $language['id_lang']);
								if (empty($fieldValue))
								{
									if (isset($input['default_value']) && is_array($input['default_value']) && isset($input['default_value'][$language['id_lang']]))
										$fieldValue	 = $input['default_value'][$language['id_lang']];
									elseif (isset($input['default_value']))
										$fieldValue	 = $input['default_value'];
								}
								$this->fields_value[$input['name']][$language['id_lang']] = $fieldValue;
							}
						else
						{
							$fieldValue							 = $this->getFieldValueSt($obj, $input['name']);
							if ($fieldValue === false && isset($input['default_value']))
								$fieldValue							 = $input['default_value'];
							$this->fields_value[$input['name']]	 = $fieldValue;
						}

		return $this->fields_value;
	}

	/**
	 * Return field value if possible (both classical and multilingual fields)
	 *
	 * Case 1 : Return value if present in $_POST / $_GET
	 * Case 2 : Return object value
	 *
	 * @param object $obj Object
	 * @param string $key Field name
	 * @param integer $id_lang Language id (optional)
	 * @return string
	 */
	public function getFieldValueSt($obj, $key, $id_lang = null)
	{
		if ($id_lang)
			$default_value	 = ($obj->id && isset($obj->{$key}[$id_lang])) ? $obj->{$key}[$id_lang] : false;
		else
			$default_value	 = isset($obj->{$key}) ? $obj->{$key} : false;

		return Tools::getValue($key.($id_lang ? '_'.$id_lang : ''), $default_value);
	}

	public function getProdCover($id)
	{
		return Image::getCover($id);
	}

	public function getImg($id, $link)
	{
		$cover	 = Image::getCover($id);
		$img_url	 = $this->context->link->getImageLink($link, $cover['id_image']);
		return $img_url;
	}

	public static function showLookBookGroupName($value)
	{
		$look_book_group = new BakedLookBookGroup((int)$value);
		return $look_book_group->id ? $look_book_group->name : '-';
	}

	public static function showGroupLink($row, $value)
	{
		$link = new Link();
		return '<a href="'.$link->getModuleLink('bakedlookbook','detail',array('id_look_book_group' => (int)$value)).'" target="_blank">'.$link->getModuleLink('bakedlookbook','detail',array('id_look_book_group' => (int)$value)).'</a>';
	}
}