<?php
/**
 * Baked Look Book module
 *
 * @author    Baked Themes
 * @copyright Baked Themes
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 */

class BakedLookBookClass extends ObjectModel
{
	/** @var integer id*/
	public $id;
	/** @var integer group id*/
	public $id_baked_look_book_group;
	/** @var string banner image*/
	public $image;
	/** @var string banner thumb*/
	public $thumb;
	/** @var string banner description*/
	public $description;

	public $url;

	public $image_multi_lang;

	public $thumb_multi_lang;

	/** @var integer */
	public $active;

	public $new_window;

	/** @var integer */
	public $position;
	/** @var string */
	public $title;
	/**
	 * @see ObjectModel::$definition
	 */
	public static $definition = array(
		'table'     => 'baked_look_book',
		'primary'   => 'id_baked_look_book',
		'multilang' => true,
		'fields'    => array(
			'id_baked_look_book_group'   =>	array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt', 'required' => true),
			'image'                      =>	array('type' => self::TYPE_STRING, 'size' => 255),
			'thumb'                      =>	array('type' => self::TYPE_STRING, 'size' => 255),
			'active'                     =>	array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
			'new_window'                 =>	array('type' => self::TYPE_BOOL, 'validate' => 'isBool'),
			'position'                   =>	array('type' => self::TYPE_INT, 'validate' => 'isunsignedInt'),
			'url'						 => array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isGenericName', 'size' => 255),
			'description'				 => array('type' => self::TYPE_HTML, 'lang' => true, 'validate' => 'isCleanHtml'),
			'title'						 =>	array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isGenericName', 'size' => 255),
			'image_multi_lang'           =>	array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isGenericName', 'size' => 255),
			'thumb_multi_lang'           =>	array('type' => self::TYPE_STRING, 'lang' => true, 'validate' => 'isGenericName', 'size' => 255),
		)
	);

	public static function getAll($id_baked_look_book_group, $id_lang, $active = 0)
	{
		if (!Validate::isUnsignedId($id_lang))
			die(Tools::displayError());
		return Db::getInstance()->executeS('
			SELECT bklb.*, bklbl.*
			FROM `'._DB_PREFIX_.'baked_look_book` bklb
			LEFT JOIN `'._DB_PREFIX_.'baked_look_book_lang` bklbl ON (bklb.`id_baked_look_book` = bklbl.`id_baked_look_book`)
			WHERE bklbl.`id_lang` = '.(int)$id_lang.' AND bklb.`id_baked_look_book_group`='.(int)$id_baked_look_book_group.'
			'.(($active) ? 'bklbl.`active` = 1' : '').'
            ORDER BY bklb.`position`
            ');
	}

	public function updatePosition($way, $position)
	{
		if (!$res = Db::getInstance()->executeS('
			SELECT `id_baked_look_book`, `position`, `id_baked_look_book_group`
			FROM `'._DB_PREFIX_.'baked_look_book`
			WHERE `id_baked_look_book_group` = '.(int)$this->id_baked_look_book_group.'
			ORDER BY `position` ASC'
		))
			return false;

		foreach ($res as $slide)
			if ((int)$slide['id_baked_look_book'] == (int)$this->id)
				$moved_slide = $slide;

		if (!isset($moved_slide) || !isset($position))
			return false;

		return (Db::getInstance()->execute('
			UPDATE `'._DB_PREFIX_.'baked_look_book`
			SET `position`= `position` '.($way ? '- 1' : '+ 1').'
			WHERE `position`
			'.($way
				? '> '.(int)$moved_slide['position'].' AND `position` <= '.(int)$position
				: '< '.(int)$moved_slide['position'].' AND `position` >= '.(int)$position).'
			AND `id_baked_look_book_group`='.(int)$moved_slide['id_baked_look_book_group'])
		&& Db::getInstance()->execute('
			UPDATE `'._DB_PREFIX_.'baked_look_book`
			SET `position` = '.(int)$position.'
			WHERE `id_baked_look_book` = '.(int)$moved_slide['id_baked_look_book']));
	}

	public function checkPosition()
	{
		$check = Db::getInstance()->getValue('
			SELECT count(0)
			FROM `'._DB_PREFIX_.'baked_look_book`
			WHERE `id_baked_look_book_group` = '.(int)$this->id_baked_look_book_group.' AND `position`='.(int)$this->position.($this->id ? ' AND `id_baked_look_book`!='.$this->id : '')
		);
		if ($check)
			return Db::getInstance()->getValue('
    			SELECT `position`+1
    			FROM `'._DB_PREFIX_.'baked_look_book`
    			WHERE `id_baked_look_book_group` = '.(int)$this->id_baked_look_book_group.'
                ORDER BY `position` DESC'
			);
		return $this->position;
	}

	public static function getOptions()
	{
		return Db::getInstance()->executeS('SELECT `id_baked_look_book`,
													`title_color`, `title_bg`, `title_font_family`, `description_color`, `description_bg`
											FROM `'._DB_PREFIX_.'baked_look_book`
											WHERE `active` = 1
		');
	}

	public function getCoordinates($id_look_book, $id_lang, $id_shop)
	{
		return Db::getInstance()->ExecuteS('SELECT *
										FROM `'._DB_PREFIX_.'baked_look_book_points`
										WHERE `id_lang` ='.$id_lang.'
										AND `id_shop` = '.$id_shop.'
										AND `id_baked_look_book` ='.$id_look_book);
	}

	public function getLookBooksByGroup($id_look_book_group, $id_lang)
	{
		$sql = 'SELECT * FROM `'._DB_PREFIX_.'baked_look_book` blb
				JOIN `'._DB_PREFIX_.'baked_look_book_lang` blbl
						ON (blbl.`id_baked_look_book` = blb.`id_baked_look_book` AND blbl.`id_lang` = '.$id_lang.')
				WHERE 1 = 1
					AND blb.`id_baked_look_book_group` = '.$id_look_book_group;
		return Db::getInstance()->executeS($sql);
	}

	public function delete()
	{
		if ($this->image && file_exists(_PS_ROOT_DIR_.$this->image))
			@unlink(_PS_ROOT_DIR_.$this->image);
		if ($this->thumb && file_exists(_PS_ROOT_DIR_.$this->thumb))
			@unlink(_PS_ROOT_DIR_.$this->thumb);

		if (isset($this->image_multi_lang) && count($this->image_multi_lang))
			foreach ($this->image_multi_lang as $v)
				if ($v && file_exists(_PS_ROOT_DIR_.$v))
					@unlink(_PS_ROOT_DIR_.$v);

		if (isset($this->thumb_multi_lang) && count($this->thumb_multi_lang))
			foreach ($this->thumb_multi_lang as $v)
				if ($v && file_exists(_PS_ROOT_DIR_.$v))
					@unlink(_PS_ROOT_DIR_.$v);

		return parent::delete();
	}
}