<?php

class BestSalesController extends BestSalesControllerCore
{
	public function initContent()
	{
		parent::initContent();

		$this->productSort();
		$nbProducts = (int)ProductSale::getNbSales();
		$this->pagination($nbProducts);

		$best_products = ProductSale::getBestSales($this->context->language->id, $this->p - 1, $this->n, $this->orderBy, $this->orderWay);

		$image_array = array( );
		for ($i = 0; $i < $nbProducts; $i++)
		{
			if (isset($best_products[$i]['id_product']))
				$image_array[$best_products[$i]['id_product']] = Product::getHoverProductsImgs($best_products[$i]['id_product']);
		}
		$this->context->smarty->assign('bakedimages', (isset($image_array) AND $image_array) ? $image_array : NULL);
		$this->context->smarty->assign(array(
			'products'				 => $best_products,
			'add_prod_display'		 => Configuration::get('PS_ATTRIBUTE_CATEGORY_DISPLAY'),
			'nbProducts'			 => $nbProducts,
			'homeSize'				 => Image::getSize(ImageType::getFormatedName('home')),
			'comparator_max_item'	 => Configuration::get('PS_COMPARATOR_MAX_ITEM')
		));

		$this->setTemplate(_PS_THEME_DIR_.'best-sales.tpl');
	}

}