<?php
/*
* 2007-2012 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2012 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class bakedfooterlinks extends Module
{
	public function __construct()
	{
		$this->name = 'bakedfooterlinks';
		$this->tab = 'front_office_features';
		$this->version = '1.0';
		$this->author = 'Baked Themes';
		$this->need_instance = 0;
		$this->bootstrap = true;


		parent::__construct();

		$this->displayName = $this->l('Baked Footer Links');
		$this->description = $this->l('Display extra links in the footer');
		$path = dirname(__FILE__);
		if (strpos(__FILE__, 'Module.php') !== false)
			$path .= '/../modules/'.$this->name;
		include_once $path.'/bakedfooterlinksClass.php';
	}

	public function install()
	{
		if (!parent::install() || !$this->registerHook('displayHeader') || !$this->registerHook('Displaybottomfooter'))
			return false;

		$res = Db::getInstance()->execute('
			CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bakedfooterlinks` (
			`id_bakedfooterlinks` int(10) unsigned NOT NULL auto_increment,
			`id_shop` int(10) unsigned NOT NULL ,
			PRIMARY KEY (`id_bakedfooterlinks`))
			ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8');

		if ($res)
			$res &= Db::getInstance()->execute('
				CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bakedfooterlinks_lang` (
				`id_bakedfooterlinks` int(10) unsigned NOT NULL,
				`id_lang` int(10) unsigned NOT NULL,
				`body_paragraph` text NOT NULL,
				PRIMARY KEY (`id_bakedfooterlinks`, `id_lang`))
				ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8');


		if ($res)
			foreach
			(Shop::getShops(false) as $shop)
				$res &= $this->createExampleEditorial($shop['id_shop']);

			if (!$res)
				$res &= $this->uninstall();

			return $res;
	}

	private function createExampleEditorial($id_shop)
	{
		$editorial = new bakedfooterlinksClass();
		$editorial->id_shop = (int)$id_shop;
		foreach (Language::getLanguages(false) as $lang)
		{
			$editorial->body_paragraph[$lang['id_lang']] = '<ul><li>About Us</li><li>Contact</li><li>Terms &amp; Conditions</li><li>My Account</li></ul>';
		}
		return $editorial->add();
	}

	public function uninstall()
	{
		$res = Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'bakedfooterlinks`');
		$res &= Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'bakedfooterlinks_lang`');

		if (!$res || !parent::uninstall())
			return false;

		return true;
	}

	private function initForm()
	{
		$languages = Language::getLanguages(false);
		foreach ($languages as $k => $language)
			$languages[$k]['is_default'] = (int)($language['id_lang'] == Configuration::get('PS_LANG_DEFAULT'));

		$helper = new HelperForm();
		$helper->module = $this;
		$helper->name_controller = 'bakedfooterlinks';
		$helper->identifier = $this->identifier;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->languages = $languages;
		$helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
		$helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
		$helper->allow_employee_form_lang = true;
		$helper->toolbar_scroll = true;
		$helper->toolbar_btn = $this->initToolbar();
		$helper->title = $this->displayName;
		$helper->submit_action = 'submitUpdateHtml';

		$this->fields_form[0]['form'] = array(
			'tinymce' => true,
			'legend' => array(
				'title' => $this->displayName,

			),
			'submit' => array(
				'name' => 'submitUpdateHtml',
				'title' => $this->l('   Save   '),
				'class' => 'button'
			),
			'input' => array(
				array(
					'type' => 'textarea',
					'label' => $this->l('Insert links'),
					'name' => 'body_paragraph',
					'lang' => true,
					'autoload_rte' => true,
					'hint' => $this->l('Add links or content to anywhere on your site'),
					'cols' => 60,
					'rows' => 30
				)
			)
		);
		return $helper;
	}

	private function initToolbar()
	{
		$this->toolbar_btn['save'] = array(
			'href' => '#',
			'desc' => $this->l('Save')
		);

		return $this->toolbar_btn;
	}

	public function getContent()
	{
		$this->_html = '';
		$this->postProcess();

		$helper = $this->initForm();
		$id_shop = (int)$this->context->shop->id;
		$editorial = bakedfooterlinksClass::getByIdShop($id_shop);

		if (!$editorial) //if editorial ddo not exist for this shop => create a new example one
			$this->createExampleEditorial($id_shop);

		foreach($this->fields_form[0]['form']['input'] as $input) //fill all form fields
				$helper->fields_value[$input['name']] = $editorial->{$input['name']};

		$this->_html .= $helper->generateForm($this->fields_form);
		return $this->_html;
	}

	public function postProcess()
	{
		$errors = '';
		$id_shop = (int)$this->context->shop->id;
		// Delete logo image

		if (Tools::isSubmit('submitUpdateHtml'))
		{
			$id_shop = (int)$this->context->shop->id;
			$editorial = bakedfooterlinksClass::getByIdShop($id_shop);
			$editorial->copyFromPost();
			$editorial->update();
			$this->_html .= $errors == '' ? $this->displayConfirmation($this->l('Settings updated successfully')) : $errors;
		}
	}

	public function hookDisplayHeader()
	{
		$this->context->controller->addCSS(($this->_path).'bakedfooterlinks.css', 'all');
	}

	public function displayContentToFront($position)
	{
		if (!$this->isCached('bakedfooterlinks.tpl', $this->getCacheId(null)))
		{
			$id_shop	 = (int)$this->context->shop->id;
			$editorial	 = bakedfooterlinksClass::getByIdShop($id_shop);
			$editorial	 = new bakedfooterlinksClass((int)$editorial->id, $this->context->language->id);

			if (!$editorial)
				return;
			$id_product	 = Tools::getValue('id_product');
			$product	 = new Product($id_product);
			$accessories = $product->getAccessories($this->context->language->id);

			if ($accessories)
			{
				$show = 0;
			}
			else
			{
				$show = 1;
			}

			//var_dump($accessories);
			$this->smarty->assign(array(
				'editorial'		 => $editorial,
				'show'			 => $show,
				'default_lang'	 => (int)$this->context->language->id,
				'position'		 => $position
			));
		}
		return $this->display(__FILE__, 'bakedfooterlinks.tpl', $this->getCacheId(null));
	}

	public function hookDisplaybottomfooter()
	{
		return $this->displayContentToFront('Displaybottomfooter');
	}

	public function hookDisplayLeftColumn()
	{
		return $this->Displaybottomfooter();
	}



}
