<?php

if (!defined('_CAN_LOAD_FILES_')){
	define('_CAN_LOAD_FILES_',1);
}
/**
 * bakeddeal Class
 */
include_once(dirname(__FILE__).'/classes/ClassBakedDeal.php');
if( !class_exists('bakedParams') )
	require_once(_PS_MODULE_DIR_ . '/bakery/libs/params.php');

class BakedDeal extends Module
{
	private $_params = '';
    private $_postErrors = array();
    function __construct(){
		$this->name = 'bakeddeal';
		parent::__construct();
		$this->tab = 'Bakedthemes';
		$this->version = '2.0';
		$this->displayName = $this->l('Baked Deals Module');
		$this->description = $this->l('Display info of your store deals');
		$this ->author = 'Baked themes';
        $this->bootstrap = true;
        $this->secure_key = Tools::encrypt($this->name);
        $this->module_key = 'fd6772f6110c1297900a607d1fa9e625';

		$this->_params = new BakedParams( $this->name, $this );
	}

    public function initConfigs(){
        return array(
            'theme' => 'default',
            'img_size' => 'home_default',
            'description' => 'intro_text',
            'des_max_chars' => '100',
            'limitonmodule' => '8',
            'limitonpage' => '8,12,16,20',
            'home_sorce' => 'selectcat',
            'categoryBox' => '',
            'productids' => '1,2,3,4,5',
            'orderby' => 'latest',
            'show_date' => '1',
            'show_des' => '1',
            'show_addcart' => '0',
            'show_filter' => '1',
            'count_bought' => 'quantity',
            'showdeal' => 'recently',
        );
    }
   /**
    * process installing
    */
	function install(){
		if (!parent::install())
			return false;
		if(!$this->registerHook('displayFloatDeal'))
			return false;
		if(!$this->registerHook('header'))
			return false;
		if(!$this->registerHook('home'))
			return false;

        $configs = $this->initConfigs();
        $this->_params->batchUpdate( $configs );
		return true;
	}

    public function uninstall(){
		return parent::uninstall();
	}

    /**
    * Render processing form && process saving data.
    */
	public function getContent()
	{
		$html = "";
		if (Tools::isSubmit('submitUpdate')) {
			$this->_postValidation();
			if (!sizeof($this->_postErrors)){
		        $configs = $this->initConfigs();
                $res = $this->_params->batchUpdate( $configs );
                if (!$res)
                    $html .= $this->displayError($this->l('Configuration could not be updated'));
                else
                    $html .= $this->displayConfirmation($this->l('Configuration updated'));
			}else{
				foreach ($this->_postErrors AS $err) {
					$html .= '<div class="alert alert-danger">'.$err.'</div>';
				}
			}
		}
		return $html.$this->initForm();
	}

    protected function initForm()
	{
        $this->context->controller->addJS(_MODULE_DIR_.$this->name.'/assets/admin/form.js');
        $configs = $this->initConfigs();
        $params = $this->_params;
        $themes = $params->getFolderList( dirname(__FILE__)."/views/templates/hook/" );
        $images = ImageType::getImagesTypes( 'products' );
        $mainImgSize = array();
        foreach ($images as $image){
            $mainImgSize[] = array('id' => $image['name'], 'name' => $image['name'].'('.$image['width']."x".$image['height'].')');
        }
        $showDes[] = array('id' => "intro_text", 'name' => $this->l('Short description'));
        $showDes[] = array('id' => "description", 'name' => $this->l('Description'));
        $home_sorces[] = array('id' => "selectcat", 'name' => $this->l('Select category'));
        $home_sorces[] = array('id' => "productids", 'name' => $this->l('Product IDs'));
        $arrSortBy = array(array( "id" => "latest", "name" => $this->l('Lastest')),
                            array( "id" => "price_lowest_first", "name" => $this->l('Price: lowest first')),
                            array( "id" => "price_highest_first", "name" => $this->l('Price: highest first')),
                            array( "id" => "name_a_z", "name" => $this->l('Product Name: A to Z')),
                            array( "id" => "name_z_a", "name" => $this->l('Product Name: Z to A')),
                            array( "id" => "in_stock", "name" => $this->l('In-stock first')),
                            array( "id" => 'finish_earliest_date', "name" => $this->l('Finish date: earliest first')),
                            array( "id" => 'finish_latest_date', "name" => $this->l('Finish date: latest first')),
                            );
        $count_bought = array(
            array( "id" => "none", "name" => $this->l('None')),
            array( "id" => "customer", "name" => $this->l('Count Customers')),
            array( "id" => "quantity", "name" => $this->l('Count quantity products'))
        );
        $date_types = array(
            array( "id" => "recently", "name" => $this->l('Current Deal')),
            array( "id" => "future", "name" => $this->l('Future Deal')),
            array( "id" => "finished", "name" => $this->l('Finished Deal'))
        );
		$this->fields_form[0]['form'] = array(
			'legend' => array(
				'title' => $this->l('General Setting'),
                'icon' => 'icon-cogs'
			),
			'input' => array(
                $params->selectTags('theme', 'Theme - Layout', $themes),
                $params->selectTags('img_size', 'Image Size', $mainImgSize),
                $params->selectTags('description', 'Description', $showDes),
                $params->inputTags('des_max_chars', 'Description Max Chars', false),
                $params->inputTags('limitonmodule', 'Limit Items On Module',false, 'Limit Item when view module'),

                $params->inputTags('limitonpage', 'Limit items when filter', false, 'show list on filter'),
                $params->selectTags('home_sorce', 'Get Product From', $home_sorces),
                $params->categorySelectTags('categoryBox', 'Select Category', $this->_params->get('categoryBox')),
                $params->inputTags('productids', 'Product IDs', false),
                $params->selectTags('orderby', 'Order By', $arrSortBy),
                $params->switchTags('show_date', 'Display Date', 'Show expire date or show start date (future deal) in title'),
                $params->switchTags('show_des', 'Display Description'),
                $params->switchTags('show_addcart', 'Display Add To Cart'),
                $params->switchTags('show_filter', 'Display Filter'),
                $params->selectTags('count_bought', 'Bought quantity', $count_bought, array('id' => 'id', 'name' => 'name'), false, false, 'Display bought quanty by amount product or customers bought'),
                $params->selectTags('showdeal', 'Deal Type', $date_types, array('id' => 'id', 'name' => 'name'), false, true),
			),
			'submit' => array(
				'title' => $this->l('Save'),
			)
		);

        $helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table =  $this->table;
		$lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
		$helper->default_form_language = $lang->id;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;

		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submitUpdate';
		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues($configs),
			'languages' => $this->context->controller->getLanguages(),
			'id_language' => $this->context->language->id
		);

		return $helper->generateForm($this->fields_form);
	}

    public function getConfigFieldsValues($configs) {
        $return = $this->_params->getConfigFieldsValues($configs);
        $return['showdeal[]'] = explode(',', $this->_params->get('showdeal'));
        return $return;
    }
	/**
     * Process vadiation before saving data
     */
	private function _postValidation(){
		if (!Validate::isCleanHtml(Tools::getValue('des_max_chars')) || !is_numeric(Tools::getValue('des_max_chars')))
			$this->_postErrors[] = $this->l('The description max chars you entered was not allowed, sorry');
		if (!Validate::isCleanHtml(Tools::getValue('limitonmodule')) || !is_numeric(Tools::getValue('limitonmodule')))
			$this->_postErrors[] = $this->l('The Limit you entered was not allowed, sorry');
	}

	function hookHeader($params){
		$theme = $this->_params->get('theme');
		$this->context->controller->addCSS(_MODULE_DIR_.$this->name.'/views/templates/hook/'.$theme.'/assets/style.css', 'all');
		$this->context->controller->addCSS(_MODULE_DIR_.$this->name.'/views/templates/hook/'.$theme.'/assets/masonry.css', 'all');
		$this->context->controller->addJS(_MODULE_DIR_.$this->name.'/assets/countdown.js');
	}
	/*
	 * register hook right comlumn to display slide in right column
	 */
	function hookrightColumn($params){
		return $this->processHook( $params,"rightColumn");
	}
	/*
	 * register hook left comlumn to display slide in left column
	 */
	function hookleftColumn($params){
		return $this->processHook( $params,"leftColumn");
	}

	function hooktop($params){
		return $this->processHook( $params,"top");
	}

	function hookfooter($params){
		return $this->processHook( $params,"footer");
	}

	function hookHome($params){
		return $this->processHook( $params,"home");
	}
	/*
	 * register hook productfooter comlumn to display slide in product footer
	 */
	function hookDisplayRightColumnProduct($params){
		return $this->hookdisplayFloatDeal($params);
	}

	function hookdisplayFloatDeal($params)
	{
		$params		 = $this->_params;
		$theme		 = $params->get('theme');
		if (!$this->isCached($theme.'/productdetail.tpl', $this->getCacheId(null)))
		{
			$where		 = " AND p.`id_product` = ".(int)Tools::getValue('id_product');
			$showdeal	 = "recently,future,finished";
			$orderby	 = $params->get("orderby");
			$products	 = ClassBakedDeal::getList($this, $where, 0, 1, $orderby, $showdeal);
			if (!$products)
				return;
			//echo "<pre>".print_r($products,1); die;
			$this->smarty->assign(array(
				'bakeddeal_product'	 => $products[0],
				'id_lang'			 => $this->context->language->id,
			));
		}
		return $this->display(__FILE__, $theme.'/productdetail.tpl', $this->getCacheId(null));
	}

	/**
    * Proccess module by hook
    * $pparams: param of module
    * $pos: position call
    */
	public function getParam(){
		return $this->_params;
	}

	private function processHook($pparams, $pos = "left")
	{
		$params			 = $this->_params;
		$theme			 = $params->get('theme');
		if (!$this->isCached($theme.'/default.tpl', $this->getCacheId(null)))
		{

			$site_url		 = Tools::htmlentitiesutf8('http://'.$_SERVER['HTTP_HOST'].__PS_BASE_URI__);
			// get params
			$configs		 = $this->initConfigs();
			$config_datas	 = $this->_params->getConfigFieldsValues($configs);

			$selectCat = $params->get("categoryBox");

			$showdeal	 = trim($params->get("showdeal"));
			$limit		 = $params->get("limitonmodule");
			$orderby	 = $params->get("orderby", "");

			$where = "";
			if ($params->get("home_sorce") == "productids")
			{
				if ($params->get("productids", ""))
				{
					$proArray	 = explode(",", $params->get("productids"));
					$where		 = " AND p.id_product IN (0,".implode(',', $proArray).")";
				}
			}
			else
			{
				if ($selectCat != "" && $selectCat != "all")
				{
					$catArray	 = explode(",", $selectCat);
					$where		 = " AND cp.`id_category` IN (0,".implode(',', $catArray).")";
				}
			}
			$products = ClassBakedDeal::getList($this, $where, 0, $limit, $orderby, $showdeal);

			if (!$products)
				return;
			$this->smarty->assign(array(
				'bakeddeal_products' => $products,
				'bakeddeal_configs'	 => $config_datas,
				'id_lang'			 => $this->context->language->id,
			));
		}
		// render for content layout of module
		return $this->display(__FILE__, $theme.'/default.tpl', $this->getCacheId(null));
	}

	public function _clearCache($template, $cache_id = null, $compile_id = null){
		return parent::_clearCache($template, $cache_id, $compile_id);
	}


	function orderAmountDiscountInAProduct($productsl = array(),$type = 'all'){
		if(!$productsl || $type == 'all')
			return $productsl;
		$result = array();
		for($i=0; $i < count($productsl); $i++){
			$checkExist = false;
			$arrProductId = array();
			for($j = $i+1; $j < count($productsl); $j++){
				if($productsl[$i]['id_product'] == $productsl[$j]['id_product']){
					$checkExist = true;
					switch($type){
						case 'price_lowest':
							if( $productsl[$i]['reductionprice'] <= $productsl[$j]['reductionprice'] ){
								$productTG = $productsl[$i];
							}else{
								$productTG = $productsl[$j];
							}
							$arrProductId[] = $j;
						break;
						case 'price_highest':
							if( $productsl[$i]['reductionprice'] >= $productsl[$j]['reductionprice'] ){
								$productTG = $productsl[$i];
							}else{
								$productTG = $productsl[$j];
							}
							$arrProductId[] = $j;
						break;
					}
				}
			}
			if($checkExist){
				$productsl[$i] = $productTG;
				if($arrProductId){
					foreach($arrProductId as $id){
						unset($productsl[$id]);
					}
				}
				$baked_productsl = array();
				foreach($productsl as $bakedPro){
					$baked_productsl[] = $bakedPro;
				}
				$productsl = $baked_productsl;
			}
		}
		return $productsl;
	}
    /**
	 * get main image and thumb
	 *
	 * @param poiter $row .
	 * @return void
	 */
	public function parseImages( $product, $params ){
		$link = $this->context->link;
		$isRenderedMainImage = 	$params->get("cre_main_size",0);
		$mainImageSize       =  $params->get("img_size",'home');

		if( $isRenderedMainImage ) {
			$product["mainImge"] = $link->getImageLink($product["link_rewrite"], $product["id_image"] );
		} else{
			$product["mainImge"] = $link->getImageLink($product["link_rewrite"], $product["id_image"], $mainImageSize );
		}
		$product["thumbImge"] = $product["mainImge"];
		return $product;
	}
}