<?php
/*
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2014 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class bakedcontact extends Module
{
	public function __construct()
	{
		$this->name = 'bakedcontact';
		$this->tab = 'front_office_features';
		$this->version = '1';
		$this->author = 'Baked Themes';
		$this->need_instance = 0;
		$this->bootstrap = true;

		parent::__construct();

		$this->displayName = $this->l('Baked Contact');
		$this->description = $this->l('Add extra info to the contact page.');
		$path = dirname(__FILE__);
		if (strpos(__FILE__, 'Module.php') !== false)
			$path .= '/../modules/'.$this->name;
		include_once $path.'/bakedcontactClass.php';
	}

	public function install()
	{
		if (!parent::install() || !$this->registerHook('displayBakedContact') || !$this->registerHook('displayHeader'))
			return false;

		$res = Db::getInstance()->execute(
			'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bakedcontact` (
			`id_bakedcontact` int(10) unsigned NOT NULL auto_increment,
			`id_shop` int(10) unsigned NOT NULL ,
			`body_home_logo_link` varchar(255) NOT NULL,
			PRIMARY KEY (`id_bakedcontact`))
			ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8'
		);

		if ($res)
			$res &= Db::getInstance()->execute(
				'CREATE TABLE IF NOT EXISTS `'._DB_PREFIX_.'bakedcontact_lang` (
				`id_bakedcontact` int(10) unsigned NOT NULL,
				`id_lang` int(10) unsigned NOT NULL,
				`body_title` varchar(255) NOT NULL,
				`body_subheading` varchar(255) NOT NULL,
				`body_paragraph` text NOT NULL,
				`body_logo_subheading` varchar(255) NOT NULL,
				PRIMARY KEY (`id_bakedcontact`, `id_lang`))
				ENGINE='._MYSQL_ENGINE_.' DEFAULT CHARSET=utf8'
			);

		if ($res)
			foreach (Shop::getShops(false) as $shop)
				$res &= $this->createExamplebakedcontact($shop['id_shop']);

		if (!$res)
			$res &= $this->uninstall();

		return (bool)$res;
	}

	private function createExamplebakedcontact($id_shop)
	{
		$bakedcontact = new bakedcontactClass();
		$bakedcontact->id_shop = (int)$id_shop;
		$bakedcontact->body_home_logo_link = 'http://www.prestashop.com';
		foreach (Language::getLanguages(false) as $lang)
		{
			$bakedcontact->body_title[$lang['id_lang']] = 'Opening Hours';
			$bakedcontact->body_paragraph[$lang['id_lang']] = '</br><p>Monday - Friday</p><p><i class="fa fa-clock-o"></i> 9am - 6pm</p><p>Saturday - Sunday</p><p><i class="fa fa-clock-o"></i> 10am - 4pm</p></br><h1>Our Location</h1><hr class="hr_left"></br><p>42 avenue des Champs Elysees</p><p>75000</p> <p>Paris</p><p>France</p>';
			
		}

		return $bakedcontact->add();
	}

	public function uninstall()
	{
		$res = Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'bakedcontact`');
		$res &= Db::getInstance()->execute('DROP TABLE IF EXISTS `'._DB_PREFIX_.'bakedcontact_lang`');

		if ($res == 0 || !parent::uninstall())
			return false;

		return true;
	}

	private function initForm()
	{
		$languages = Language::getLanguages(false);
		foreach ($languages as $k => $language)
			$languages[$k]['is_default'] = (int)$language['id_lang'] == Configuration::get('PS_LANG_DEFAULT');

		$helper = new HelperForm();
		$helper->module = $this;
		$helper->name_controller = 'bakedcontact';
		$helper->identifier = $this->identifier;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->languages = $languages;
		$helper->currentIndex = AdminController::$currentIndex.'&configure='.$this->name;
		$helper->default_form_language = (int)Configuration::get('PS_LANG_DEFAULT');
		$helper->allow_employee_form_lang = true;
		$helper->toolbar_scroll = true;
		$helper->toolbar_btn = $this->initToolbar();
		$helper->title = $this->displayName;
		$helper->submit_action = 'submitUpdatebakedcontact';

		$file = dirname(__FILE__).'/img/homepage_logo_'.(int)$this->context->shop->id.'.jpg';
		$logo = (file_exists($file) ? '<img src="'.$this->_path.'img/homepage_logo_'.(int)$this->context->shop->id.'.jpg">' : '');

		$this->fields_form[0]['form'] = array(
			'tinymce' => true,
			'legend' => array(
				'title' => $this->displayName,
				
			),
			'submit' => array(
				'name' => 'submitUpdatebakedcontact',
				'title' => $this->l('Save '),
				'class' => 'button pull-right'
			),
			'input' => array(
				array(
					'type' => 'text',
					'label' => $this->l('Main title'),
					'name' => 'body_title',
					'lang' => true,
					'size' => 64,
					'desc' => $this->l('Give yourself a heading'),
				),
				
				array(
					'type' => 'textarea',
					'label' => $this->l('Extra info'),
					'name' => 'body_paragraph',
					'lang' => true,
					'autoload_rte' => true,
					'desc' => $this->l('Add any extra info you like'),
					'cols' => 60,
					'rows' => 30
				),
			
				
				
			)
		);

		return $helper;
	}

	private function initToolbar()
	{
		$this->toolbar_btn['save'] = array(
			'href' => '#',
			'desc' => $this->l('Save')
		);

		return $this->toolbar_btn;
	}

	public function getContent()
	{
		$this->_html = '';
		$this->postProcess();

		$helper = $this->initForm();

		$id_shop = (int)$this->context->shop->id;
		$bakedcontact = bakedcontactClass::getByIdShop($id_shop);

		if (!$bakedcontact) //if bakedcontact ddo not exist for this shop => create a new example one
			$this->createExamplebakedcontact($id_shop);

		foreach ($this->fields_form[0]['form']['input'] as $input) //fill all form fields
		{
			if ($input['name'] != 'body_homepage_logo')
				$helper->fields_value[$input['name']] = $bakedcontact->{$input['name']};
		}

		$file = dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg';
		$helper->fields_value['body_homepage_logo']['image'] = (file_exists($file) ? '<img src="'.$this->_path.'img/homepage_logo_'.(int)$id_shop.'.jpg">' : '');
		if ($helper->fields_value['body_homepage_logo'] && file_exists($file))
			$helper->fields_value['body_homepage_logo']['size'] = filesize($file) / 1000;

		$this->_html .= $helper->generateForm($this->fields_form);

		return $this->_html;
	}

	public function postProcess()
	{
		$errors = '';
		$id_shop = (int)$this->context->shop->id;
		// Delete logo image retrocompat 1.5
		if (Tools::isSubmit('deleteLogoImage') || Tools::isSubmit('deleteImage'))
		{
			if (!file_exists(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg'))
				$errors .= $this->displayError($this->l('This action cannot be made.'));
			else
			{
				unlink(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg');
				Configuration::updateValue('bakedcontact_IMAGE_DISABLE', 1);
				$this->_clearCache('bakedcontact.tpl');
				Tools::redirectAdmin('index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)Tab::getIdFromClassName('AdminModules').(int)$this->context->employee->id));
			}
			$this->_html .= $errors;
		}

		if (Tools::isSubmit('submitUpdatebakedcontact'))
		{
			$id_shop = (int)$this->context->shop->id;
			$bakedcontact = bakedcontactClass::getByIdShop($id_shop);
			$bakedcontact->copyFromPost();
			if (empty($bakedcontact->id_shop))
				$bakedcontact->id_shop = (int)$id_shop;
			$bakedcontact->save();

			/* upload the image */
			if (isset($_FILES['body_homepage_logo']) && isset($_FILES['body_homepage_logo']['tmp_name']) && !empty($_FILES['body_homepage_logo']['tmp_name']))
			{
				Configuration::set('PS_IMAGE_GENERATION_METHOD', 1);
				if (file_exists(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg'))
					unlink(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg');
				if ($error = ImageManager::validateUpload($_FILES['body_homepage_logo']))
					$errors .= $error;
				elseif (!($tmp_name = tempnam(_PS_TMP_IMG_DIR_, 'PS')) || !move_uploaded_file($_FILES['body_homepage_logo']['tmp_name'], $tmp_name))
					return false;
				elseif (!ImageManager::resize($tmp_name, dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg'))
					$errors .= $this->displayError($this->l('An error occurred while attempting to upload the image.'));
				if (isset($tmp_name))
					unlink($tmp_name);
			}
			$this->_html .= $errors == '' ? $this->displayConfirmation($this->l('Settings updated successfully.')) : $errors;
			if (file_exists(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg'))
			{
				list($width, $height, $type, $attr) = getimagesize(dirname(__FILE__).'/img/homepage_logo_'.(int)$id_shop.'.jpg');
				Configuration::updateValue('bakedcontact_IMAGE_WIDTH', (int)round($width));
				Configuration::updateValue('bakedcontact_IMAGE_HEIGHT', (int)round($height));
				Configuration::updateValue('bakedcontact_IMAGE_DISABLE', 0);
			}
			$this->_clearCache('bakedcontact.tpl');
			Tools::redirectAdmin('index.php?tab=AdminModules&configure='.$this->name.'&token='.Tools::getAdminToken('AdminModules'.(int)Tab::getIdFromClassName('AdminModules').(int)$this->context->employee->id));
		}

		return true;
	}

	public function hookdisplayBakedContact($params)
	{
		if (!$this->isCached('bakedcontact.tpl', $this->getCacheId()))
		{
			$id_shop = (int)$this->context->shop->id;
			$bakedcontact = bakedcontactClass::getByIdShop($id_shop);
			if (!$bakedcontact)
				return;
			$bakedcontact = new bakedcontactClass((int)$bakedcontact->id, $this->context->language->id);
			if (!$bakedcontact)
				return;
			$this->smarty->assign(
				array(
					'bakedcontact' => $bakedcontact,
					'default_lang' => (int)$this->context->language->id,
					'image_width' => Configuration::get('bakedcontact_IMAGE_WIDTH'),
					'image_height' => Configuration::get('bakedcontact_IMAGE_HEIGHT'),
					'id_lang' => $this->context->language->id,
					'homepage_logo' => !Configuration::get('bakedcontact_IMAGE_DISABLE') && file_exists('modules/bakedcontact/img/homepage_logo_'.(int)$id_shop.'.jpg'),
					'image_path' => $this->_path.'img/homepage_logo_'.(int)$id_shop.'.jpg'
				)
			);
		}

		return $this->display(__FILE__, 'bakedcontact.tpl', $this->getCacheId());
	}

	public function hookdisplayTopColumn($params)
	{
		if (!isset($this->context->controller->php_self) || $this->context->controller->php_self != 'index')
			return;
		return $this->hookDisplayHome($params);
	}

	public function hookDisplayHeader()
	{
		if (!isset($this->context->controller->php_self) || $this->context->controller->php_self != 'index')
			return;
		$this->context->controller->addCSS(($this->_path).'css/bakedcontact.css', 'all');
	}
}