<?php
/*
* 2007-2014 PrestaShop
*
* NOTICE OF LICENSE
*
* This source file is subject to the Academic Free License (AFL 3.0)
* that is bundled with this package in the file LICENSE.txt.
* It is also available through the world-wide-web at this URL:
* http://opensource.org/licenses/afl-3.0.php
* If you did not receive a copy of the license and are unable to
* obtain it through the world-wide-web, please send an email
* to license@prestashop.com so we can send you a copy immediately.
*
* DISCLAIMER
*
* Do not edit or add to this file if you wish to upgrade PrestaShop to newer
* versions in the future. If you wish to customize PrestaShop for your
* needs please refer to http://www.prestashop.com for more information.
*
*  @author PrestaShop SA <contact@prestashop.com>
*  @copyright  2007-2014 PrestaShop SA
*  @license    http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
*  International Registered Trademark & Property of PrestaShop SA
*/

if (!defined('_PS_VERSION_'))
	exit;

class bakedbrands extends Module
{
    public function __construct()
    {
        $this->name = 'bakedbrands';
        $this->tab = 'front_office_features';
        $this->version = 1;
		$this->author = 'Baked Themes';
		$this->need_instance = 0;

        $this->bootstrap = true;
		parent::__construct();	

		$this->displayName = $this->l('Baked Slider - Brands');
        $this->description = $this->l('Display your store brands on the homepage.');
		$this->ps_versions_compliancy = array('min' => '1.6', 'max' => _PS_VERSION_);
    }

	public function install()
	{
		$this->_clearCache('*');
		Configuration::updateValue('bakedbrands_DISPLAY_TEXT', true);
		Configuration::updateValue('bakedbrands_DISPLAY_TEXT_NB', 6);
		
		if (!parent::install()
			|| !$this->registerHook('header')
			|| !$this->registerHook('actionObjectManufacturerDeleteAfter')
			|| !$this->registerHook('actionObjectManufacturerAddAfter')
			|| !$this->registerHook('actionObjectManufacturerUpdateAfter')
			|| !$this->registerHook('displayTopColumn')
		)
			return false;

		return true;
	}

	public function hookDisplayTopColumn($params)
	{
		if (!$this->isCached('bakedbrands.tpl', $this->getCacheId()))
		{
			$manufacturers = Manufacturer::getManufacturers();
			foreach ($manufacturers as &$manufacturer)
			{
				$manufacturer['image'] = $this->context->language->iso_code.'-default';
				if (file_exists(_PS_MANU_IMG_DIR_.$manufacturer['id_manufacturer'].'-'.ImageType::getFormatedName('medium').'.jpg'))
					$manufacturer['image'] = $manufacturer['id_manufacturer'];
			}

			$this->smarty->assign(array(
				'manufacturers' => $manufacturers,
				'auto_scroll' => Configuration::get('bakedbrands_DISPLAY_TEXT'),
				'text_list_nb' => Configuration::get('bakedbrands_DISPLAY_TEXT_NB'),
				'display_link_manufacturer' => Configuration::get('PS_DISPLAY_SUPPLIERS'),
			));
		}
		return $this->display(__FILE__, 'bakedbrands.tpl', $this->getCacheId());
	}

	public function hookDisplayHome($params)
	{
		return $this->hookDisplayTopColumn($params);
	}
	
	public function hookDisplayHomeTabContent($params)
	{
		return $this->hookDisplayTopColumn($params);
	}
	
	public function getContent()
	{
		$output = '';
		if (Tools::isSubmit('submitbakedbrands'))
		{
			$auto_scroll = (int)(Tools::getValue('bakedbrands_DISPLAY_TEXT'));
			$text_nb = (int)(Tools::getValue('bakedbrands_DISPLAY_TEXT_NB'));
			if ($text_list && !Validate::isUnsignedInt($text_nb))
				$errors[] = $this->l('There is an invalid number of elements.');
			else
			{
				Configuration::updateValue('bakedbrands_DISPLAY_TEXT', $auto_scroll);
				Configuration::updateValue('bakedbrands_DISPLAY_TEXT_NB', $text_nb);
				$this->_clearCache('bakedbrands.tpl');
			}
			if (isset($errors) && count($errors))
				$output .= $this->displayError(implode('<br />', $errors));
			else
				$output .= $this->displayConfirmation($this->l('Settings updated.'));
		}
		return $output.$this->renderForm();
	}

	public function hookHeader($params)
	{
		$this->context->controller->addCSS(($this->_path).'bakedbrands.css', 'all');
		$this->context->controller->addJS($this->_path.'js/bakedbrands.js');
	}
	
	public function hookActionObjectManufacturerUpdateAfter($params)
	{
		$this->_clearCache('bakedbrands.tpl');
	}

	public function hookActionObjectManufacturerAddAfter($params)
	{
		$this->_clearCache('bakedbrands.tpl');
	}

	public function hookActionObjectManufacturerDeleteAfter($params)
	{
		$this->_clearCache('bakedbrands.tpl');
	}
	
	public function renderForm()
	{
		$fields_form = array(
			'form' => array(
				'legend' => array(
					'title' => $this->l('Settings'),
					'icon' => 'icon-cogs'
				),
				'input' => array(
					array(
						'type' => 'switch',
						'label' => $this->l('Auto play'),
						'name' => 'bakedbrands_DISPLAY_TEXT',
						'desc' => $this->l('Auto advance to next slide.'),
						'values' => array(
									array(
										'id' => 'active_on',
										'value' => 1,
										'label' => $this->l('Enabled')
									),
									array(
										'id' => 'active_off',
										'value' => 0,
										'label' => $this->l('Disabled')
									)
								),
					),
					array(
						'type' => 'text',
						'label' => $this->l('Number of elements to display'),
						'name' => 'bakedbrands_DISPLAY_TEXT_NB',
						'class' => 'fixed-width-xs'
					)
				),
				'submit' => array(
					'title' => $this->l('Save'),
				)
			),
		);
		
		$helper = new HelperForm();
		$helper->show_toolbar = false;
		$helper->table =  $this->table;
		$lang = new Language((int)Configuration::get('PS_LANG_DEFAULT'));
		$helper->default_form_language = $lang->id;
		$helper->allow_employee_form_lang = Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') ? Configuration::get('PS_BO_ALLOW_EMPLOYEE_FORM_LANG') : 0;
		$helper->identifier = $this->identifier;
		$helper->submit_action = 'submitbakedbrands';
		$helper->currentIndex = $this->context->link->getAdminLink('AdminModules', false).'&configure='.$this->name.'&tab_module='.$this->tab.'&module_name='.$this->name;
		$helper->token = Tools::getAdminTokenLite('AdminModules');
		$helper->tpl_vars = array(
			'fields_value' => $this->getConfigFieldsValues(),
			'languages' => $this->context->controller->getLanguages(),
			'id_language' => $this->context->language->id
		);

		return $helper->generateForm(array($fields_form));
	}
	
	public function getConfigFieldsValues()
	{		
		return array(
			'bakedbrands_DISPLAY_TEXT' => Tools::getValue('bakedbrands_DISPLAY_TEXT', Configuration::get('bakedbrands_DISPLAY_TEXT')),
			'bakedbrands_DISPLAY_TEXT_NB' => Tools::getValue('bakedbrands_DISPLAY_TEXT_NB', Configuration::get('bakedbrands_DISPLAY_TEXT_NB')),
		);
	}
}
